/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web.tag;

import java.io.IOException;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.tool.IToolVO;
import org.lamsfoundation.lams.tool.service.ILamsToolService;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class HelpTag
extends TagSupport {
    private static final Logger log = Logger.getLogger(HelpTag.class);
    private String module = null;
    private String page = null;
    private String toolSignature = null;

    public int doStartTag() throws JspException {
        try {
            HttpSession session = ((HttpServletRequest)this.pageContext.getRequest()).getSession();
            String language = null;
            String country = null;
            String helpURL = null;
            String fullURL = null;
            JspWriter writer = this.pageContext.getOut();
            writer.println("<div class='help'>");
            try {
                if (this.toolSignature != null && this.module != null) {
                    ILamsToolService toolService = (ILamsToolService)this.getContext().getBean("lamsToolService");
                    IToolVO tool = toolService.getToolBySignature(this.toolSignature);
                    helpURL = tool.getHelpUrl();
                    if (helpURL == null) {
                        return 0;
                    }
                    Locale locale = (Locale)session.getAttribute("org.apache.struts.action.LOCALE");
                    if (locale != null) {
                        language = locale.getLanguage();
                        country = locale.getCountry();
                    }
                    fullURL = helpURL + this.module + "#" + this.toolSignature + this.module + "-" + language + country;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("In help tag, url is " + fullURL));
                    }
                    writer.println("<img src=\"" + Configuration.get((String)ConfigurationKeys.SERVER_URL) + "images/help.jpg\" border=\"0\" width=\"25\" height=\"25\" onclick=\"window.open('" + fullURL + "', 'help')\"/>");
                } else if (this.page != null) {
                    writer.println("<img src=\"" + Configuration.get((String)ConfigurationKeys.SERVER_URL) + "images/help.jpg\" border=\"0\" width=\"25\" height=\"25\" onclick=\"window.open('" + Configuration.get((String)ConfigurationKeys.HELP_URL) + this.page + "', 'help')\"/>");
                } else {
                    log.error((Object)"HelpTag unable to write out due to unspecified values.");
                    writer.println("<img src=\"" + Configuration.get((String)ConfigurationKeys.SERVER_URL) + "images/css/warning.gif\" border=\"0\" width=\"20\" height=\"20\"/>");
                }
            }
            catch (NullPointerException npe) {
                log.error((Object)"HelpTag unable to write out due to NullPointerException. Most likely a required paramater was unspecified or incorrect.", (Throwable)npe);
                writer.println("<img src=\"" + Configuration.get((String)ConfigurationKeys.SERVER_URL) + "images/css/warning.gif\" border=\"0\" width=\"20\" height=\"20\"/>");
            }
            writer.println("</div>");
        }
        catch (IOException e) {
            log.error((Object)"HelpTag unable to write out due to IOException.", (Throwable)e);
        }
        return 0;
    }

    public int doEndTag() {
        return 6;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    private WebApplicationContext getContext() {
        WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.pageContext.getServletContext());
        return ctx;
    }

    public String getToolSignature() {
        return this.toolSignature;
    }

    public void setToolSignature(String toolSignature) {
        this.toolSignature = toolSignature;
    }

    public String getPage() {
        return this.module;
    }

    public void setPage(String page) {
        this.page = page;
    }
}

