/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web.tag;

import java.io.IOException;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.log4j.Logger;

public class HtmlTag
extends TagSupport {
    private static final Logger log = Logger.getLogger(HtmlTag.class);
    protected boolean xhtml = false;

    public boolean getXhtml() {
        return this.xhtml;
    }

    public void setXhtml(boolean xhtml) {
        this.xhtml = xhtml;
    }

    public int doStartTag() throws JspException {
        StringBuffer sb = new StringBuffer("<html");
        String language = null;
        String country = null;
        HttpSession session = ((HttpServletRequest)this.pageContext.getRequest()).getSession();
        Locale locale = (Locale)session.getAttribute("org.apache.struts.action.LOCALE");
        if (locale != null) {
            language = locale.getLanguage();
            country = locale.getCountry();
        }
        String direction = (String)session.getAttribute("page_direction");
        if (this.xhtml) {
            this.pageContext.setAttribute("org.apache.struts.globals.XHTML", (Object)"true", 1);
            sb.append(" xmlns=\"http://www.w3.org/1999/xhtml\"");
        }
        if (language != null) {
            sb.append(" lang=\"");
            sb.append(language);
            if (country != null) {
                sb.append("-");
                sb.append(country);
            }
            sb.append("\"");
        }
        if (this.xhtml && language != null) {
            sb.append(" xml:lang=\"");
            sb.append(language);
            if (country != null) {
                sb.append("-");
                sb.append(country);
            }
            sb.append("\"");
        }
        if (direction != null) {
            this.pageContext.setAttribute("page_direction", (Object)direction, 1);
            sb.append(" dir=\"");
            sb.append(direction);
            sb.append("\"");
        }
        sb.append(">");
        this.writeString(sb.toString());
        return 1;
    }

    private void writeString(String output) {
        try {
            JspWriter writer = this.pageContext.getOut();
            writer.println(output);
        }
        catch (IOException e) {
            log.error((Object)"HTML tag unable to write out HTML details due to IOException.", (Throwable)e);
        }
    }

    public int doEndTag() throws JspException {
        this.writeString("</html>");
        return 6;
    }

    public void release() {
        this.xhtml = false;
    }
}

