/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web.tag;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class MultiLinesOutputTag
extends SimpleTagSupport {
    private String value;
    private boolean escapeXml;

    public void doTag() throws JspException, IOException {
        if (StringUtils.isEmpty((String)this.value)) {
            this.getJspContext().getOut().write(this.value);
        }
        if (this.escapeXml) {
            String[] lines = this.value.split("\n");
            this.value = new String();
            for (String line : lines) {
                this.value = this.value + StringEscapeUtils.escapeXml((String)line) + "<br>";
            }
        } else {
            this.value = this.value.replaceAll("\n", "<BR>");
        }
        this.getJspContext().getOut().write(this.value.toString());
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean getEscapeXml() {
        return this.escapeXml;
    }

    public void setEscapeXml(boolean escapeXml) {
        this.escapeXml = escapeXml;
    }
}

