/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.webservice;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import org.apache.axis.MessageContext;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.contentrepository.RepositoryCheckedException;
import org.lamsfoundation.lams.integration.ExtServerOrgMap;
import org.lamsfoundation.lams.integration.ExtUserUseridMap;
import org.lamsfoundation.lams.integration.security.Authenticator;
import org.lamsfoundation.lams.integration.service.IntegrationService;
import org.lamsfoundation.lams.usermanagement.WorkspaceFolder;
import org.lamsfoundation.lams.usermanagement.exception.UserAccessDeniedException;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.webservice.LearningDesignRepository;
import org.lamsfoundation.lams.workspace.dto.FolderContentDTO;
import org.lamsfoundation.lams.workspace.service.IWorkspaceManagementService;
import org.lamsfoundation.lams.workspace.service.WorkspaceManagementService;
import org.lamsfoundation.lams.workspace.web.WorkspaceAction;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class LearningDesignRepositorySoapBindingImpl
implements LearningDesignRepository {
    private static Logger log = Logger.getLogger(LearningDesignRepositorySoapBindingImpl.class);
    private static MessageContext context = MessageContext.getCurrentContext();
    private static IntegrationService integrationService = (IntegrationService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)((HttpServlet)context.getProperty(HTTPConstants.MC_HTTP_SERVLET)).getServletContext()).getBean("integrationService");
    private static IWorkspaceManagementService service = (IWorkspaceManagementService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)((HttpServlet)context.getProperty(HTTPConstants.MC_HTTP_SERVLET)).getServletContext()).getBean("workspaceManagementService");
    private static MessageService msgService = service.getMessageService();

    public String getLearningDesigns(String serverId, String datetime, String hashValue, String username, String courseId, Integer mode, String country, String lang) throws RemoteException {
        try {
            ExtServerOrgMap serverMap = integrationService.getExtServerOrgMap(serverId);
            Authenticator.authenticate((ExtServerOrgMap)serverMap, (String)datetime, (String)username, (String)hashValue);
            ExtUserUseridMap userMap = integrationService.getExtUserUseridMap(serverMap, username);
            integrationService.getExtCourseClassMap(serverMap, userMap, courseId, country, lang);
            return this.buildContentTree(userMap.getUser().getUserId()).toString();
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage(), e);
        }
    }

    private ContentTreeNode buildContentTree(Integer userId) throws IOException, UserAccessDeniedException, RepositoryCheckedException {
        log.debug((Object)("User Id - " + userId));
        FolderContentDTO rootFolder = new FolderContentDTO(msgService.getMessage("label.workspace.root_folder"), msgService.getMessage("folder"), null, null, "Folder", Long.valueOf(WorkspaceAction.BOOTSTRAP_FOLDER_ID.longValue()), WorkspaceFolder.READ_ACCESS, null);
        ContentTreeNode root = new ContentTreeNode(rootFolder);
        FolderContentDTO userFolder = service.getUserWorkspaceFolder(userId);
        root.addChild(this.buildContentTreeNode(userFolder, userId));
        FolderContentDTO dummyOrgFolder = new FolderContentDTO(msgService.getMessage("organisations"), msgService.getMessage("folder"), null, null, "Folder", new Long(WorkspaceAction.ORG_FOLDER_ID.longValue()), WorkspaceFolder.READ_ACCESS, null);
        ContentTreeNode dummyOrgNode = new ContentTreeNode(dummyOrgFolder);
        Vector orgFolders = service.getAccessibleOrganisationWorkspaceFolders(userId);
        for (int i = 0; i < orgFolders.size(); ++i) {
            FolderContentDTO orgFolder = (FolderContentDTO)orgFolders.get(i);
            dummyOrgNode.addChild(this.buildContentTreeNode(orgFolder, userId));
        }
        root.addChild(dummyOrgNode);
        return root;
    }

    private ContentTreeNode buildContentTreeNode(FolderContentDTO folder, Integer userId) throws UserAccessDeniedException, RepositoryCheckedException {
        log.debug((Object)("build content tree node for folder - " + folder.getName()));
        ContentTreeNode node = new ContentTreeNode(folder);
        if (folder.getResourceType().equals("Folder")) {
            log.debug((Object)(folder.getName() + " is a folder"));
            WorkspaceFolder wsfolder = service.getWorkspaceFolder(folder.getResourceID().intValue());
            Vector<FolderContentDTO> items = service.getFolderContentsExcludeHome(userId, wsfolder, WorkspaceManagementService.MONITORING);
            for (int i = 0; i < items.size(); ++i) {
                FolderContentDTO content = items.get(i);
                node.addChild(this.buildContentTreeNode(content, userId));
            }
        }
        return node;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ContentTreeNode {
        FolderContentDTO content;
        List<ContentTreeNode> children;

        ContentTreeNode(FolderContentDTO content) {
            this.content = content;
            this.children = new LinkedList<ContentTreeNode>();
        }

        List<ContentTreeNode> getChildren() {
            return this.children;
        }

        void setChildren(List<ContentTreeNode> children) {
            this.children = children;
        }

        FolderContentDTO getContent() {
            return this.content;
        }

        void setContent(FolderContentDTO content) {
            this.content = content;
        }

        void addChild(FolderContentDTO content) {
            this.children.add(new ContentTreeNode(content));
        }

        void addChild(ContentTreeNode node) {
            this.children.add(node);
        }

        public String toString() {
            return '[' + this.convert() + ']';
        }

        String convert() {
            StringBuilder sb = new StringBuilder();
            if (this.content.getResourceType().equals("Folder")) {
                sb.append("['");
                sb.append(this.content.getName()).append("',").append("null").append(',');
                if (this.children.size() == 0) {
                    sb.append("['',null]");
                } else {
                    sb.append(this.children.get(0).convert());
                    for (int i = 1; i < this.children.size(); ++i) {
                        sb.append(',').append(this.children.get(i).convert());
                    }
                }
                sb.append(']');
            } else if (this.content.getResourceType().equals("LearningDesign")) {
                sb.append('[');
                sb.append('\'').append(this.content.getName()).append('\'').append(',').append('\'').append(this.content.getResourceID()).append('\'');
                sb.append(']');
            }
            return sb.toString();
        }
    }
}

