/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.webservice;

import java.rmi.RemoteException;
import java.util.Date;
import java.util.LinkedList;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import org.apache.axis.MessageContext;
import org.apache.axis.transport.http.HTTPConstants;
import org.lamsfoundation.lams.integration.ExtCourseClassMap;
import org.lamsfoundation.lams.integration.ExtServerOrgMap;
import org.lamsfoundation.lams.integration.ExtUserUseridMap;
import org.lamsfoundation.lams.integration.security.Authenticator;
import org.lamsfoundation.lams.integration.service.IntegrationService;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.monitoring.service.IMonitoringService;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.util.DateUtil;
import org.lamsfoundation.lams.webservice.LessonManager;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class LessonManagerSoapBindingImpl
implements LessonManager {
    private static MessageContext context = MessageContext.getCurrentContext();
    private static IntegrationService integrationService = (IntegrationService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)((HttpServlet)context.getProperty(HTTPConstants.MC_HTTP_SERVLET)).getServletContext()).getBean("integrationService");
    private static IMonitoringService monitoringService = (IMonitoringService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)((HttpServlet)context.getProperty(HTTPConstants.MC_HTTP_SERVLET)).getServletContext()).getBean("monitoringService");

    public Long startLesson(String serverId, String datetime, String hashValue, String username, long ldId, String courseId, String title, String desc, String countryIsoCode, String langIsoCode) throws RemoteException {
        try {
            ExtServerOrgMap serverMap = integrationService.getExtServerOrgMap(serverId);
            Authenticator.authenticate((ExtServerOrgMap)serverMap, (String)datetime, (String)username, (String)hashValue);
            ExtUserUseridMap userMap = integrationService.getExtUserUseridMap(serverMap, username);
            ExtCourseClassMap orgMap = integrationService.getExtCourseClassMap(serverMap, userMap, courseId, countryIsoCode, langIsoCode);
            Lesson lesson = monitoringService.initializeLesson(title, desc, Boolean.TRUE, ldId, orgMap.getOrganisation().getOrganisationId(), userMap.getUser().getUserId());
            this.createLessonClass(lesson, orgMap.getOrganisation(), userMap.getUser());
            monitoringService.startLesson(lesson.getLessonId().longValue(), userMap.getUser().getUserId());
            return lesson.getLessonId();
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage(), e);
        }
    }

    public Long scheduleLesson(String serverId, String datetime, String hashValue, String username, long ldId, String courseId, String title, String desc, String startDate, String countryIsoCode, String langIsoCode) throws RemoteException {
        try {
            ExtServerOrgMap serverMap = integrationService.getExtServerOrgMap(serverId);
            Authenticator.authenticate((ExtServerOrgMap)serverMap, (String)datetime, (String)username, (String)hashValue);
            ExtUserUseridMap userMap = integrationService.getExtUserUseridMap(serverMap, username);
            ExtCourseClassMap orgMap = integrationService.getExtCourseClassMap(serverMap, userMap, courseId, countryIsoCode, langIsoCode);
            Lesson lesson = monitoringService.initializeLesson(title, desc, Boolean.TRUE, ldId, orgMap.getOrganisation().getOrganisationId(), userMap.getUser().getUserId());
            this.createLessonClass(lesson, orgMap.getOrganisation(), userMap.getUser());
            Date date = DateUtil.convertFromLAMSFlashFormat((String)startDate);
            monitoringService.startLessonOnSchedule(lesson.getLessonId().longValue(), date, userMap.getUser().getUserId());
            return lesson.getLessonId();
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage(), e);
        }
    }

    public boolean deleteLesson(String serverId, String datetime, String hashValue, String username, long lsId) throws RemoteException {
        try {
            ExtServerOrgMap serverMap = integrationService.getExtServerOrgMap(serverId);
            Authenticator.authenticate((ExtServerOrgMap)serverMap, (String)datetime, (String)username, (String)hashValue);
            ExtUserUseridMap userMap = integrationService.getExtUserUseridMap(serverMap, username);
            monitoringService.removeLesson(lsId, userMap.getUser().getUserId());
            return true;
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage(), e);
        }
    }

    private void createLessonClass(Lesson lesson, Organisation organisation, User creator) {
        LinkedList<User> staffList = new LinkedList<User>();
        staffList.add(creator);
        LinkedList learnerList = new LinkedList();
        monitoringService.createLessonClassForLesson(lesson.getLessonId().longValue(), organisation, organisation.getName() + "Learners", learnerList, organisation.getName() + "Staff", staffList, creator.getUserId());
    }
}

