/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.webservice;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import org.apache.axis.MessageContext;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.integration.ExtServerOrgMap;
import org.lamsfoundation.lams.integration.security.Authenticator;
import org.lamsfoundation.lams.integration.service.IIntegrationService;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.service.ILessonService;
import org.lamsfoundation.lams.themes.CSSThemeVisualElement;
import org.lamsfoundation.lams.usermanagement.AuthenticationMethod;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.Role;
import org.lamsfoundation.lams.usermanagement.SupportedLocale;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.UserOrganisation;
import org.lamsfoundation.lams.usermanagement.UserOrganisationRole;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.webservice.Register;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class RegisterServiceSoapBindingImpl
implements Register {
    Logger log = Logger.getLogger(RegisterServiceSoapBindingImpl.class);
    private static MessageContext context = MessageContext.getCurrentContext();
    private static IUserManagementService service = (IUserManagementService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)((HttpServlet)context.getProperty(HTTPConstants.MC_HTTP_SERVLET)).getServletContext()).getBean("userManagementService");
    private static ILessonService lessonService = (ILessonService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)((HttpServlet)context.getProperty(HTTPConstants.MC_HTTP_SERVLET)).getServletContext()).getBean("lessonService");
    private static IIntegrationService integrationService = (IIntegrationService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)((HttpServlet)context.getProperty(HTTPConstants.MC_HTTP_SERVLET)).getServletContext()).getBean("integrationService");

    public boolean createUser(String username, String password, String firstName, String lastName, String email, String serverId, String datetime, String hash) throws RemoteException {
        try {
            String htmlName;
            ExtServerOrgMap extServer = integrationService.getExtServerOrgMap(serverId);
            Authenticator.authenticate((ExtServerOrgMap)extServer, (String)datetime, (String)hash);
            if (service.getUserByLogin(username) != null) {
                return false;
            }
            User user = new User();
            user.setLogin(username);
            user.setPassword(password);
            user.setFirstName(firstName);
            user.setLastName(lastName);
            user.setEmail(email);
            user.setAuthenticationMethod((AuthenticationMethod)service.findById(AuthenticationMethod.class, (Serializable)AuthenticationMethod.DB));
            user.setCreateDate(new Date());
            user.setDisabledFlag(Boolean.valueOf(false));
            user.setLocale(this.getLocale());
            String flashName = Configuration.get((String)ConfigurationKeys.DEFAULT_FLASH_THEME);
            List list = service.findByProperty(CSSThemeVisualElement.class, "name", (Object)flashName);
            if (list != null && list.size() > 0) {
                CSSThemeVisualElement flashTheme = (CSSThemeVisualElement)list.get(0);
                user.setFlashTheme(flashTheme);
            }
            if ((list = service.findByProperty(CSSThemeVisualElement.class, "name", (Object)(htmlName = Configuration.get((String)ConfigurationKeys.DEFAULT_HTML_THEME)))) != null && list.size() > 0) {
                CSSThemeVisualElement htmlTheme = (CSSThemeVisualElement)list.get(0);
                user.setHtmlTheme(htmlTheme);
            }
            service.save((Object)user);
            return true;
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public boolean addUserToGroup(String username, String serverId, String datetime, String hash, Boolean isTeacher) throws RemoteException {
        try {
            ExtServerOrgMap extServer = integrationService.getExtServerOrgMap(serverId);
            Authenticator.authenticate((ExtServerOrgMap)extServer, (String)datetime, (String)hash);
            User user = service.getUserByLogin(username);
            Organisation org = extServer.getOrganisation();
            this.addMemberships(user, org, isTeacher);
            return true;
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public boolean addUserToSubgroup(String username, String orgId, String serverId, String datetime, String hash, Boolean isTeacher) throws RemoteException {
        try {
            ExtServerOrgMap extServer = integrationService.getExtServerOrgMap(serverId);
            Authenticator.authenticate((ExtServerOrgMap)extServer, (String)datetime, (String)hash);
            User user = service.getUserByLogin(username);
            Organisation group = extServer.getOrganisation();
            Organisation subgroup = (Organisation)service.findById(Organisation.class, (Serializable)new Integer(orgId));
            Set children = group.getChildOrganisations();
            for (Organisation child : children) {
                if (!child.getOrganisationId().equals(subgroup.getOrganisationId())) continue;
                this.addMemberships(user, subgroup, isTeacher);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public boolean addUserToGroupLessons(String username, String serverId, String datetime, String hash) throws RemoteException {
        try {
            ExtServerOrgMap extServer = integrationService.getExtServerOrgMap(serverId);
            Authenticator.authenticate((ExtServerOrgMap)extServer, (String)datetime, (String)hash);
            User user = service.getUserByLogin(username);
            Organisation org = extServer.getOrganisation();
            this.addUserToLessons(user, org);
            return true;
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public boolean addUserToSubgroupLessons(String username, String orgId, String serverId, String datetime, String hash) throws RemoteException {
        try {
            ExtServerOrgMap extServer = integrationService.getExtServerOrgMap(serverId);
            Authenticator.authenticate((ExtServerOrgMap)extServer, (String)datetime, (String)hash);
            User user = service.getUserByLogin(username);
            Organisation group = extServer.getOrganisation();
            Organisation subgroup = (Organisation)service.findById(Organisation.class, (Serializable)new Integer(orgId));
            Set children = group.getChildOrganisations();
            for (Organisation child : children) {
                if (!child.getOrganisationId().equals(subgroup.getOrganisationId())) continue;
                this.addUserToLessons(user, subgroup);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    private SupportedLocale getLocale() {
        String defaultLocale = Configuration.get((String)ConfigurationKeys.SERVER_LANGUAGE);
        return service.getSupportedLocale(defaultLocale.substring(0, 2), defaultLocale.substring(3));
    }

    private void addMemberships(User user, Organisation org, Boolean isTeacher) {
        this.log.debug((Object)("adding memberships for user " + user.getUserId() + " in " + org.getName()));
        UserOrganisation uo = new UserOrganisation(user, org);
        service.save((Object)uo);
        Integer[] roles = isTeacher != false ? new Integer[]{Role.ROLE_AUTHOR, Role.ROLE_MONITOR, Role.ROLE_LEARNER} : new Integer[]{Role.ROLE_LEARNER};
        for (Integer roleId : roles) {
            UserOrganisationRole uor = new UserOrganisationRole(uo, (Role)service.findById(Role.class, (Serializable)roleId));
            service.save((Object)uor);
            uo.addUserOrganisationRole(uor);
        }
        user.addUserOrganisation(uo);
        service.save((Object)user);
    }

    private void addUserToLessons(User user, Organisation org) {
        if (org.getLessons() != null) {
            for (Lesson lesson : org.getLessons()) {
                lessonService.addLearner(lesson.getLessonId(), user.getUserId());
                lessonService.addStaffMember(lesson.getLessonId(), user.getUserId());
                this.log.debug((Object)("Added " + user.getLogin() + " to " + lesson.getLessonName()));
            }
        }
    }
}

