/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.contentrepository;

import java.lang.reflect.Method;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.contentrepository.AccessDeniedException;
import org.lamsfoundation.lams.contentrepository.ICredentials;
import org.lamsfoundation.lams.contentrepository.ITicket;
import org.lamsfoundation.lams.contentrepository.RepositoryRuntimeException;
import org.lamsfoundation.lams.contentrepository.service.IRepositoryAdmin;
import org.springframework.aop.MethodBeforeAdvice;

public class CheckCredentialTicketBeforeAdvice
implements MethodBeforeAdvice {
    protected Logger log = Logger.getLogger(CheckCredentialTicketBeforeAdvice.class);

    public void before(Method m, Object[] args, Object target) throws AccessDeniedException, RepositoryRuntimeException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Method " + (m != null ? m.getName() : "null") + " Checking credential/ticket " + (args != null && args.length > 0 ? args[0] : "null")));
        }
        if (m != null && "toString".equals(m.getName())) {
            return;
        }
        if (args == null || args[0] == null) {
            throw new AccessDeniedException("No ticket/credential supplied. Access to repository denied.");
        }
        Object obj = args[0];
        if (ITicket.class.isInstance(obj)) {
            IRepositoryAdmin repository = (IRepositoryAdmin)target;
            if (!repository.isTicketOkay((ITicket)obj)) {
                this.log.error((Object)"Supplied ticket not recognised. It may have timed out. Please log in again.");
                throw new AccessDeniedException("Supplied ticket not recognised. It may have timed out. Please log in again.");
            }
        } else if (!ICredentials.class.isInstance(obj)) {
            String error = "Method has wrong signature. Method " + (m != null ? m.getName() : "null") + " has CheckCredentialTicketBeforeAdvice applied to it, but the first argument is a " + obj.getClass().getName() + ". It must be either a ICredential or a ITicket";
            this.log.error((Object)error);
            throw new RepositoryRuntimeException(error);
        }
    }
}

