/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.contentrepository;

import org.lamsfoundation.lams.contentrepository.RepositoryCheckedException;

public final class PropertyType {
    public static final int STRING = 1;
    public static final int LONG = 2;
    public static final int DOUBLE = 3;
    public static final int DATE = 4;
    public static final int BOOLEAN = 5;
    public static final int UNDEFINED = 0;
    public static final String TYPENAME_STRING = "String";
    public static final String TYPENAME_LONG = "Long";
    public static final String TYPENAME_DOUBLE = "Double";
    public static final String TYPENAME_DATE = "Date";
    public static final String TYPENAME_BOOLEAN = "Boolean";

    public static String nameFromValue(int type) throws RepositoryCheckedException {
        switch (type) {
            case 1: {
                return TYPENAME_STRING;
            }
            case 5: {
                return TYPENAME_BOOLEAN;
            }
            case 2: {
                return TYPENAME_LONG;
            }
            case 3: {
                return TYPENAME_DOUBLE;
            }
            case 4: {
                return TYPENAME_DATE;
            }
        }
        throw new RepositoryCheckedException("unknown type: " + type);
    }

    public static int valueFromName(String name) throws RepositoryCheckedException {
        if (name.equals(TYPENAME_STRING)) {
            return 1;
        }
        if (name.equals(TYPENAME_BOOLEAN)) {
            return 5;
        }
        if (name.equals(TYPENAME_LONG)) {
            return 2;
        }
        if (name.equals(TYPENAME_DOUBLE)) {
            return 3;
        }
        if (name.equals(TYPENAME_DATE)) {
            return 4;
        }
        throw new RepositoryCheckedException("unknown type: " + name);
    }

    private PropertyType() {
    }
}

