/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.contentrepository.client;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.contentrepository.FileException;
import org.lamsfoundation.lams.contentrepository.ITicket;
import org.lamsfoundation.lams.contentrepository.IValue;
import org.lamsfoundation.lams.contentrepository.IVersionedNode;
import org.lamsfoundation.lams.contentrepository.RepositoryCheckedException;
import org.lamsfoundation.lams.contentrepository.ValueFormatException;
import org.lamsfoundation.lams.contentrepository.service.IRepositoryService;

public abstract class Download
extends HttpServlet {
    public static final String UUID_NAME = "uuid";
    public static final String VERSION_NAME = "version";
    public static final String PREFER_DOWNLOAD = "preferDownload";
    protected static Logger log = Logger.getLogger(Download.class);
    private static final String expectedFormat = "Expected format /download?uuid<num>&version=<num>preferDownload=<true|false> (version number optional) or /download/<uuid>/<version>/<relPath>";

    public abstract ITicket getTicket() throws RepositoryCheckedException;

    public abstract IRepositoryService getRepositoryService() throws RepositoryCheckedException;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.handleCall(request, response);
        }
        catch (RepositoryCheckedException e) {
            log.error((Object)("Exception occured in download. Exception " + e.getMessage() + "Request URL was " + request.getRequestURL()), (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleCall(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, RepositoryCheckedException {
        long start = System.currentTimeMillis();
        ITicket ticket = this.getTicket();
        if (ticket == null) {
            throw new RepositoryCheckedException("Unable to get ticket - getTicket(false) returned null");
        }
        Long uuid = Download.getLong(request.getParameter(UUID_NAME));
        Long version = null;
        boolean saveFile = Download.getBoolean(request.getParameter(PREFER_DOWNLOAD));
        String callId = null;
        if (uuid != null) {
            version = Download.getLong(request.getParameter(VERSION_NAME));
            IVersionedNode node = this.getFileItem(ticket, uuid, version, null);
            version = node.getVersion();
            if (node.isNodeType("PACKAGENODE")) {
                String initialPage;
                IValue value = node.getProperty("INITIALPATH");
                String string = initialPage = value != null ? value.getString() : null;
                if (initialPage == null || initialPage.length() == 0) {
                    throw new RepositoryCheckedException("No initial page found for this set of content. Node Data is " + node.toString());
                }
                initialPage = request.getRequestURL() + "/" + uuid + "/" + version + "/" + initialPage + "?preferDownload=false";
                log.debug((Object)("Attempting to redirect to initial page " + initialPage));
                response.sendRedirect(initialPage);
                return;
            } else {
                if (!node.isNodeType("FILENODE")) throw new RepositoryCheckedException("Unsupported node type " + node.getNodeType() + ". Node Data is " + node.toString(), null);
                this.handleFileNode(response, node, saveFile);
            }
            return;
        } else {
            String pathString = request.getPathInfo();
            String[] strings = this.deriveIdFile(pathString);
            uuid = Download.getLong(strings[0]);
            version = Download.getLong(strings[1]);
            String relPathString = strings[2];
            callId = "download " + Math.random() + " " + uuid;
            if (uuid == null) {
                throw new RepositoryCheckedException("UUID value is missing. Expected format /download?uuid<num>&version=<num>preferDownload=<true|false> (version number optional) or /download/<uuid>/<version>/<relPath>");
            }
            if (version == null) {
                throw new RepositoryCheckedException("Version value is missing. Expected format /download?uuid<num>&version=<num>preferDownload=<true|false> (version number optional) or /download/<uuid>/<version>/<relPath>");
            }
            if (relPathString == null) {
                throw new RepositoryCheckedException("Filename is missing. Expected format /download?uuid<num>&version=<num>preferDownload=<true|false> (version number optional) or /download/<uuid>/<version>/<relPath>");
            }
            IVersionedNode node = this.getFileItem(ticket, uuid, version, relPathString);
            if (!node.isNodeType("FILENODE")) {
                throw new RepositoryCheckedException("Unexpected type of node " + node.getNodeType() + " Expected File node. Data is " + node);
            }
            this.handleFileNode(response, node, saveFile);
        }
    }

    private IVersionedNode getFileItem(ITicket ticket, Long uuid, Long version, String relPathString) throws RepositoryCheckedException {
        try {
            IVersionedNode node = null;
            node = relPathString != null ? this.getRepositoryService().getFileItem(ticket, uuid, version, relPathString) : this.getRepositoryService().getFileItem(ticket, uuid, version);
            return node;
        }
        catch (RuntimeException e) {
            log.error((Object)("Exception thrown calling repository.getFileItem(<ticket>," + uuid + "," + version + "," + relPathString + "). " + e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    protected void handleFileNode(HttpServletResponse response, IVersionedNode fileNode, boolean saveFile) throws IOException, FileException, ValueFormatException {
        String mimeType;
        IValue prop = fileNode.getProperty("MIMETYPE");
        String string = mimeType = prop != null ? prop.getString() : null;
        if (mimeType == null && (prop = fileNode.getProperty("FILENAME")) != null) {
            mimeType = this.getServletContext().getMimeType(prop.getString());
        }
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        response.setContentType(mimeType);
        prop = fileNode.getProperty("FILENAME");
        String filename = prop != null ? prop.getString() : null;
        log.debug((Object)("Downloading file " + filename + " mime type " + mimeType));
        if (saveFile) {
            log.debug((Object)"Sending as attachment");
            response.setHeader("Content-Disposition", "attachment;filename=\"" + filename + "\"");
        } else {
            log.debug((Object)"Sending as inline");
            response.setHeader("Content-Disposition", "inline;filename=\"" + filename + "\"");
        }
        response.setHeader("Cache-control", "must-revalidate");
        if (filename != null) {
            response.addHeader("Content-Description", filename);
        }
        BufferedInputStream in = new BufferedInputStream(fileNode.getFile());
        ServletOutputStream out = response.getOutputStream();
        try {
            int ch;
            int count = 0;
            while ((ch = ((InputStream)in).read()) != -1) {
                out.write((char)ch);
                ++count;
            }
            log.debug((Object)("Wrote out " + count + " bytes"));
            response.setContentLength(count);
            out.flush();
        }
        catch (IOException e) {
            log.error((Object)("Exception occured writing out file:" + e.getMessage()));
            throw e;
        }
        finally {
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"Error Closing file. File already written out - no exception being thrown.", (Throwable)e);
            }
        }
    }

    private String[] deriveIdFile(String pathInfo) {
        String[] result = new String[3];
        if (pathInfo != null) {
            String[] strings = pathInfo.split("/", 4);
            int j = 0;
            for (int i = 0; i < strings.length && j < 3; ++i) {
                if (strings[i].length() <= 0) continue;
                result[j++] = strings[i];
            }
        }
        log.debug((Object)("Split path into following strings: '" + result[0] + "' '" + result[1] + "' '" + result[2]));
        return result;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected static Long getLong(String longAsString) {
        try {
            return new Long(longAsString);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    protected static boolean getBoolean(String booleanAsString) {
        return Boolean.valueOf(booleanAsString);
    }
}

