/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.contentrepository.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.contentrepository.AccessDeniedException;
import org.lamsfoundation.lams.contentrepository.FileException;
import org.lamsfoundation.lams.contentrepository.ITicket;
import org.lamsfoundation.lams.contentrepository.IValue;
import org.lamsfoundation.lams.contentrepository.IVersionedNode;
import org.lamsfoundation.lams.contentrepository.InvalidParameterException;
import org.lamsfoundation.lams.contentrepository.ItemExistsException;
import org.lamsfoundation.lams.contentrepository.ItemNotFoundException;
import org.lamsfoundation.lams.contentrepository.NodeKey;
import org.lamsfoundation.lams.contentrepository.RepositoryCheckedException;
import org.lamsfoundation.lams.contentrepository.ValueFormatException;
import org.lamsfoundation.lams.contentrepository.WorkspaceNotFoundException;
import org.lamsfoundation.lams.contentrepository.client.IToolContentHandler;
import org.lamsfoundation.lams.contentrepository.service.IRepositoryService;
import org.lamsfoundation.lams.contentrepository.service.SimpleCredentials;

public abstract class ToolContentHandler
implements IToolContentHandler {
    private IRepositoryService repositoryService;
    private ITicket ticket;
    private boolean productionMode = true;
    protected Logger log = Logger.getLogger((String)ToolContentHandler.class.getName());

    public abstract String getRepositoryWorkspaceName();

    public abstract String getRepositoryUser();

    public abstract char[] getRepositoryId();

    private void configureContentRepository() throws RepositoryCheckedException {
        SimpleCredentials cred = new SimpleCredentials(this.getRepositoryUser(), this.getRepositoryId());
        try {
            this.getRepositoryService().createCredentials(cred);
            this.getRepositoryService().addWorkspace(cred, this.getRepositoryWorkspaceName());
        }
        catch (ItemExistsException ie) {
            this.log.warn((Object)("Tried to configure repository but it  appears to be already configured.Workspace name " + this.getRepositoryWorkspaceName() + ". Exception thrown by repository being ignored. "), (Throwable)ie);
        }
        catch (RepositoryCheckedException e) {
            this.log.error((Object)("Error occured while trying to configure repository.Workspace name " + this.getRepositoryWorkspaceName() + " Unable to recover from error: " + e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    public ITicket getTicket(boolean forceLogin) throws RepositoryCheckedException {
        if (this.ticket == null || forceLogin) {
            SimpleCredentials cred = new SimpleCredentials(this.getRepositoryUser(), this.getRepositoryId());
            try {
                try {
                    this.ticket = this.getRepositoryService().login(cred, this.getRepositoryWorkspaceName());
                }
                catch (WorkspaceNotFoundException e) {
                    this.log.error((Object)("Content Repository workspace " + this.getRepositoryWorkspaceName() + " not configured. Attempting to configure now."));
                    this.configureContentRepository();
                    this.ticket = this.getRepositoryService().login(cred, this.getRepositoryWorkspaceName());
                }
            }
            catch (RepositoryCheckedException e) {
                this.log.error((Object)("Unable to get ticket for workspace " + this.getRepositoryWorkspaceName()), (Throwable)e);
                throw e;
            }
        }
        return this.ticket;
    }

    public NodeKey uploadFile(InputStream stream, String fileName, String mimeType, String fileProperty) throws RepositoryCheckedException, InvalidParameterException, RepositoryCheckedException {
        if (fileProperty == null) {
            throw new InvalidParameterException("uploadFile: fileProperty parameter empty. Should be either TYPE_ONLINE or TYPE_OFFLINE");
        }
        NodeKey nodeKey = null;
        try {
            try {
                nodeKey = this.getRepositoryService().addFileItem(this.getTicket(false), stream, fileName, mimeType, null);
            }
            catch (AccessDeniedException e) {
                this.log.warn((Object)("Unable to access repository to add file " + fileName + "AccessDeniedException: " + e.getMessage() + " Retrying login."));
                nodeKey = this.getRepositoryService().addFileItem(this.getTicket(true), stream, fileName, mimeType, null);
            }
            try {
                this.getRepositoryService().setProperty(this.getTicket(false), nodeKey.getUuid(), nodeKey.getVersion(), "TYPE", fileProperty, 1);
            }
            catch (AccessDeniedException e) {
                this.log.warn((Object)("Unable to access repository to set offline/online parameter " + fileName + "AccessDeniedException: " + e.getMessage() + " Retrying login."));
                this.getRepositoryService().setProperty(this.getTicket(true), nodeKey.getUuid(), nodeKey.getVersion(), "TYPE", fileProperty, 1);
            }
        }
        catch (RepositoryCheckedException e2) {
            this.log.warn((Object)("Unable to to uploadFile" + fileName + "Repository Exception: " + e2.getMessage() + " Retry not possible."));
            throw e2;
        }
        return nodeKey;
    }

    public NodeKey uploadPackage(String dirPath, String startFile) throws RepositoryCheckedException, InvalidParameterException, RepositoryCheckedException {
        this.log.error((Object)"uploadPackage(String dirPath, String startFile)  to be removed - it sets the owner of files in the content repository to 1. Some tool needs to be updated.");
        return this.uploadPackage(dirPath, startFile, new Integer(1));
    }

    public NodeKey uploadPackage(String dirPath, String startFile, Integer userId) throws RepositoryCheckedException, InvalidParameterException, RepositoryCheckedException {
        if (dirPath == null) {
            throw new InvalidParameterException("uploadFile: dirPath parameter empty. Directory containing files must be supplied");
        }
        NodeKey nodeKey = null;
        try {
            try {
                nodeKey = this.getRepositoryService().addPackageItem(this.getTicket(false), dirPath, startFile, null);
            }
            catch (AccessDeniedException e) {
                this.log.warn((Object)("Unable to access repository to add directory of files. AccessDeniedException: " + e.getMessage() + " Retrying login."));
                nodeKey = this.getRepositoryService().addPackageItem(this.getTicket(true), dirPath, startFile, null);
            }
        }
        catch (RepositoryCheckedException e2) {
            this.log.warn((Object)("Unable to access repository to add directory of files. Repository Exception: " + e2.getMessage() + " Retry not possible."));
            throw e2;
        }
        return nodeKey;
    }

    public void saveFile(Long uuid, String toFileName) throws ItemNotFoundException, RepositoryCheckedException, IOException {
        try {
            try {
                this.getRepositoryService().saveFile(this.getTicket(false), uuid, null, toFileName);
            }
            catch (AccessDeniedException e) {
                this.log.warn((Object)("Unable to access repository to add copy node " + uuid + "AccessDeniedException: " + e.getMessage() + " Retrying login."));
                this.getRepositoryService().saveFile(this.getTicket(false), uuid, null, toFileName);
            }
        }
        catch (ItemNotFoundException e) {
            this.log.warn((Object)("Unable to to save node " + uuid + " as the node cannot be found. Repository Exception: " + e.getMessage() + " Retry not possible."));
            throw e;
        }
        catch (RepositoryCheckedException e) {
            this.log.warn((Object)("Unable to to save node " + uuid + "Repository Exception: " + e.getMessage() + " Retry not possible."));
            throw e;
        }
    }

    public NodeKey copyFile(Long uuid) throws ItemNotFoundException, RepositoryCheckedException {
        this.log.error((Object)"copyFile(Long uuid) to be removed - it sets the owner of files in the content repository to 1. Some tool needs to be updated.");
        return this.copyFile(uuid, new Integer(1));
    }

    public NodeKey copyFile(Long uuid, Integer userId) throws ItemNotFoundException, RepositoryCheckedException {
        NodeKey nodeKey = null;
        try {
            try {
                nodeKey = this.getRepositoryService().copyNodeVersion(this.getTicket(false), uuid, null);
            }
            catch (AccessDeniedException e) {
                this.log.warn((Object)("Unable to access repository to add copy node " + uuid + "AccessDeniedException: " + e.getMessage() + " Retrying login."));
                nodeKey = this.getRepositoryService().copyNodeVersion(this.getTicket(true), uuid, null);
            }
        }
        catch (ItemNotFoundException e) {
            this.log.warn((Object)("Unable to to copy node " + uuid + " as the node cannot be found. Repository Exception: " + e.getMessage() + " Retry not possible."));
            throw e;
        }
        catch (RepositoryCheckedException e) {
            this.log.warn((Object)("Unable to to copy node " + uuid + "Repository Exception: " + e.getMessage() + " Retry not possible."));
            throw e;
        }
        return nodeKey;
    }

    public void deleteFile(Long uuid) throws InvalidParameterException, RepositoryCheckedException {
        try {
            try {
                this.getRepositoryService().deleteNode(this.getTicket(false), uuid);
            }
            catch (AccessDeniedException e) {
                this.log.warn((Object)("Unable to access repository to delete file id" + uuid + "AccessDeniedException: " + e.getMessage() + " Retrying login."));
                this.getRepositoryService().deleteNode(this.getTicket(true), uuid);
            }
        }
        catch (ItemNotFoundException e1) {
        }
        catch (RepositoryCheckedException e2) {
            this.log.error((Object)("Unable delete file id" + uuid + "Repository Exception: " + e2.getMessage() + " Retry not possible."));
            throw e2;
        }
    }

    public IVersionedNode getFileNode(Long uuid) throws ItemNotFoundException, FileException, RepositoryCheckedException {
        try {
            try {
                return this.getRepositoryService().getFileItem(this.getTicket(false), uuid, null);
            }
            catch (AccessDeniedException e) {
                this.log.warn((Object)("Unable to access repository to get file id" + uuid + "AccessDeniedException: " + e.getMessage() + " Retrying login."));
                return this.getRepositoryService().getFileItem(this.getTicket(true), uuid, null);
            }
        }
        catch (RepositoryCheckedException e2) {
            this.log.warn((Object)("Unable to to get file id" + uuid + "Repository Exception: " + e2.getMessage() + " Retry not possible."));
            throw e2;
        }
    }

    public Set getFileProperties(Long uuid) throws ItemNotFoundException, FileException, RepositoryCheckedException {
        try {
            try {
                IVersionedNode node = this.getRepositoryService().getFileItem(this.getTicket(false), uuid, null);
                return node != null ? node.getProperties() : null;
            }
            catch (AccessDeniedException e) {
                this.log.warn((Object)("Unable to access repository to get file id" + uuid + "AccessDeniedException: " + e.getMessage() + " Retrying login."));
                IVersionedNode node = this.getRepositoryService().getFileItem(this.getTicket(true), uuid, null);
                return node != null ? node.getProperties() : null;
            }
        }
        catch (RepositoryCheckedException e2) {
            this.log.warn((Object)("Unable to to get file id" + uuid + "Repository Exception: " + e2.getMessage() + " Retry not possible."));
            throw e2;
        }
    }

    public boolean isOffline(IVersionedNode node) {
        return this.checkType(node, "OFFLINE");
    }

    public boolean isOnline(IVersionedNode node) {
        return this.checkType(node, "ONLINE");
    }

    protected boolean checkType(IVersionedNode node, String expectedType) {
        IValue property = node.getProperty("TYPE");
        String value = null;
        try {
            value = property != null ? property.getString() : null;
        }
        catch (ValueFormatException e) {
            // empty catch block
        }
        return node != null && expectedType != null && expectedType.equals(value);
    }

    public IRepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public void setRepositoryService(IRepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }
}

