/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.contentrepository.client;

import javax.servlet.ServletContext;
import org.lamsfoundation.lams.contentrepository.ITicket;
import org.lamsfoundation.lams.contentrepository.RepositoryCheckedException;
import org.lamsfoundation.lams.contentrepository.client.Download;
import org.lamsfoundation.lams.contentrepository.client.IToolContentHandler;
import org.lamsfoundation.lams.contentrepository.service.IRepositoryService;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ToolDownload
extends Download {
    public static final String TOOL_CONTENT_HANDLER_BEAN_NAME = "toolContentHandlerBeanName";

    public ITicket getTicket() throws RepositoryCheckedException {
        IToolContentHandler toolContentHandler = this.getToolContentHandler();
        return toolContentHandler != null ? toolContentHandler.getTicket(false) : null;
    }

    public IRepositoryService getRepositoryService() throws RepositoryCheckedException {
        IToolContentHandler toolContentHandler = this.getToolContentHandler();
        return toolContentHandler != null ? toolContentHandler.getRepositoryService() : null;
    }

    protected IToolContentHandler getToolContentHandler() {
        log.debug((Object)"ToolDownload servlet calling context and getting repository singleton.");
        String toolContentHandlerBeanName = this.getInitParameter(TOOL_CONTENT_HANDLER_BEAN_NAME);
        if (toolContentHandlerBeanName == null) {
            log.error((Object)"Accessing Download servlet but tool content handler bean has not been defined. Please define init parametertoolContentHandlerBeanName.");
            return null;
        }
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        return (IToolContentHandler)wac.getBean(toolContentHandlerBeanName);
    }
}

