/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.contentrepository.dao.hibernate;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.lamsfoundation.lams.contentrepository.CrCredential;
import org.lamsfoundation.lams.contentrepository.ICredentials;
import org.lamsfoundation.lams.contentrepository.IWorkspace;
import org.lamsfoundation.lams.contentrepository.RepositoryRuntimeException;
import org.lamsfoundation.lams.contentrepository.dao.ICredentialDAO;
import org.lamsfoundation.lams.dao.hibernate.BaseDAO;

public class CredentialDAO
extends BaseDAO
implements ICredentialDAO {
    protected Logger log = Logger.getLogger(CredentialDAO.class);

    public boolean checkCredential(ICredentials credential, IWorkspace workspace) throws RepositoryRuntimeException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Checking credential " + credential + " for workspace " + workspace));
        }
        if (credential == null || workspace == null || workspace.getWorkspaceId() == null) {
            return false;
        }
        return this.checkCredentialInternal(credential, workspace);
    }

    public boolean checkCredential(ICredentials credential) throws RepositoryRuntimeException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Checking credential " + credential));
        }
        if (credential == null) {
            return false;
        }
        return this.checkCredentialInternal(credential, null);
    }

    public boolean checkCredentialInternal(ICredentials credential, IWorkspace workspace) throws RepositoryRuntimeException {
        boolean credentialMatched = false;
        Session hibernateSession = this.getSession();
        Connection conn = null;
        Statement ps = null;
        try {
            int val;
            conn = hibernateSession.connection();
            StringBuffer buf = new StringBuffer(200);
            buf.append("select count(*) num from lams_cr_credential c");
            if (workspace != null) {
                buf.append(", lams_cr_workspace_credential wc ");
            }
            buf.append(" where c.name = \"");
            buf.append(credential.getName());
            buf.append("\" and c.password = \"");
            buf.append(credential.getPassword());
            buf.append("\"");
            if (workspace != null) {
                buf.append(" and wc.credential_id = c.credential_id ");
                buf.append(" and wc.workspace_id = ");
                buf.append(workspace.getWorkspaceId());
            }
            ps = conn.prepareStatement(buf.toString());
            ps.execute();
            ResultSet rs = ps.getResultSet();
            if (rs.next() && (val = rs.getInt("num")) > 0) {
                credentialMatched = true;
                if (val > 1) {
                    this.log.warn((Object)("More than one credential found for workspace " + workspace.getWorkspaceId() + " credential name " + credential.getName()));
                }
            }
        }
        catch (HibernateException e) {
            this.log.error((Object)"Hibernate exception occured during login. ", (Throwable)e);
            throw new RepositoryRuntimeException("Unable to login due to internal error.", e);
        }
        catch (SQLException se) {
            this.log.error((Object)"SQL exception occured during login. ", (Throwable)se);
            throw new RepositoryRuntimeException("Unable to login due to internal error.", se);
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException se2) {
                    this.log.error((Object)"SQL exception occured during login, while closing statement. ", (Throwable)se2);
                    throw new RepositoryRuntimeException("Unable to login due to internal error.", se2);
                }
            }
        }
        return credentialMatched;
    }

    public CrCredential findByName(String name) {
        this.log.debug((Object)("Getting credential for name " + name));
        String queryString = "from CrCredential as c where c.name = ?";
        List credentials = this.getHibernateTemplate().find(queryString, (Object)name);
        if (credentials.size() == 0) {
            this.log.debug((Object)"No credentials found");
            return null;
        }
        return (CrCredential)credentials.get(0);
    }
}

