/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.contentrepository.dao.hibernate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.contentrepository.CrWorkspace;
import org.lamsfoundation.lams.contentrepository.RepositoryCheckedException;
import org.lamsfoundation.lams.contentrepository.dao.IWorkspaceDAO;
import org.lamsfoundation.lams.dao.hibernate.BaseDAO;
import org.springframework.orm.hibernate3.HibernateObjectRetrievalFailureException;

public class WorkspaceDAO
extends BaseDAO
implements IWorkspaceDAO {
    protected Logger log = Logger.getLogger(WorkspaceDAO.class);

    public CrWorkspace findByName(String workspaceName) {
        this.log.debug((Object)("Getting workspace for name " + workspaceName));
        String queryString = "from CrWorkspace as w where w.name = ?";
        List workspaces = this.getHibernateTemplate().find(queryString, (Object)workspaceName);
        if (workspaces.size() == 0) {
            this.log.debug((Object)"No workspaces found");
            return null;
        }
        CrWorkspace workspace = (CrWorkspace)workspaces.get(0);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Returning workspace " + workspace.toString()));
        }
        return workspace;
    }

    public List findWorkspaceNodes(Long workspaceId) {
        CrWorkspace workspace = (CrWorkspace)this.find(CrWorkspace.class, workspaceId);
        Set nodes = workspace.getCrNodes();
        int size = nodes.size();
        return new ArrayList(nodes);
    }

    public Object find(Class objClass, Serializable id) {
        try {
            return super.find(objClass, id);
        }
        catch (HibernateObjectRetrievalFailureException e) {
            return null;
        }
    }

    public void flushSession() throws RepositoryCheckedException {
        try {
            this.getSession().flush();
        }
        catch (Exception e) {
            this.log.error((Object)"Exception occured during flush. ", (Throwable)e);
            throw new RepositoryCheckedException("Unable to write changes to db successfully (flush).", e);
        }
    }
}

