/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.contentrepository.service;

import java.io.InputStream;
import java.util.Date;
import java.util.Set;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.contentrepository.CrNode;
import org.lamsfoundation.lams.contentrepository.CrNodeVersion;
import org.lamsfoundation.lams.contentrepository.CrNodeVersionProperty;
import org.lamsfoundation.lams.contentrepository.CrWorkspace;
import org.lamsfoundation.lams.contentrepository.FileException;
import org.lamsfoundation.lams.contentrepository.IValue;
import org.lamsfoundation.lams.contentrepository.InvalidParameterException;
import org.lamsfoundation.lams.contentrepository.ItemNotFoundException;
import org.lamsfoundation.lams.contentrepository.ValueFormatException;
import org.lamsfoundation.lams.contentrepository.dao.INodeDAO;
import org.lamsfoundation.lams.contentrepository.service.INodeFactory;
import org.lamsfoundation.lams.contentrepository.service.SimpleVersionedNode;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;

public class NodeFactory
implements INodeFactory,
BeanFactoryAware {
    protected Logger log = Logger.getLogger(NodeFactory.class);
    private BeanFactory beanFactory = null;
    private INodeDAO nodeDAO = null;

    public SimpleVersionedNode createFileNode(CrWorkspace workspace, SimpleVersionedNode parentNode, String relPath, InputStream istream, String filename, String mimeType, String versionDescription, Integer userId) throws InvalidParameterException {
        SimpleVersionedNode initialNodeVersion = this.createBasicNode("FILENODE", workspace, parentNode, relPath, versionDescription, userId);
        initialNodeVersion.setFile(istream, filename, mimeType);
        return initialNodeVersion;
    }

    public SimpleVersionedNode createPackageNode(CrWorkspace workspace, String initialPath, String versionDescription, Integer userId) throws InvalidParameterException {
        SimpleVersionedNode initialNodeVersion = this.createBasicNode("PACKAGENODE", workspace, null, null, versionDescription, userId);
        initialNodeVersion.setProperty("INITIALPATH", initialPath);
        return initialNodeVersion;
    }

    public SimpleVersionedNode createDataNode(CrWorkspace workspace, SimpleVersionedNode parentNode, String versionDescription, Integer userId) throws InvalidParameterException {
        SimpleVersionedNode initialNodeVersion = this.createBasicNode("DATANODE", workspace, parentNode, null, versionDescription, userId);
        return initialNodeVersion;
    }

    private SimpleVersionedNode createBasicNode(String nodeType, CrWorkspace workspace, SimpleVersionedNode parentNode, String relPath, String versionDescription, Integer userId) {
        SimpleVersionedNode initialNodeVersion = (SimpleVersionedNode)this.beanFactory.getBean("node", SimpleVersionedNode.class);
        Date createdDate = new Date(System.currentTimeMillis());
        CrNodeVersion parentNodeVersion = parentNode != null ? parentNode.getNodeVersion() : null;
        CrNode node = new CrNode(relPath, nodeType, createdDate, userId, workspace, parentNodeVersion, versionDescription);
        CrNodeVersion nodeVersion = node.getNodeVersion(null);
        initialNodeVersion.setNode(node);
        initialNodeVersion.setNodeVersion(nodeVersion);
        if (parentNode != null) {
            parentNode.addChildNode(initialNodeVersion);
        }
        return initialNodeVersion;
    }

    public SimpleVersionedNode getNode(CrNode databaseNode, Long versionId) {
        SimpleVersionedNode newNode = (SimpleVersionedNode)this.beanFactory.getBean("node", SimpleVersionedNode.class);
        newNode.setNode(databaseNode);
        newNode.setNodeVersion(databaseNode.getNodeVersion(versionId));
        return newNode;
    }

    public SimpleVersionedNode getNode(Long workspaceId, Long uuid, Long versionId) throws ItemNotFoundException {
        if (uuid == null) {
            throw new ItemNotFoundException("UUID is null, unable to find node.");
        }
        if (workspaceId == null) {
            throw new ItemNotFoundException("Workspace Id is null, unable to find node.");
        }
        CrNode node = null;
        node = (CrNode)this.nodeDAO.find(CrNode.class, uuid);
        if (node == null) {
            throw new ItemNotFoundException("Node " + uuid + " not found.");
        }
        if (!workspaceId.equals(node.getCrWorkspace().getWorkspaceId())) {
            this.log.error((Object)("Security warning. User of workspace " + workspaceId + " is trying to access node " + uuid + " which is in workspace " + node.getCrWorkspace().getWorkspaceId() + " Request for node will be rejected."));
            throw new ItemNotFoundException("Node " + uuid + " does not exist in workspace " + workspaceId);
        }
        return this.getNode(node, versionId);
    }

    public SimpleVersionedNode getNodeNewVersion(Long workspaceId, Long uuid, Long versionId, String versionDescription, Integer userId) throws ItemNotFoundException {
        SimpleVersionedNode existingNode = this.getNode(workspaceId, uuid, versionId);
        CrNode existingCrNode = existingNode.getNode();
        Long nextVersionId = existingNode.getNode().incrementNextVersionId();
        SimpleVersionedNode newNode = (SimpleVersionedNode)this.beanFactory.getBean("node", SimpleVersionedNode.class);
        newNode.setNode(existingCrNode);
        CrNodeVersion newVersion = new CrNodeVersion(existingCrNode, new Date(System.currentTimeMillis()), nextVersionId, versionDescription, userId);
        newNode.setNodeVersion(newVersion);
        existingCrNode.addCrNodeVersion(newVersion);
        return newNode;
    }

    public SimpleVersionedNode copy(SimpleVersionedNode originalNode, Integer userId) throws FileException, ValueFormatException, InvalidParameterException {
        return this.copy(originalNode, null, userId);
    }

    private SimpleVersionedNode copy(SimpleVersionedNode originalNode, CrNodeVersion parentNodeVersion, Integer userId) throws FileException, ValueFormatException, InvalidParameterException {
        SimpleVersionedNode newNode = (SimpleVersionedNode)this.beanFactory.getBean("node", SimpleVersionedNode.class);
        Date createdDate = new Date(System.currentTimeMillis());
        CrNode newCrNode = new CrNode(originalNode.getPath(), originalNode.getNodeType(), createdDate, userId, originalNode.getNode().getCrWorkspace(), parentNodeVersion, originalNode.getVersionDescription());
        newNode.setNode(newCrNode);
        CrNodeVersion newCrNodeVersion = newCrNode.getNodeVersion(null);
        newNode.setNodeVersion(newCrNodeVersion);
        Set origProperties = originalNode.getNodeVersion().getCrNodeVersionProperties();
        if (origProperties != null) {
            for (CrNodeVersionProperty property : origProperties) {
                newCrNodeVersion.setProperty(property.getName(), property.getValue(), property.getType());
            }
        }
        if (originalNode.isNodeType("FILENODE")) {
            InputStream istream = originalNode.getFile();
            IValue filenameProperty = originalNode.getProperty("FILENAME");
            IValue mimetypeProperty = originalNode.getProperty("MIMETYPE");
            newNode.setFile(istream, filenameProperty != null ? filenameProperty.getString() : null, mimetypeProperty != null ? mimetypeProperty.getString() : null);
        }
        for (SimpleVersionedNode childNode : originalNode.getChildNodes()) {
            SimpleVersionedNode newChildNode = this.copy(childNode, newCrNodeVersion, userId);
            newNode.addChildNode(newChildNode);
        }
        return newNode;
    }

    public INodeDAO getNodeDAO() {
        return this.nodeDAO;
    }

    public void setNodeDAO(INodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

