/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.contentrepository.service;

import org.apache.log4j.Logger;
import org.lamsfoundation.lams.contentrepository.RepositoryRuntimeException;
import org.lamsfoundation.lams.contentrepository.service.IRepositoryService;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class RepositoryProxy {
    private static Logger log = Logger.getLogger(RepositoryProxy.class);

    public static IRepositoryService getRepositoryService() {
        String[] contextPaths = IRepositoryService.REPOSITORY_CONTEXT_PATH;
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(contextPaths);
        if (context == null) {
            throw new RepositoryRuntimeException("Unable to access application context. Cannot create repository object.");
        }
        IRepositoryService repository = (IRepositoryService)context.getBean("repositoryService");
        return repository;
    }

    public static IRepositoryService getLocalRepositoryService() {
        String[] contextPaths = IRepositoryService.REPOSITORY_LOCAL_CONTEXT_PATH;
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(contextPaths);
        if (context == null) {
            throw new RepositoryRuntimeException("Unable to access application context. Cannot create repository object.");
        }
        IRepositoryService repository = (IRepositoryService)context.getBean("repositoryService");
        return repository;
    }
}

