/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.contentrepository.service;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.contentrepository.AccessDeniedException;
import org.lamsfoundation.lams.contentrepository.CrCredential;
import org.lamsfoundation.lams.contentrepository.CrNode;
import org.lamsfoundation.lams.contentrepository.CrWorkspace;
import org.lamsfoundation.lams.contentrepository.CrWorkspaceCredential;
import org.lamsfoundation.lams.contentrepository.FileException;
import org.lamsfoundation.lams.contentrepository.ICredentials;
import org.lamsfoundation.lams.contentrepository.ITicket;
import org.lamsfoundation.lams.contentrepository.IValue;
import org.lamsfoundation.lams.contentrepository.IVersionedNode;
import org.lamsfoundation.lams.contentrepository.InvalidParameterException;
import org.lamsfoundation.lams.contentrepository.ItemExistsException;
import org.lamsfoundation.lams.contentrepository.ItemNotFoundException;
import org.lamsfoundation.lams.contentrepository.LoginException;
import org.lamsfoundation.lams.contentrepository.NodeKey;
import org.lamsfoundation.lams.contentrepository.RepositoryCheckedException;
import org.lamsfoundation.lams.contentrepository.RepositoryRuntimeException;
import org.lamsfoundation.lams.contentrepository.ValidationException;
import org.lamsfoundation.lams.contentrepository.ValueFormatException;
import org.lamsfoundation.lams.contentrepository.WorkspaceNotFoundException;
import org.lamsfoundation.lams.contentrepository.dao.ICredentialDAO;
import org.lamsfoundation.lams.contentrepository.dao.IWorkspaceDAO;
import org.lamsfoundation.lams.contentrepository.service.INodeFactory;
import org.lamsfoundation.lams.contentrepository.service.IRepositoryAdmin;
import org.lamsfoundation.lams.contentrepository.service.SimpleTicket;
import org.lamsfoundation.lams.contentrepository.service.SimpleVersionedNode;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.FileUtil;
import org.lamsfoundation.lams.util.FileUtilException;
import org.lamsfoundation.lams.util.zipfile.ZipFileUtil;
import org.lamsfoundation.lams.util.zipfile.ZipFileUtilException;
import org.lamsfoundation.lams.web.session.SessionManager;

public class SimpleRepository
implements IRepositoryAdmin {
    protected Logger log = Logger.getLogger(SimpleRepository.class);
    private ICredentialDAO credentialDAO = null;
    private IWorkspaceDAO workspaceDAO = null;
    private INodeFactory nodeFactory = null;
    private Set ticketIdSet = new HashSet();

    public SimpleRepository() {
        this.log.info((Object)"Repository singleton being created.");
    }

    private Integer getCurrentUserId() throws AccessDeniedException {
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        if (user == null) {
            throw new AccessDeniedException("Cannot get user details for content repository. User may not be logged in.");
        }
        return user.getUserID();
    }

    private CrWorkspace getWorkspace(String workspaceName) throws WorkspaceNotFoundException {
        CrWorkspace workspace = this.workspaceDAO.findByName(workspaceName);
        if (workspace == null) {
            throw new WorkspaceNotFoundException("Workspace " + workspaceName + " does not exist.");
        }
        return workspace;
    }

    private CrWorkspace getWorkspace(Long workspaceId) throws WorkspaceNotFoundException {
        CrWorkspace workspace = (CrWorkspace)this.workspaceDAO.find(CrWorkspace.class, workspaceId);
        if (workspace == null) {
            throw new WorkspaceNotFoundException("Workspace id=" + workspaceId + " does not exist.");
        }
        return workspace;
    }

    public ITicket login(ICredentials credentials, String workspaceName) throws AccessDeniedException, LoginException, WorkspaceNotFoundException {
        if (this.workspaceDAO == null || this.credentialDAO == null) {
            throw new RepositoryRuntimeException("Workspace or Credential DAO object missing. Unable to process login.");
        }
        CrWorkspace workspace = this.getWorkspace(workspaceName);
        if (!this.credentialDAO.checkCredential(credentials, workspace)) {
            throw new LoginException("Login failed. Password incorrect or not authorised to access this workspace.");
        }
        SimpleTicket ticket = new SimpleTicket(workspace.getWorkspaceId());
        this.ticketIdSet.add(ticket.getTicketId());
        return ticket;
    }

    public void addWorkspace(ICredentials credentials, String workspaceName) throws AccessDeniedException, LoginException, ItemExistsException, RepositoryCheckedException {
        if (this.workspaceDAO == null || this.credentialDAO == null || this.nodeFactory == null) {
            throw new RepositoryRuntimeException("Workspace, Credential DAO or Node Factory object missing. Unable to process login.");
        }
        CrWorkspace workspace = this.workspaceDAO.findByName(workspaceName);
        if (workspace != null) {
            throw new ItemExistsException("Workspace " + workspaceName + " already exists, cannot add workspace.");
        }
        if (!this.credentialDAO.checkCredential(credentials)) {
            throw new LoginException("User not authorised to access the repository.");
        }
        CrWorkspace crWorkspace = new CrWorkspace();
        crWorkspace.setName(workspaceName);
        this.workspaceDAO.insert(crWorkspace);
        this.assignCredentials(credentials, crWorkspace);
    }

    public void createCredentials(ICredentials newCredential) throws AccessDeniedException, RepositoryCheckedException, ItemExistsException {
        if (newCredential == null || newCredential.getName() == null || newCredential.getPassword() == null) {
            throw new RepositoryCheckedException("Credential is null or name/password is missing - cannot create credential.");
        }
        this.verifyNewPassword(newCredential.getPassword());
        CrCredential cred = this.credentialDAO.findByName(newCredential.getName());
        if (cred != null) {
            throw new ItemExistsException("Credential name " + newCredential.getName() + " already exists - cannot create credential.");
        }
        cred = new CrCredential();
        cred.setName(newCredential.getName());
        cred.setPassword(new String(newCredential.getPassword()));
        this.credentialDAO.insert(cred);
    }

    public void updateCredentials(ICredentials oldCredential, ICredentials newCredential) throws AccessDeniedException, LoginException, RepositoryCheckedException, RepositoryRuntimeException {
        if (this.workspaceDAO == null || this.credentialDAO == null) {
            throw new RepositoryRuntimeException("Workspace or Credential DAO object missing. Cannot update credentials.");
        }
        if (oldCredential == null || newCredential == null) {
            throw new RepositoryCheckedException("Credentials missing. Cannot update credentials.");
        }
        if (!this.credentialDAO.checkCredential(oldCredential)) {
            throw new LoginException("Old password wrong. Cannot update credentials.");
        }
        char[] newPassword = newCredential.getPassword();
        if (newPassword != null) {
            this.verifyNewPassword(newPassword);
            CrCredential cred = this.credentialDAO.findByName(oldCredential.getName());
            cred.setPassword(new String(newPassword));
            this.credentialDAO.update(cred);
        }
    }

    private void verifyNewPassword(char[] password) throws RepositoryCheckedException {
        if (password != null && password.length < 6) {
            throw new RepositoryCheckedException("Password invalid - must be 6 or more characters. Cannot create credential.");
        }
    }

    public void assignCredentials(ICredentials credentials, String workspaceName) throws AccessDeniedException, RepositoryCheckedException, WorkspaceNotFoundException, LoginException {
        if (this.workspaceDAO == null) {
            throw new RepositoryRuntimeException("Workspace DAO object missing. Cannot assign credentials.");
        }
        if (credentials == null || workspaceName == null) {
            throw new RepositoryCheckedException("Credentials or workspace is missing. Cannot assign credentials.");
        }
        if (!this.credentialDAO.checkCredential(credentials)) {
            throw new LoginException("Credentials are not authorised to have access to the repository/workspace.");
        }
        CrWorkspace workspace = this.getWorkspace(workspaceName);
        if (workspace == null) {
            throw new WorkspaceNotFoundException("Workspace " + workspaceName + " does not exist.");
        }
        this.assignCredentials(credentials, workspace);
    }

    private void assignCredentials(ICredentials credentials, CrWorkspace workspace) throws RepositoryCheckedException {
        if (this.workspaceDAO == null || this.credentialDAO == null) {
            throw new RepositoryRuntimeException("Workspace or Credential DAO object missing. Cannot assign credentials.");
        }
        if (credentials == null || workspace == null) {
            throw new RepositoryCheckedException("Credentials or workspace is missing. Cannot assign credentials.");
        }
        CrCredential crCredential = this.credentialDAO.findByName(credentials.getName());
        if (crCredential == null) {
            throw new RepositoryCheckedException("Credential object cannot be found in database. Cannot assign credentials.");
        }
        CrWorkspaceCredential wc = new CrWorkspaceCredential();
        wc.setCrCredential(crCredential);
        wc.setCrWorkspace(workspace);
        HashSet<CrWorkspaceCredential> wcSet = workspace.getCrWorkspaceCredentials();
        if (wcSet == null) {
            this.log.debug((Object)("Creating new wc set for workspace " + workspace.getName()));
            wcSet = new HashSet<CrWorkspaceCredential>();
            wcSet.add(wc);
            workspace.setCrWorkspaceCredentials(wcSet);
        } else {
            Iterator iter = wcSet.iterator();
            CrWorkspaceCredential found = null;
            while (iter.hasNext() && found == null) {
                CrWorkspaceCredential item = (CrWorkspaceCredential)iter.next();
                if (item.getCrCredential() == null || !item.getCrCredential().getCredentialId().equals(crCredential.getCredentialId()) || item.getCrWorkspace() == null || !item.getCrWorkspace().getWorkspaceId().equals(workspace.getWorkspaceId())) continue;
                found = item;
            }
            if (found == null) {
                wcSet.add(wc);
            }
        }
        this.workspaceDAO.insert(wc);
    }

    public void logout(ITicket ticket) throws AccessDeniedException {
        this.ticketIdSet.remove(ticket.getTicketId());
        ticket.clear();
    }

    public boolean isTicketOkay(ITicket ticket) {
        return ticket != null && this.ticketIdSet.contains(ticket.getTicketId());
    }

    public NodeKey addFileItem(ITicket ticket, InputStream istream, String filename, String mimeType, String versionDescription) throws FileException, AccessDeniedException, InvalidParameterException {
        try {
            CrWorkspace workspace = this.getWorkspace(ticket.getWorkspaceId());
            Integer userId = this.getCurrentUserId();
            SimpleVersionedNode initialNodeVersion = this.nodeFactory.createFileNode(workspace, null, null, istream, filename, mimeType, versionDescription, userId);
            initialNodeVersion.save();
            return initialNodeVersion.getNodeKey();
        }
        catch (ValidationException e) {
            throw new RepositoryRuntimeException("Internal error: unable to add file. " + e.getMessage(), e);
        }
        catch (WorkspaceNotFoundException e) {
            throw new RepositoryRuntimeException("Internal error: unable to add file. " + e.getMessage(), e);
        }
    }

    public NodeKey addPackageItem(ITicket ticket, String dirPath, String startFile, String versionDescription) throws AccessDeniedException, InvalidParameterException, FileException {
        CrWorkspace workspace = null;
        try {
            workspace = this.getWorkspace(ticket.getWorkspaceId());
        }
        catch (WorkspaceNotFoundException e) {
            throw new RepositoryRuntimeException("Internal error: unable to add file. " + e.getMessage(), e);
        }
        Integer userId = this.getCurrentUserId();
        SimpleVersionedNode packageNode = null;
        packageNode = this.nodeFactory.createPackageNode(workspace, startFile, versionDescription, userId);
        try {
            packageNode.addPackageFiles(workspace, dirPath, versionDescription, userId);
            packageNode.save();
        }
        catch (ValidationException e) {
            throw new RepositoryRuntimeException("Internal error: unable to add package." + e.getMessage(), e);
        }
        return packageNode.getNodeKey();
    }

    public IVersionedNode getFileItem(ITicket ticket, Long uuid, Long version) throws AccessDeniedException, ItemNotFoundException, FileException {
        return this.nodeFactory.getNode(ticket.getWorkspaceId(), uuid, version);
    }

    public IVersionedNode getFileItem(ITicket ticket, Long uuid, Long version, String relPath) throws AccessDeniedException, ItemNotFoundException, FileException {
        long start = System.currentTimeMillis();
        String key = "getFileItem " + uuid;
        SimpleVersionedNode latestNodeVersion = this.nodeFactory.getNode(ticket.getWorkspaceId(), uuid, version);
        this.log.error((Object)(key + " latestNodeVersion " + (System.currentTimeMillis() - start)));
        if (relPath == null) {
            return latestNodeVersion;
        }
        IVersionedNode childNode = latestNodeVersion.getNode(relPath);
        this.log.error((Object)(key + " latestNodeVersion.getNode " + (System.currentTimeMillis() - start)));
        return childNode;
    }

    public List getPackageNodes(ITicket ticket, Long uuid, Long version) throws AccessDeniedException, ItemNotFoundException, FileException {
        long start = System.currentTimeMillis();
        SimpleVersionedNode latestNodeVersion = this.nodeFactory.getNode(ticket.getWorkspaceId(), uuid, version);
        this.log.error((Object)("getPackageNodes latestNodeVersion " + (System.currentTimeMillis() - start)));
        Set childNodes = latestNodeVersion.getChildNodes();
        int childNodesSize = childNodes != null ? childNodes.size() : 0;
        this.log.error((Object)("getPackageNodes getChildNodes " + (System.currentTimeMillis() - start)));
        ArrayList<SimpleVersionedNode> list = new ArrayList<SimpleVersionedNode>(1 + childNodesSize);
        list.add(latestNodeVersion);
        list.addAll(childNodes);
        this.log.error((Object)("getPackageNodes end " + (System.currentTimeMillis() - start)));
        return list;
    }

    public SortedMap getNodeList(ITicket ticket) throws AccessDeniedException {
        Long workspaceId = ticket.getWorkspaceId();
        List nodes = this.workspaceDAO.findWorkspaceNodes(workspaceId);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Workspace " + workspaceId + " has " + nodes.size() + " nodes."));
        }
        TreeMap<Long, SortedSet> map = new TreeMap<Long, SortedSet>();
        for (CrNode node : nodes) {
            map.put(node.getNodeId(), node.getVersionHistory());
        }
        return map;
    }

    public SortedSet getVersionHistory(ITicket ticket, Long uuid) throws ItemNotFoundException, AccessDeniedException {
        SimpleVersionedNode node = this.nodeFactory.getNode(ticket.getWorkspaceId(), uuid, null);
        return node.getVersionHistory();
    }

    public NodeKey updateFileItem(ITicket ticket, Long uuid, String filename, InputStream istream, String mimeType, String versionDescription) throws AccessDeniedException, ItemNotFoundException, FileException, InvalidParameterException {
        Integer userId = this.getCurrentUserId();
        SimpleVersionedNode newNodeVersion = this.nodeFactory.getNodeNewVersion(ticket.getWorkspaceId(), uuid, null, versionDescription, userId);
        if (!newNodeVersion.isNodeType("FILENODE")) {
            throw new InvalidParameterException("Node is not a file node - it is a " + newNodeVersion.getNodeType() + ". Unable to update as a file.");
        }
        newNodeVersion.setFile(istream, filename, mimeType);
        try {
            newNodeVersion.save();
        }
        catch (ValidationException e) {
            throw new RepositoryRuntimeException("Internal error: unable to update file." + e.getMessage(), e);
        }
        return newNodeVersion.getNodeKey();
    }

    public NodeKey updatePackageItem(ITicket ticket, Long uuid, String dirPath, String startFile, String versionDescription) throws AccessDeniedException, ItemNotFoundException, FileException, InvalidParameterException {
        Integer userId = this.getCurrentUserId();
        SimpleVersionedNode newNodeVersion = this.nodeFactory.getNodeNewVersion(ticket.getWorkspaceId(), uuid, null, versionDescription, userId);
        if (!newNodeVersion.isNodeType("PACKAGENODE")) {
            throw new InvalidParameterException("Node is not a package node - it is a " + newNodeVersion.getNodeType() + ". Unable to update as a package.");
        }
        newNodeVersion.setProperty("INITIALPATH", startFile);
        try {
            CrWorkspace workspace = this.getWorkspace(ticket.getWorkspaceId());
            newNodeVersion.addPackageFiles(workspace, dirPath, versionDescription, userId);
            newNodeVersion.save();
        }
        catch (ValidationException e) {
            throw new RepositoryRuntimeException("Internal error: unable to add package." + e.getMessage(), e);
        }
        catch (WorkspaceNotFoundException e) {
            throw new RepositoryRuntimeException("Internal error: unable to add file. " + e.getMessage(), e);
        }
        return newNodeVersion.getNodeKey();
    }

    public void setProperty(ITicket ticket, Long uuid, Long versionId, String name, Object value, int type) throws AccessDeniedException, ItemNotFoundException, ValidationException {
        SimpleVersionedNode node = this.nodeFactory.getNode(ticket.getWorkspaceId(), uuid, versionId);
        node.setProperty(name, value, type);
        node.saveDB();
    }

    public NodeKey copyNodeVersion(ITicket ticket, Long uuid, Long versionId) throws AccessDeniedException, ItemNotFoundException {
        Integer userId = this.getCurrentUserId();
        try {
            SimpleVersionedNode originalNode = this.nodeFactory.getNode(ticket.getWorkspaceId(), uuid, versionId);
            SimpleVersionedNode newNode = this.nodeFactory.copy(originalNode, userId);
            newNode.save();
            return newNode.getNodeKey();
        }
        catch (ValidationException e) {
            throw new RepositoryRuntimeException("Internal error: unable to copy node. " + e.getMessage(), e);
        }
        catch (FileException e) {
            throw new RepositoryRuntimeException("Internal error: unable to copy node. " + e.getMessage(), e);
        }
        catch (ValueFormatException e) {
            throw new RepositoryRuntimeException("Internal error: unable to copy node. " + e.getMessage(), e);
        }
        catch (InvalidParameterException e) {
            throw new RepositoryRuntimeException("Internal error: unable to copy node. " + e.getMessage(), e);
        }
    }

    public void saveFile(ITicket ticket, Long uuid, Long versionId, String toFileName) throws AccessDeniedException, ItemNotFoundException, IOException, RepositoryCheckedException {
        try {
            SimpleVersionedNode node = this.nodeFactory.getNode(ticket.getWorkspaceId(), uuid, versionId);
            if (node == null) {
                throw new ItemNotFoundException("Unable find File node by uuid [" + uuid + "]");
            }
            if (node.isNodeType("FILENODE")) {
                this.saveSigleFile(toFileName, node);
            } else if (node.isNodeType("PACKAGENODE")) {
                Set children = node.getChildNodes();
                String tempRoot = FileUtil.createTempDirectory((String)"export_package");
                for (IVersionedNode child : children) {
                    String path = child.getPath();
                    String fullname = FileUtil.getFullPath((String)tempRoot, (String)path);
                    FileUtil.createDirectory((String)FileUtil.getFileDirectory((String)fullname));
                    this.saveSigleFile(fullname, child);
                }
                if (toFileName == null) {
                    IValue prop = node.getProperty("FILENAME");
                    toFileName = prop != null ? prop.getString() : null;
                    FileUtil.createDirectory((String)FileUtil.TEMP_DIR);
                    toFileName = FileUtil.getFullPath((String)FileUtil.TEMP_DIR, (String)toFileName);
                }
                ZipFileUtil.createZipFile((String)FileUtil.getFileName((String)toFileName), (String)tempRoot, (String)FileUtil.getFileDirectory((String)toFileName));
            }
        }
        catch (FileException e) {
            throw new RepositoryRuntimeException("Internal error: unable to save node. " + e.getMessage(), e);
        }
        catch (ValueFormatException e) {
            throw new RepositoryRuntimeException("Internal error: unable to save node. " + e.getMessage(), e);
        }
        catch (FileUtilException e) {
            throw new RepositoryRuntimeException("Internal error: unable to save node. " + e.getMessage(), e);
        }
        catch (ZipFileUtilException e) {
            throw new RepositoryRuntimeException("Internal error: unable to save node. " + e.getMessage(), e);
        }
    }

    private void saveSigleFile(String toFileName, IVersionedNode node) throws FileException, ValueFormatException, FileUtilException, FileNotFoundException, IOException {
        InputStream is = node.getFile();
        if (toFileName == null) {
            IValue prop = node.getProperty("FILENAME");
            toFileName = prop != null ? prop.getString() : null;
            FileUtil.createDirectory((String)FileUtil.TEMP_DIR);
            toFileName = FileUtil.getFullPath((String)FileUtil.TEMP_DIR, (String)toFileName);
        }
        FileOutputStream os = new FileOutputStream(toFileName);
        byte[] out = new byte[8192];
        int len = -1;
        while ((len = is.read(out)) != -1) {
            ((OutputStream)os).write(out, 0, len);
        }
        ((OutputStream)os).close();
        is.close();
        this.log.debug((Object)("File save success:" + toFileName));
    }

    public String[] deleteNode(ITicket ticket, Long uuid) throws AccessDeniedException, InvalidParameterException, ItemNotFoundException {
        if (uuid == null) {
            throw new InvalidParameterException("UUID is required for deleteItem.");
        }
        SimpleVersionedNode latestNodeVersion = this.nodeFactory.getNode(ticket.getWorkspaceId(), uuid, new Long(1L));
        if (latestNodeVersion.hasParentNode()) {
            throw new InvalidParameterException("You cannot delete a node that is in a package (ie has a parent). Please delete the parent. Node UUID " + uuid);
        }
        List problemPaths = latestNodeVersion.deleteNode();
        return problemPaths != null ? problemPaths.toArray(new String[problemPaths.size()]) : new String[]{};
    }

    public String[] deleteVersion(ITicket ticket, Long uuid, Long version) throws AccessDeniedException, InvalidParameterException, ItemNotFoundException {
        if (uuid == null || version == null) {
            throw new InvalidParameterException("Both uuid and version are required for deleteVersion.");
        }
        SimpleVersionedNode nodeVersion = this.nodeFactory.getNode(ticket.getWorkspaceId(), uuid, version);
        List problemPaths = nodeVersion.deleteVersion();
        return problemPaths != null ? problemPaths.toArray(new String[problemPaths.size()]) : new String[]{};
    }

    public IWorkspaceDAO getWorkspaceDAO() {
        return this.workspaceDAO;
    }

    public void setWorkspaceDAO(IWorkspaceDAO workspaceDAO) {
        this.workspaceDAO = workspaceDAO;
    }

    public ICredentialDAO getCredentialDAO() {
        return this.credentialDAO;
    }

    public void setCredentialDAO(ICredentialDAO credentialDAO) {
        this.credentialDAO = credentialDAO;
    }

    public INodeFactory getNodeFactory() {
        return this.nodeFactory;
    }

    public void setNodeFactory(INodeFactory nodeFactory) {
        this.nodeFactory = nodeFactory;
    }
}

