/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.contentrepository.struts.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.contentrepository.AccessDeniedException;
import org.lamsfoundation.lams.contentrepository.ITicket;
import org.lamsfoundation.lams.contentrepository.ItemExistsException;
import org.lamsfoundation.lams.contentrepository.LoginException;
import org.lamsfoundation.lams.contentrepository.RepositoryCheckedException;
import org.lamsfoundation.lams.contentrepository.WorkspaceNotFoundException;
import org.lamsfoundation.lams.contentrepository.service.IRepositoryService;
import org.lamsfoundation.lams.contentrepository.service.SimpleCredentials;
import org.lamsfoundation.lams.contentrepository.struts.action.RepositoryDispatchAction;
import org.lamsfoundation.lams.contentrepository.struts.form.LoginRepositoryForm;

public class LoginRepositoryAction
extends RepositoryDispatchAction {
    protected Logger log = Logger.getLogger(LoginRepositoryAction.class);

    public ActionForward loginToWorkspace(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws RepositoryCheckedException {
        return this.process(mapping, form, request, response, false);
    }

    public ActionForward createNewWorkspace(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws RepositoryCheckedException {
        return this.process(mapping, form, request, response, true);
    }

    private ActionForward process(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, boolean createWorkspaceFirst) throws RepositoryCheckedException {
        ITicket ticket;
        this.log.debug((Object)("In process, createWorkspaceFirst=" + createWorkspaceFirst));
        LoginRepositoryForm loginRepositoryForm = (LoginRepositoryForm)form;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Form : " + form));
        }
        String toolName = loginRepositoryForm.getToolName();
        char[] toolId = loginRepositoryForm.getIndentificationString().toCharArray();
        String workspaceName = loginRepositoryForm.getWorkspaceName();
        SimpleCredentials cred = new SimpleCredentials(toolName, toolId);
        IRepositoryService repository = this.getRepository();
        if (createWorkspaceFirst) {
            try {
                repository.createCredentials(cred);
                repository.addWorkspace(cred, workspaceName);
            }
            catch (LoginException e) {
                this.log.error((Object)"LoginException occured ", (Throwable)e);
                throw e;
            }
            catch (ItemExistsException e) {
                this.log.error((Object)"Workspace already exists Exception occured ", (Throwable)e);
                throw e;
            }
            catch (RepositoryCheckedException e) {
                this.log.error((Object)"Some other repository error (usually internal error) occured ", (Throwable)e);
                throw e;
            }
        }
        try {
            ticket = repository.login(cred, workspaceName);
        }
        catch (LoginException e) {
            this.log.error((Object)"LoginException occured ", (Throwable)e);
            throw e;
        }
        catch (AccessDeniedException e) {
            this.log.error((Object)"Not allowed to do that type exception occured ", (Throwable)e);
            throw e;
        }
        catch (WorkspaceNotFoundException e) {
            this.log.error((Object)"Workspace was not found exception occured ", (Throwable)e);
            throw e;
        }
        this.log.debug((Object)("New ticket being added to session: " + ticket));
        LoginRepositoryAction.setTicket(request, ticket);
        this.log.debug((Object)("Login succeeded, forwarding to " + mapping.findForward("success")));
        return mapping.findForward("success");
    }
}

