/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.contentrepository.struts.action;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.contentrepository.AccessDeniedException;
import org.lamsfoundation.lams.contentrepository.FileException;
import org.lamsfoundation.lams.contentrepository.ITicket;
import org.lamsfoundation.lams.contentrepository.IVersionedNode;
import org.lamsfoundation.lams.contentrepository.InvalidParameterException;
import org.lamsfoundation.lams.contentrepository.ItemNotFoundException;
import org.lamsfoundation.lams.contentrepository.NodeKey;
import org.lamsfoundation.lams.contentrepository.struts.action.RepositoryDispatchAction;

public class NodeSelectionAction
extends RepositoryDispatchAction {
    protected Logger log = Logger.getLogger(NodeSelectionAction.class);

    public ActionForward getList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws AccessDeniedException, ItemNotFoundException, FileException {
        ITicket ticket = NodeSelectionAction.getTicket(request);
        this.log.debug((Object)("In getList, ticket is " + ticket));
        if (ticket == null) {
            this.log.error((Object)"Ticket missing from session");
            return this.returnError(mapping, request, "error.noTicket");
        }
        this.log.debug((Object)"Getting node map");
        SortedMap map = null;
        try {
            map = this.getRepository().getNodeList(ticket);
        }
        catch (AccessDeniedException e) {
            this.log.error((Object)"Not allowed to do this exception occured ", (Throwable)e);
            throw e;
        }
        this.log.debug((Object)("Got map, map is " + map));
        ArrayList<IVersionedNode> jspList = new ArrayList<IVersionedNode>();
        if (map != null) {
            for (Long uuid : map.keySet()) {
                IVersionedNode node;
                try {
                    node = this.getRepository().getFileItem(ticket, uuid, null);
                }
                catch (AccessDeniedException e) {
                    this.log.error((Object)"Not allowed to do this exception occured ", (Throwable)e);
                    throw e;
                }
                catch (ItemNotFoundException e) {
                    this.log.error((Object)"Item not found exception occured ", (Throwable)e);
                    throw e;
                }
                catch (FileException e) {
                    this.log.error((Object)"File exception occured ", (Throwable)e);
                    throw e;
                }
                if (node.hasParentNode()) continue;
                jspList.add(node);
                jspList.add((IVersionedNode)map.get(uuid));
            }
        }
        request.setAttribute("nodeList", jspList);
        this.log.debug((Object)("Added map to request, forwarding to " + mapping.findForward("nodelist")));
        return mapping.findForward("nodelist");
    }

    public ActionForward viewPackage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws AccessDeniedException, ItemNotFoundException, FileException {
        ITicket ticket = NodeSelectionAction.getTicket(request);
        this.log.debug((Object)("In getList, ticket is " + ticket));
        if (ticket == null) {
            this.log.error((Object)"Ticket missing from session");
            return this.returnError(mapping, request, "error.noTicket");
        }
        Long uuid = NodeSelectionAction.getLong(request.getParameter("uuid"));
        Long version = NodeSelectionAction.getLong(request.getParameter("version"));
        if (uuid == null) {
            this.log.error((Object)"UUID missing");
            return this.returnError(mapping, request, "error.uuidMissing");
        }
        this.log.debug((Object)("Deleting node " + uuid + " version " + version));
        List packageList = null;
        try {
            packageList = this.getRepository().getPackageNodes(ticket, uuid, version);
            request.setAttribute("packageList", (Object)packageList);
        }
        catch (AccessDeniedException e) {
            this.log.error((Object)"Not allowed to do this exception occured ", (Throwable)e);
            throw e;
        }
        catch (ItemNotFoundException e) {
            this.log.error((Object)"Item not found exception occured ", (Throwable)e);
            throw e;
        }
        this.log.debug((Object)("Added map to request, forwarding to " + mapping.findForward("packagelist")));
        return mapping.findForward("packagelist");
    }

    public ActionForward deleteNode(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ItemNotFoundException, InvalidParameterException, AccessDeniedException, FileException {
        ITicket ticket = NodeSelectionAction.getTicket(request);
        this.log.debug((Object)("In deleteNode, ticket is " + ticket));
        if (ticket == null) {
            this.log.error((Object)"Ticket missing from session");
            return this.returnError(mapping, request, "error.noTicket");
        }
        Long uuid = NodeSelectionAction.getLong(request.getParameter("uuid"));
        Long version = NodeSelectionAction.getLong(request.getParameter("version"));
        if (uuid == null) {
            this.log.error((Object)"UUID missing");
            return this.returnError(mapping, request, "error.uuidMissing");
        }
        this.log.debug((Object)("Deleting node " + uuid + " version " + version));
        try {
            if (version == null) {
                String[] problemFiles = this.getRepository().deleteNode(ticket, uuid);
                this.log.info((Object)("Deleted node, " + (problemFiles == null || problemFiles.length == 0 ? 0 : problemFiles.length) + " problem files were encountered."));
            } else {
                String[] problemFiles = this.getRepository().deleteVersion(ticket, uuid, version);
            }
            this.log.debug((Object)"Deleted nodes, forwarding to list");
            return this.getList(mapping, form, request, response);
        }
        catch (AccessDeniedException e) {
            this.log.error((Object)"Not allowed to do this exception occured ", (Throwable)e);
            throw e;
        }
        catch (ItemNotFoundException e) {
            this.log.error((Object)"Item not found exception occured ", (Throwable)e);
            throw e;
        }
    }

    public ActionForward copyNode(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ItemNotFoundException, InvalidParameterException, AccessDeniedException, FileException {
        ITicket ticket = NodeSelectionAction.getTicket(request);
        this.log.debug((Object)("In copyNode, ticket is " + ticket));
        if (ticket == null) {
            this.log.error((Object)"Ticket missing from session");
            return this.returnError(mapping, request, "error.noTicket");
        }
        Long uuid = NodeSelectionAction.getLong(request.getParameter("uuid"));
        Long version = NodeSelectionAction.getLong(request.getParameter("version"));
        if (uuid == null) {
            this.log.error((Object)"UUID missing");
            return this.returnError(mapping, request, "error.uuidMissing");
        }
        this.log.debug((Object)("Copy node " + uuid + " version " + version));
        try {
            NodeKey key = this.getRepository().copyNodeVersion(ticket, uuid, version);
            this.log.info((Object)("Copy node, new ids " + key));
            return this.getList(mapping, form, request, response);
        }
        catch (AccessDeniedException e) {
            this.log.error((Object)"Not allowed to do this exception occured ", (Throwable)e);
            throw e;
        }
        catch (ItemNotFoundException e) {
            this.log.error((Object)"Item not found exception occured ", (Throwable)e);
            throw e;
        }
    }
}

