/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.contentrepository.struts.action;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.actions.DispatchAction;
import org.lamsfoundation.lams.contentrepository.ITicket;
import org.lamsfoundation.lams.contentrepository.RepositoryCheckedException;
import org.lamsfoundation.lams.contentrepository.service.IRepositoryService;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class RepositoryDispatchAction
extends DispatchAction {
    public static final String TICKET_NAME = "ticket";
    public static final String NODE_LIST_NAME = "nodeList";
    public static final String UUID_NAME = "uuid";
    public static final String VERSION_NAME = "version";
    public static final String SUCCESS_PATH = "success";
    public static final String ERROR_PATH = "error";
    public static final String LOGOUT_PATH = "logout";
    public static final String PACKAGE_LIST = "packageList";
    protected static Logger log = Logger.getLogger(RepositoryDispatchAction.class);

    protected ActionForward returnError(ActionMapping mapping, HttpServletRequest request, String errorKey) {
        ActionMessages am = new ActionMessages();
        am.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(errorKey));
        this.saveErrors(request, am);
        return mapping.findForward(ERROR_PATH);
    }

    protected static ITicket getTicket(HttpServletRequest request) {
        return (ITicket)request.getSession().getAttribute(TICKET_NAME);
    }

    protected static void setTicket(HttpServletRequest request, ITicket ticket) {
        request.getSession().setAttribute(TICKET_NAME, (Object)ticket);
    }

    protected static Long getLong(String longAsString) {
        try {
            return new Long(longAsString);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public ActionForward logout(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws RepositoryCheckedException {
        log.debug((Object)"In logout");
        ITicket ticket = RepositoryDispatchAction.getTicket(request);
        log.debug((Object)("In getNode, ticket is " + ticket));
        if (ticket == null) {
            log.error((Object)"Ticket missing from session");
            return this.returnError(mapping, request, "error.noTicket");
        }
        log.debug((Object)"About to logout");
        this.getRepository().logout(ticket);
        log.debug((Object)("Logged out to " + mapping.findForward(LOGOUT_PATH)));
        return mapping.findForward(LOGOUT_PATH);
    }

    public IRepositoryService getRepository() {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
        return (IRepositoryService)wac.getBean("repositoryService");
    }
}

