/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.dimdim.dto;

import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.tool.dimdim.dto.AttachmentDTO;
import org.lamsfoundation.lams.tool.dimdim.dto.SessionDTO;
import org.lamsfoundation.lams.tool.dimdim.model.Dimdim;
import org.lamsfoundation.lams.tool.dimdim.model.DimdimAttachment;
import org.lamsfoundation.lams.tool.dimdim.model.DimdimSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentDTO {
    private static final Logger logger = Logger.getLogger(ContentDTO.class);
    Long toolContentId;
    String title;
    String instructions;
    String onlineInstructions;
    String offlineInstructions;
    boolean reflectOnActivity;
    String reflectInstructions;
    boolean defineLater;
    boolean contentInUse;
    boolean lockOnFinish;
    Set<AttachmentDTO> onlineInstructionsFiles;
    Set<AttachmentDTO> offlineInstructionsFiles;
    Set<SessionDTO> sessionDTOs = new TreeSet<SessionDTO>();
    Long currentTab;
    Integer maxAttendeeMikes;

    public ContentDTO() {
    }

    public ContentDTO(Dimdim dimdim) {
        this.toolContentId = dimdim.getToolContentId();
        this.title = dimdim.getTitle();
        this.instructions = dimdim.getInstructions();
        this.onlineInstructions = dimdim.getOnlineInstructions();
        this.offlineInstructions = dimdim.getOfflineInstructions();
        this.contentInUse = dimdim.isContentInUse();
        this.reflectInstructions = dimdim.getReflectInstructions();
        this.reflectOnActivity = dimdim.isReflectOnActivity();
        this.lockOnFinish = dimdim.isLockOnFinished();
        this.onlineInstructionsFiles = new TreeSet<AttachmentDTO>();
        this.offlineInstructionsFiles = new TreeSet<AttachmentDTO>();
        this.maxAttendeeMikes = dimdim.getMaxAttendeeMikes();
        for (DimdimAttachment att : dimdim.getDimdimAttachments()) {
            Set<AttachmentDTO> attSet = null;
            if (att.getFileType().equals("OFFLINE")) {
                attSet = this.offlineInstructionsFiles;
            } else if (att.getFileType().equals("ONLINE")) {
                attSet = this.onlineInstructionsFiles;
            } else {
                logger.error((Object)("File with uid " + att.getFileUuid() + " contains invalid fileType: " + att.getFileType()));
            }
            if (attSet == null) continue;
            attSet.add(new AttachmentDTO(att));
        }
        for (DimdimSession dimdimSession : dimdim.getDimdimSessions()) {
            this.sessionDTOs.add(new SessionDTO(dimdimSession));
        }
    }

    public Set<SessionDTO> getSessionDTOs() {
        return this.sessionDTOs;
    }

    public void setSessionDTOs(Set<SessionDTO> sessionDTOs) {
        this.sessionDTOs = sessionDTOs;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public void setInstructions(String instructions) {
        this.instructions = instructions;
    }

    public String getOfflineInstructions() {
        return this.offlineInstructions;
    }

    public void setOfflineInstructions(String offlineInstructions) {
        this.offlineInstructions = offlineInstructions;
    }

    public Set<AttachmentDTO> getOfflineInstructionsFiles() {
        return this.offlineInstructionsFiles;
    }

    public void setOfflineInstructionsFiles(Set<AttachmentDTO> offlineInstructionsFiles) {
        this.offlineInstructionsFiles = offlineInstructionsFiles;
    }

    public String getOnlineInstructions() {
        return this.onlineInstructions;
    }

    public void setOnlineInstructions(String onlineInstructions) {
        this.onlineInstructions = onlineInstructions;
    }

    public Set<AttachmentDTO> getOnlineInstructionsFiles() {
        return this.onlineInstructionsFiles;
    }

    public void setOnlineInstructionsFiles(Set<AttachmentDTO> onlineInstructionsFiles) {
        this.onlineInstructionsFiles = onlineInstructionsFiles;
    }

    public boolean isReflectOnActivity() {
        return this.reflectOnActivity;
    }

    public void setReflectOnActivity(boolean reflectOnActivity) {
        this.reflectOnActivity = reflectOnActivity;
    }

    public String getReflectInstructions() {
        return this.reflectInstructions;
    }

    public void setReflectInstructions(String reflectInstructions) {
        this.reflectInstructions = reflectInstructions;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Long getToolContentId() {
        return this.toolContentId;
    }

    public void setToolContentId(Long toolContentID) {
        this.toolContentId = toolContentID;
    }

    public Boolean getContentInUse() {
        return this.contentInUse;
    }

    public void setContentInUse(Boolean contentInUse) {
        this.contentInUse = contentInUse;
    }

    public boolean isLockOnFinish() {
        return this.lockOnFinish;
    }

    public void setLockOnFinish(boolean lockOnFinish) {
        this.lockOnFinish = lockOnFinish;
    }

    public Long getCurrentTab() {
        return this.currentTab;
    }

    public void setCurrentTab(Long currentTab) {
        this.currentTab = currentTab;
    }

    public Integer getMaxAttendeeMikes() {
        return this.maxAttendeeMikes;
    }

    public void setMaxAttendeeMikes(Integer maxAttendeeMikes) {
        this.maxAttendeeMikes = maxAttendeeMikes;
    }
}

