/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.dimdim.dto;

import java.util.Set;
import java.util.TreeSet;
import org.lamsfoundation.lams.tool.dimdim.dto.UserDTO;
import org.lamsfoundation.lams.tool.dimdim.model.DimdimSession;
import org.lamsfoundation.lams.tool.dimdim.model.DimdimUser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionDTO
implements Comparable<SessionDTO> {
    Long sessionID;
    String sessionName;
    Set<UserDTO> userDTOs = new TreeSet<UserDTO>();
    int numberOfLearners;
    int numberOfFinishedLearners;

    public SessionDTO(DimdimSession session) {
        this.sessionID = session.getSessionId();
        this.sessionName = session.getSessionName();
        this.numberOfFinishedLearners = 0;
        for (DimdimUser dimdimUser : session.getDimdimUsers()) {
            UserDTO userDTO = new UserDTO(dimdimUser);
            if (userDTO.getNotebookEntryUID() != null) {
                ++this.numberOfFinishedLearners;
            }
            this.userDTOs.add(userDTO);
        }
        this.numberOfLearners = this.userDTOs.size();
    }

    @Override
    public int compareTo(SessionDTO other) {
        int ret = this.sessionName.compareToIgnoreCase(other.sessionName);
        if (ret == 0) {
            ret = this.sessionID.compareTo(other.sessionID);
        }
        return ret;
    }

    public SessionDTO() {
    }

    public Long getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(Long sessionID) {
        this.sessionID = sessionID;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    public Set<UserDTO> getUserDTOs() {
        return this.userDTOs;
    }

    public void setUserDTOs(Set<UserDTO> dimdimUsers) {
        this.userDTOs = dimdimUsers;
    }

    public int getNumberOfLearners() {
        return this.numberOfLearners;
    }

    public void setNumberOfLearners(int numberOfLearners) {
        this.numberOfLearners = numberOfLearners;
    }

    public int getNumberOfFinishedLearners() {
        return this.numberOfFinishedLearners;
    }

    public void setNumberOfFinishedLearners(int numberOfFinishedLearners) {
        this.numberOfFinishedLearners = numberOfFinishedLearners;
    }
}

