/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.dimdim.service;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.upload.FormFile;
import org.lamsfoundation.lams.contentrepository.AccessDeniedException;
import org.lamsfoundation.lams.contentrepository.ICredentials;
import org.lamsfoundation.lams.contentrepository.ITicket;
import org.lamsfoundation.lams.contentrepository.InvalidParameterException;
import org.lamsfoundation.lams.contentrepository.LoginException;
import org.lamsfoundation.lams.contentrepository.NodeKey;
import org.lamsfoundation.lams.contentrepository.RepositoryCheckedException;
import org.lamsfoundation.lams.contentrepository.WorkspaceNotFoundException;
import org.lamsfoundation.lams.contentrepository.client.IToolContentHandler;
import org.lamsfoundation.lams.contentrepository.service.IRepositoryService;
import org.lamsfoundation.lams.contentrepository.service.RepositoryProxy;
import org.lamsfoundation.lams.contentrepository.service.SimpleCredentials;
import org.lamsfoundation.lams.learning.service.ILearnerService;
import org.lamsfoundation.lams.learningdesign.service.ExportToolContentException;
import org.lamsfoundation.lams.learningdesign.service.IExportToolContentService;
import org.lamsfoundation.lams.learningdesign.service.ImportToolContentException;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.ICoreNotebookService;
import org.lamsfoundation.lams.tool.ToolContentImport102Manager;
import org.lamsfoundation.lams.tool.ToolContentManager;
import org.lamsfoundation.lams.tool.ToolOutput;
import org.lamsfoundation.lams.tool.ToolOutputDefinition;
import org.lamsfoundation.lams.tool.ToolSessionExportOutputData;
import org.lamsfoundation.lams.tool.ToolSessionManager;
import org.lamsfoundation.lams.tool.dimdim.dao.IDimdimAttachmentDAO;
import org.lamsfoundation.lams.tool.dimdim.dao.IDimdimConfigDAO;
import org.lamsfoundation.lams.tool.dimdim.dao.IDimdimDAO;
import org.lamsfoundation.lams.tool.dimdim.dao.IDimdimSessionDAO;
import org.lamsfoundation.lams.tool.dimdim.dao.IDimdimUserDAO;
import org.lamsfoundation.lams.tool.dimdim.model.Dimdim;
import org.lamsfoundation.lams.tool.dimdim.model.DimdimAttachment;
import org.lamsfoundation.lams.tool.dimdim.model.DimdimConfig;
import org.lamsfoundation.lams.tool.dimdim.model.DimdimSession;
import org.lamsfoundation.lams.tool.dimdim.model.DimdimUser;
import org.lamsfoundation.lams.tool.dimdim.service.IDimdimService;
import org.lamsfoundation.lams.tool.dimdim.util.DimdimException;
import org.lamsfoundation.lams.tool.dimdim.util.DimdimToolContentHandler;
import org.lamsfoundation.lams.tool.dimdim.util.DimdimUtil;
import org.lamsfoundation.lams.tool.exception.DataMissingException;
import org.lamsfoundation.lams.tool.exception.SessionDataExistsException;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.tool.service.ILamsToolService;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.util.audit.IAuditService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DimdimService
implements ToolSessionManager,
ToolContentManager,
IDimdimService,
ToolContentImport102Manager {
    private static final Logger logger = Logger.getLogger(DimdimService.class);
    private IDimdimDAO dimdimDAO = null;
    private IDimdimSessionDAO dimdimSessionDAO = null;
    private IDimdimUserDAO dimdimUserDAO = null;
    private IDimdimAttachmentDAO dimdimAttachmentDAO = null;
    private IDimdimConfigDAO dimdimConfigDAO = null;
    private ILearnerService learnerService;
    private ILamsToolService toolService;
    private IToolContentHandler dimdimToolContentHandler = null;
    private IRepositoryService repositoryService = null;
    private IAuditService auditService = null;
    private IExportToolContentService exportContentService;
    private ICoreNotebookService coreNotebookService;

    public void createToolSession(Long toolSessionId, String toolSessionName, Long toolContentId) throws ToolException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("entering method createToolSession: toolSessionId = " + toolSessionId + " toolSessionName = " + toolSessionName + " toolContentId = " + toolContentId));
        }
        DimdimSession session = new DimdimSession();
        session.setSessionId(toolSessionId);
        session.setSessionName(toolSessionName);
        Dimdim dimdim = this.getDimdimByContentId(toolContentId);
        session.setDimdim(dimdim);
        this.dimdimSessionDAO.insertOrUpdate(session);
    }

    public String leaveToolSession(Long toolSessionId, Long learnerId) throws DataMissingException, ToolException {
        return this.learnerService.completeToolSession(toolSessionId, learnerId);
    }

    public ToolSessionExportOutputData exportToolSession(Long toolSessionId) throws DataMissingException, ToolException {
        return null;
    }

    public ToolSessionExportOutputData exportToolSession(List toolSessionIds) throws DataMissingException, ToolException {
        return null;
    }

    public void removeToolSession(Long toolSessionId) throws DataMissingException, ToolException {
        this.dimdimSessionDAO.deleteByProperty(DimdimSession.class, "sessionId", toolSessionId);
    }

    public SortedMap<String, ToolOutput> getToolOutput(List<String> names, Long toolSessionId, Long learnerId) {
        return new TreeMap<String, ToolOutput>();
    }

    public ToolOutput getToolOutput(String name, Long toolSessionId, Long learnerId) {
        return null;
    }

    public void copyToolContent(Long fromContentId, Long toContentId) throws ToolException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("entering method copyToolContent: fromContentId=" + fromContentId + " toContentId=" + toContentId));
        }
        if (toContentId == null) {
            String error = "Failed to copy tool content: toContentID is null";
            throw new ToolException(error);
        }
        Dimdim fromContent = null;
        if (fromContentId != null) {
            fromContent = this.getDimdimByContentId(fromContentId);
        }
        if (fromContent == null) {
            fromContent = this.getDefaultContent();
        }
        Dimdim toContent = Dimdim.newInstance(fromContent, toContentId, this.dimdimToolContentHandler);
        this.saveOrUpdateDimdim(toContent);
    }

    public void setAsDefineLater(Long toolContentId, boolean value) throws DataMissingException, ToolException {
        Dimdim dimdim = this.getDimdimByContentId(toolContentId);
        if (dimdim == null) {
            throw new ToolException("Could not find tool with toolContentID: " + toolContentId);
        }
        dimdim.setDefineLater(value);
        this.saveOrUpdateDimdim(dimdim);
    }

    public void setAsRunOffline(Long toolContentId, boolean value) throws DataMissingException, ToolException {
        Dimdim dimdim = this.getDimdimByContentId(toolContentId);
        if (dimdim == null) {
            throw new ToolException("Could not find tool with toolContentID: " + toolContentId);
        }
        dimdim.setRunOffline(value);
        this.saveOrUpdateDimdim(dimdim);
    }

    public void removeToolContent(Long toolContentId, boolean removeSessionData) throws SessionDataExistsException, ToolException {
    }

    public void exportToolContent(Long toolContentId, String rootPath) throws DataMissingException, ToolException {
        Dimdim dimdim = this.getDimdimByContentId(toolContentId);
        if (dimdim == null) {
            dimdim = this.getDefaultContent();
        }
        if (dimdim == null) {
            throw new DataMissingException("Unable to find default content for the dimdim tool");
        }
        dimdim = Dimdim.newInstance(dimdim, toolContentId, null);
        dimdim.setToolContentHandler(null);
        dimdim.setDimdimSessions(null);
        Set<DimdimAttachment> atts = dimdim.getDimdimAttachments();
        for (DimdimAttachment att : atts) {
            att.setDimdim(null);
        }
        try {
            this.exportContentService.registerFileClassForExport(DimdimAttachment.class.getName(), "fileUuid", "fileVersionId");
            this.exportContentService.exportToolContent(toolContentId, (Object)dimdim, this.dimdimToolContentHandler, rootPath);
        }
        catch (ExportToolContentException e) {
            throw new ToolException((Throwable)e);
        }
    }

    public void importToolContent(Long toolContentId, Integer newUserUid, String toolContentPath, String fromVersion, String toVersion) throws ToolException {
        try {
            this.exportContentService.registerFileClassForImport(DimdimAttachment.class.getName(), "fileUuid", "fileVersionId", "fileName", "fileType", null, null);
            Object toolPOJO = this.exportContentService.importToolContent(toolContentPath, this.dimdimToolContentHandler, fromVersion, toVersion);
            if (!(toolPOJO instanceof Dimdim)) {
                throw new ImportToolContentException("Import Dimdim tool content failed. Deserialized object is " + toolPOJO);
            }
            Dimdim dimdim = (Dimdim)toolPOJO;
            dimdim.setToolContentId(toolContentId);
            dimdim.setCreateBy(new Long(newUserUid.longValue()));
            this.saveOrUpdateDimdim(dimdim);
        }
        catch (ImportToolContentException e) {
            throw new ToolException((Throwable)e);
        }
    }

    public SortedMap<String, ToolOutputDefinition> getToolOutputDefinitions(Long toolContentId) throws ToolException {
        return new TreeMap<String, ToolOutputDefinition>();
    }

    @Override
    public Long createNotebookEntry(Long id, Integer idType, String signature, Integer userID, String entry) {
        return this.coreNotebookService.createNotebookEntry(id, idType, signature, userID, "", entry);
    }

    public NotebookEntry getEntry(Long id, Integer idType, String signature, Integer userID) {
        List list = this.coreNotebookService.getEntry(id, idType, signature, userID);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (NotebookEntry)list.get(0);
    }

    @Override
    public NotebookEntry getNotebookEntry(Long uid) {
        return this.coreNotebookService.getEntry(uid);
    }

    @Override
    public void updateNotebookEntry(Long uid, String entry) {
        this.coreNotebookService.updateEntry(uid, "", entry);
    }

    @Override
    public void updateNotebookEntry(NotebookEntry notebookEntry) {
        this.coreNotebookService.updateEntry(notebookEntry);
    }

    @Override
    public Long getDefaultContentIdBySignature(String toolSignature) {
        Long toolContentId = null;
        toolContentId = new Long(this.toolService.getToolDefaultContentIdBySignature(toolSignature));
        if (toolContentId == null) {
            String error = "Could not retrieve default content id for this tool";
            logger.error((Object)error);
            throw new DimdimException(error);
        }
        return toolContentId;
    }

    @Override
    public Dimdim getDefaultContent() {
        Long defaultContentID = this.getDefaultContentIdBySignature("laddim10");
        Dimdim defaultContent = this.getDimdimByContentId(defaultContentID);
        if (defaultContent == null) {
            String error = "Could not retrieve default content record for this tool";
            logger.error((Object)error);
            throw new DimdimException(error);
        }
        return defaultContent;
    }

    @Override
    public Dimdim copyDefaultContent(Long newContentID) {
        if (newContentID == null) {
            String error = "Cannot copy the Dimdim tools default content: + newContentID is null";
            logger.error((Object)error);
            throw new DimdimException(error);
        }
        Dimdim defaultContent = this.getDefaultContent();
        Dimdim newContent = new Dimdim();
        newContent = Dimdim.newInstance(defaultContent, newContentID, this.dimdimToolContentHandler);
        this.saveOrUpdateDimdim(newContent);
        return newContent;
    }

    @Override
    public Dimdim getDimdimByContentId(Long toolContentID) {
        List list = this.dimdimDAO.findByProperty(Dimdim.class, "toolContentId", toolContentID);
        if (list.isEmpty()) {
            return null;
        }
        return (Dimdim)list.get(0);
    }

    @Override
    public DimdimSession getSessionBySessionId(Long toolSessionId) {
        List list = this.dimdimSessionDAO.findByProperty(DimdimSession.class, "sessionId", toolSessionId);
        if (list.isEmpty()) {
            return null;
        }
        return (DimdimSession)list.get(0);
    }

    @Override
    public DimdimUser getUserByUserIdAndSessionId(Long userId, Long toolSessionId) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("userId", userId);
        map.put("dimdimSession.sessionId", toolSessionId);
        List list = this.dimdimUserDAO.findByProperties(DimdimUser.class, map);
        if (list.isEmpty()) {
            return null;
        }
        return (DimdimUser)list.get(0);
    }

    @Override
    public DimdimUser getUserByUID(Long uid) {
        List list = this.dimdimUserDAO.findByProperty(DimdimUser.class, "uid", uid);
        if (list.isEmpty()) {
            return null;
        }
        return (DimdimUser)list.get(0);
    }

    @Override
    public DimdimAttachment uploadFileToContent(Long toolContentId, FormFile file, String type) {
        if (file == null || StringUtils.isEmpty((String)file.getFileName())) {
            throw new DimdimException("Could not find upload file: " + file);
        }
        NodeKey nodeKey = this.processFile(file, type);
        DimdimAttachment attachment = new DimdimAttachment(nodeKey.getVersion(), type, file.getFileName(), nodeKey.getUuid(), new Date());
        return attachment;
    }

    @Override
    public void deleteFromRepository(Long uuid, Long versionID) throws DimdimException {
        ITicket ticket = this.getRepositoryLoginTicket();
        try {
            this.repositoryService.deleteVersion(ticket, uuid, versionID);
        }
        catch (Exception e) {
            throw new DimdimException("Exception occured while deleting files from the repository " + e.getMessage());
        }
    }

    @Override
    public String getDimdimJoinConferenceURL(UserDTO userDTO, String meetingKey) throws Exception {
        String serverURL = this.getConfigValue("server_url");
        if (serverURL == null) {
            logger.error((Object)"Config item : 'server_url' not defined");
            throw new DimdimException("Standard server url not defined");
        }
        URL url = new URL(serverURL + "/dimdim/JoinConferenceCheck.action?" + "email=" + URLEncoder.encode(userDTO.getEmail(), "UTF8") + "&displayName=" + URLEncoder.encode(userDTO.getFirstName() + " " + userDTO.getLastName(), "UTF8") + "&confKey=" + URLEncoder.encode(meetingKey, "UTF8"));
        String response = this.sendRequest(url);
        String result = DimdimUtil.getResult(response);
        if (result.equals("success")) {
            String path = DimdimUtil.getURL(response);
            return serverURL + path;
        }
        logger.error((Object)("getDimdimJoinConferenceURL: result: " + result));
        return null;
    }

    @Override
    public String getDimdimStartConferenceURL(UserDTO userDTO, String meetingKey, String returnURL, int maxAttendeeMikes) throws Exception {
        URL url;
        String serverURL = this.getConfigValue("server_url");
        if (serverURL == null) {
            logger.error((Object)"Config item : 'server_url' not defined");
            throw new DimdimException("Standard server url not defined");
        }
        String version = this.getConfigValue("version");
        if (version == null) {
            logger.error((Object)"Config value version returned null");
            throw new DimdimException("Server version not defined");
        }
        if (version.equals("standard")) {
            url = new URL(serverURL + "/dimdim/StartNewConferenceCheck.action?" + "email=" + URLEncoder.encode(userDTO.getEmail(), "UTF8") + "&displayName=" + URLEncoder.encode(userDTO.getFirstName() + " " + userDTO.getLastName(), "UTF8") + "&confKey=" + URLEncoder.encode(meetingKey, "UTF8") + "&lobby=false" + "&networkProfile=3" + "&meetingHours=99" + "&maxAttendeeMikes=" + maxAttendeeMikes + "&returnUrl=" + URLEncoder.encode(returnURL, "UTF8") + "&presenterAV=av" + "&privateChatEnabled=true" + "&publicChatEnabled=true" + "&screenShareEnabled=true" + "&whiteboardEnabled=true");
        } else if (version.equals("enterprise")) {
            url = new URL(serverURL + "/dimdim/StartNewConferenceCheck.action?" + "email=" + URLEncoder.encode(userDTO.getEmail(), "UTF8") + "&meetingRoomName=" + URLEncoder.encode(meetingKey, "UTF8") + "&displayName=" + URLEncoder.encode(userDTO.getFirstName() + " " + userDTO.getLastName(), "UTF8") + "&confName=" + "QandA" + "&lobby=" + "false" + "&networkProfile=" + "3" + "&meetingHours" + "=2" + "&meetingMinutes=" + "0" + "&presenterAV=" + "av" + "&maxAttendeeMikes=" + maxAttendeeMikes + "&returnUrl=" + URLEncoder.encode(returnURL, "UTF8") + "&whiteboardEnabled=" + "true" + "&screenShareEnabled=" + "true" + "&participantListEnabled=true" + "&dialInfoVisible=true");
        } else {
            logger.error((Object)("Unknown version type: " + version));
            throw new DimdimException("Unknown version type");
        }
        String response = this.sendRequest(url);
        String path = DimdimUtil.getURL(response);
        return serverURL + path;
    }

    @Override
    public void saveOrUpdateDimdim(Dimdim dimdim) {
        this.dimdimDAO.insertOrUpdate(dimdim);
    }

    @Override
    public void saveOrUpdateDimdimSession(DimdimSession dimdimSession) {
        this.dimdimSessionDAO.insertOrUpdate(dimdimSession);
    }

    @Override
    public void saveOrUpdateDimdimUser(DimdimUser dimdimUser) {
        this.dimdimUserDAO.insertOrUpdate(dimdimUser);
    }

    @Override
    public DimdimUser createDimdimUser(UserDTO user, DimdimSession dimdimSession) {
        DimdimUser dimdimUser = new DimdimUser(user, dimdimSession);
        this.saveOrUpdateDimdimUser(dimdimUser);
        return dimdimUser;
    }

    @Override
    public DimdimConfig getConfig(String key) {
        List list = this.dimdimConfigDAO.findByProperty(DimdimConfig.class, "key", key);
        if (list.isEmpty()) {
            return null;
        }
        return (DimdimConfig)list.get(0);
    }

    @Override
    public String getConfigValue(String key) {
        List list = this.dimdimConfigDAO.findByProperty(DimdimConfig.class, "key", key);
        if (list.isEmpty()) {
            return null;
        }
        return ((DimdimConfig)list.get(0)).getValue();
    }

    @Override
    public void saveOrUpdateConfigEntry(DimdimConfig dimdimConfig) {
        this.dimdimConfigDAO.insertOrUpdate(dimdimConfig);
    }

    public IAuditService getAuditService() {
        return this.auditService;
    }

    public void setAuditService(IAuditService auditService) {
        this.auditService = auditService;
    }

    private String sendRequest(URL url) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("request = " + url));
        }
        URLConnection connection = url.openConnection();
        BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        String response = "";
        String line = "";
        while ((line = in.readLine()) != null) {
            response = response + line;
        }
        in.close();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("response = " + response));
        }
        return response;
    }

    private NodeKey processFile(FormFile file, String type) {
        NodeKey node = null;
        if (file != null && !StringUtils.isEmpty((String)file.getFileName())) {
            String fileName = file.getFileName();
            try {
                node = this.getDimdimToolContentHandler().uploadFile(file.getInputStream(), fileName, file.getContentType(), type);
            }
            catch (InvalidParameterException e) {
                throw new DimdimException("InvalidParameterException occured while trying to upload File" + e.getMessage());
            }
            catch (FileNotFoundException e) {
                throw new DimdimException("FileNotFoundException occured while trying to upload File" + e.getMessage());
            }
            catch (RepositoryCheckedException e) {
                throw new DimdimException("RepositoryCheckedException occured while trying to upload File" + e.getMessage());
            }
            catch (IOException e) {
                throw new DimdimException("IOException occured while trying to upload File" + e.getMessage());
            }
        }
        return node;
    }

    private ITicket getRepositoryLoginTicket() throws DimdimException {
        this.repositoryService = RepositoryProxy.getRepositoryService();
        SimpleCredentials credentials = new SimpleCredentials(DimdimToolContentHandler.repositoryUser, DimdimToolContentHandler.repositoryId);
        try {
            ITicket ticket = this.repositoryService.login((ICredentials)credentials, DimdimToolContentHandler.repositoryWorkspaceName);
            return ticket;
        }
        catch (AccessDeniedException ae) {
            throw new DimdimException("Access Denied to repository." + ae.getMessage());
        }
        catch (WorkspaceNotFoundException we) {
            throw new DimdimException("Workspace not found." + we.getMessage());
        }
        catch (LoginException e) {
            throw new DimdimException("Login failed." + e.getMessage());
        }
    }

    public void import102ToolContent(Long toolContentId, UserDTO user, Hashtable importValues) {
        Date now = new Date();
        Dimdim dimdim = new Dimdim();
        dimdim.setContentInUse(Boolean.FALSE);
        dimdim.setCreateBy(new Long(user.getUserID().longValue()));
        dimdim.setCreateDate(now);
        dimdim.setDefineLater(Boolean.FALSE);
        dimdim.setInstructions(WebUtil.convertNewlines((String)((String)importValues.get("body"))));
        dimdim.setLockOnFinished(Boolean.TRUE);
        dimdim.setOfflineInstructions(null);
        dimdim.setOnlineInstructions(null);
        dimdim.setReflectInstructions(null);
        dimdim.setReflectOnActivity(Boolean.FALSE);
        dimdim.setRunOffline(Boolean.FALSE);
        dimdim.setTitle((String)importValues.get("title"));
        dimdim.setToolContentId(toolContentId);
        dimdim.setUpdateDate(now);
        this.saveOrUpdateDimdim(dimdim);
    }

    public void setReflectiveData(Long toolContentId, String title, String description) throws ToolException, DataMissingException {
        logger.warn((Object)"Setting the reflective field on a dimdim. This doesn't make sense as the dimdim is for reflection and we don't reflect on reflection!");
        Dimdim dimdim = this.getDimdimByContentId(toolContentId);
        if (dimdim == null) {
            throw new DataMissingException("Unable to set reflective data titled " + title + " on activity toolContentId " + toolContentId + " as the tool content does not exist.");
        }
        dimdim.setReflectOnActivity(Boolean.TRUE);
        dimdim.setReflectInstructions(description);
    }

    public IDimdimAttachmentDAO getDimdimAttachmentDAO() {
        return this.dimdimAttachmentDAO;
    }

    public void setDimdimAttachmentDAO(IDimdimAttachmentDAO attachmentDAO) {
        this.dimdimAttachmentDAO = attachmentDAO;
    }

    public IDimdimDAO getDimdimDAO() {
        return this.dimdimDAO;
    }

    public void setDimdimDAO(IDimdimDAO dimdimDAO) {
        this.dimdimDAO = dimdimDAO;
    }

    public IToolContentHandler getDimdimToolContentHandler() {
        return this.dimdimToolContentHandler;
    }

    public void setDimdimToolContentHandler(IToolContentHandler dimdimToolContentHandler) {
        this.dimdimToolContentHandler = dimdimToolContentHandler;
    }

    public IDimdimSessionDAO getDimdimSessionDAO() {
        return this.dimdimSessionDAO;
    }

    public void setDimdimSessionDAO(IDimdimSessionDAO sessionDAO) {
        this.dimdimSessionDAO = sessionDAO;
    }

    public IDimdimConfigDAO getDimdimConfigDAO() {
        return this.dimdimConfigDAO;
    }

    public void setDimdimConfigDAO(IDimdimConfigDAO dimdimConfigDAO) {
        this.dimdimConfigDAO = dimdimConfigDAO;
    }

    public ILamsToolService getToolService() {
        return this.toolService;
    }

    public void setToolService(ILamsToolService toolService) {
        this.toolService = toolService;
    }

    public IDimdimUserDAO getDimdimUserDAO() {
        return this.dimdimUserDAO;
    }

    public void setDimdimUserDAO(IDimdimUserDAO userDAO) {
        this.dimdimUserDAO = userDAO;
    }

    public ILearnerService getLearnerService() {
        return this.learnerService;
    }

    public void setLearnerService(ILearnerService learnerService) {
        this.learnerService = learnerService;
    }

    public IExportToolContentService getExportContentService() {
        return this.exportContentService;
    }

    public void setExportContentService(IExportToolContentService exportContentService) {
        this.exportContentService = exportContentService;
    }

    public ICoreNotebookService getCoreNotebookService() {
        return this.coreNotebookService;
    }

    public void setCoreNotebookService(ICoreNotebookService coreNotebookService) {
        this.coreNotebookService = coreNotebookService;
    }
}

