/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.dimdim.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class DimdimUtil {
    private static Pattern patternCode = Pattern.compile("code:\"(.*?)\"");
    private static Pattern patternResult = Pattern.compile("result:\"(.*?)\"");
    private static Pattern patternURL = Pattern.compile("url:\"(.*?)\"");

    public static String getMeetingKey(Long toolSessionId) {
        return "dimdim_" + toolSessionId;
    }

    public static String getReturnURL(HttpServletRequest request) {
        String protocol = request.getProtocol();
        protocol = protocol.startsWith("HTTPS") ? "https://" : "http://";
        String path = protocol + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        path = path + "endMeeting.do";
        return path;
    }

    public static String getCode(String json) {
        Matcher matcher = patternCode.matcher(json);
        matcher.find();
        return matcher.group(1);
    }

    public static String getResult(String json) {
        Matcher matcher = patternResult.matcher(json);
        matcher.find();
        return matcher.group(1);
    }

    public static String getURL(String response) throws Exception {
        Matcher matcher = patternURL.matcher(response);
        matcher.find();
        return matcher.group(1);
    }
}

