/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.dimdim.web.actions;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.MappingDispatchAction;
import org.lamsfoundation.lams.tool.dimdim.dto.ConfigDTO;
import org.lamsfoundation.lams.tool.dimdim.model.DimdimConfig;
import org.lamsfoundation.lams.tool.dimdim.service.DimdimServiceProxy;
import org.lamsfoundation.lams.tool.dimdim.service.IDimdimService;
import org.lamsfoundation.lams.tool.dimdim.web.forms.AdminForm;

public class AdminAction
extends MappingDispatchAction {
    private IDimdimService dimdimService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.dimdimService = DimdimServiceProxy.getDimdimService(this.getServlet().getServletContext());
        return super.execute(mapping, form, request, response);
    }

    public ActionForward view(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ConfigDTO configDTO = new ConfigDTO();
        configDTO.setServerURL(this.dimdimService.getConfigValue("server_url"));
        configDTO.setVersion(this.dimdimService.getConfigValue("version"));
        request.setAttribute("configDTO", (Object)configDTO);
        return mapping.findForward("view-success");
    }

    public ActionForward edit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        AdminForm adminForm = (AdminForm)form;
        adminForm.setServerURL(this.dimdimService.getConfigValue("server_url"));
        adminForm.setVersion(this.dimdimService.getConfigValue("version"));
        String version = adminForm.getVersion();
        boolean allowVersionChange = true;
        if (this.isVersionSet(version)) {
            allowVersionChange = false;
        }
        request.setAttribute("allowVersionChange", (Object)allowVersionChange);
        return mapping.findForward("edit-success");
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.isCancelled(request)) {
            AdminForm adminForm = (AdminForm)form;
            String version = this.dimdimService.getConfigValue("version");
            if (!this.isVersionSet(version)) {
                this.updateConfig("version", adminForm.getVersion());
            }
            this.updateConfig("server_url", adminForm.getServerURL().trim());
        }
        return mapping.findForward("save-success");
    }

    private void updateConfig(String key, String value) {
        DimdimConfig config = this.dimdimService.getConfig(key);
        if (config == null) {
            config = new DimdimConfig(key, value);
        } else {
            config.setValue(value);
        }
        this.dimdimService.saveOrUpdateConfigEntry(config);
    }

    private boolean isVersionSet(String version) {
        return version != null && (version.equals("standard") || version.equals("enterprise"));
    }
}

