/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.dimdim.web.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.actions.DispatchAction;
import org.apache.struts.upload.FormFile;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.dimdim.model.Dimdim;
import org.lamsfoundation.lams.tool.dimdim.model.DimdimAttachment;
import org.lamsfoundation.lams.tool.dimdim.service.DimdimServiceProxy;
import org.lamsfoundation.lams.tool.dimdim.service.IDimdimService;
import org.lamsfoundation.lams.tool.dimdim.web.forms.AuthoringForm;
import org.lamsfoundation.lams.util.FileValidatorUtil;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.util.SessionMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthoringAction
extends DispatchAction {
    private IDimdimService dimdimService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.dimdimService = DimdimServiceProxy.getDimdimService(this.getServlet().getServletContext());
        return super.execute(mapping, form, request, response);
    }

    protected ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        Long toolContentID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"toolContentID"));
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        ToolAccessMode mode = WebUtil.readToolAccessModeParam((HttpServletRequest)request, (String)"mode", (boolean)true);
        Dimdim dimdim = this.dimdimService.getDimdimByContentId(toolContentID);
        if (dimdim == null) {
            dimdim = this.dimdimService.copyDefaultContent(toolContentID);
            dimdim.setCreateDate(new Date());
            this.dimdimService.saveOrUpdateDimdim(dimdim);
        }
        if (mode != null && mode.isTeacher()) {
            dimdim.setDefineLater(true);
            this.dimdimService.saveOrUpdateDimdim(dimdim);
        }
        AuthoringForm authForm = (AuthoringForm)form;
        this.copyProperties(authForm, dimdim);
        SessionMap<String, Object> map = this.createSessionMap(dimdim, this.getAccessMode(request), contentFolderID, toolContentID);
        authForm.setSessionMapID(map.getSessionID());
        request.getSession().setAttribute(map.getSessionID(), map);
        request.setAttribute("sessionMap", map);
        return mapping.findForward("success");
    }

    public ActionForward updateContent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        AuthoringForm authForm = (AuthoringForm)form;
        SessionMap<String, Object> map = this.getSessionMap(request, authForm);
        Dimdim dimdim = this.dimdimService.getDimdimByContentId((Long)map.get((Object)"toolContentID"));
        ToolAccessMode mode = (ToolAccessMode)map.get((Object)"mode");
        this.copyProperties(dimdim, authForm, mode);
        Set<DimdimAttachment> attachments = dimdim.getDimdimAttachments();
        if (attachments == null) {
            attachments = new HashSet<DimdimAttachment>();
        }
        for (DimdimAttachment att : this.getAttList("deletedFiles", map)) {
            attachments.remove(att);
        }
        attachments.addAll(this.getAttList("unsavedOnlineFiles", map));
        attachments.addAll(this.getAttList("unsavedOfflineFiles", map));
        dimdim.setDimdimAttachments(attachments);
        dimdim.setUpdateDate(new Date());
        dimdim.setDefineLater(false);
        this.dimdimService.saveOrUpdateDimdim(dimdim);
        request.setAttribute("LAMS_AUTHORING_SUCCESS_FLAG", (Object)Boolean.TRUE);
        authForm.setSessionMapID(map.getSessionID());
        request.setAttribute("sessionMap", map);
        return mapping.findForward("success");
    }

    public ActionForward uploadOnline(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.uploadFile(mapping, (AuthoringForm)form, "ONLINE", request);
    }

    public ActionForward uploadOffline(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.uploadFile(mapping, (AuthoringForm)form, "OFFLINE", request);
    }

    public ActionForward deleteOnline(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.deleteFile(mapping, (AuthoringForm)form, "ONLINE", request);
    }

    public ActionForward deleteOffline(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.deleteFile(mapping, (AuthoringForm)form, "OFFLINE", request);
    }

    public ActionForward removeUnsavedOnline(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.removeUnsaved(mapping, (AuthoringForm)form, "ONLINE", request);
    }

    public ActionForward removeUnsavedOffline(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.removeUnsaved(mapping, (AuthoringForm)form, "OFFLINE", request);
    }

    private ActionForward uploadFile(ActionMapping mapping, AuthoringForm authForm, String type, HttpServletRequest request) {
        List<DimdimAttachment> savedFiles;
        List<DimdimAttachment> unsavedFiles;
        FormFile file;
        SessionMap<String, Object> map = this.getSessionMap(request, authForm);
        if (StringUtils.equals((String)"OFFLINE", (String)type)) {
            file = authForm.getOfflineFile();
            unsavedFiles = this.getAttList("unsavedOfflineFiles", map);
            savedFiles = this.getAttList("offlineFiles", map);
        } else {
            file = authForm.getOnlineFile();
            unsavedFiles = this.getAttList("unsavedOnlineFiles", map);
            savedFiles = this.getAttList("onlineFiles", map);
        }
        ActionMessages errors = new ActionMessages();
        FileValidatorUtil.validateFileSize((FormFile)file, (boolean)true, (ActionMessages)errors);
        if (!errors.isEmpty()) {
            request.setAttribute("sessionMap", map);
            this.saveErrors(request, errors);
            return mapping.findForward("success");
        }
        if (file.getFileName().length() != 0) {
            DimdimAttachment newAtt = this.dimdimService.uploadFileToContent((Long)map.get((Object)"toolContentID"), file, type);
            Iterator<DimdimAttachment> iter = savedFiles.iterator();
            while (iter.hasNext()) {
                DimdimAttachment currAtt = iter.next();
                if (!StringUtils.equals((String)currAtt.getFileName(), (String)newAtt.getFileName()) || !StringUtils.equals((String)currAtt.getFileType(), (String)newAtt.getFileType())) continue;
                this.getAttList("deletedFiles", map).add(currAtt);
                iter.remove();
                break;
            }
            unsavedFiles.add(newAtt);
            request.setAttribute("sessionMap", map);
        }
        return mapping.findForward("success");
    }

    private ActionForward deleteFile(ActionMapping mapping, AuthoringForm authForm, String type, HttpServletRequest request) {
        SessionMap<String, Object> map = this.getSessionMap(request, authForm);
        List<DimdimAttachment> fileList = StringUtils.equals((String)"OFFLINE", (String)type) ? this.getAttList("offlineFiles", map) : this.getAttList("onlineFiles", map);
        Iterator<DimdimAttachment> iter = fileList.iterator();
        while (iter.hasNext()) {
            DimdimAttachment att = iter.next();
            if (!att.getFileUuid().equals(authForm.getDeleteFileUuid())) continue;
            this.getAttList("deletedFiles", map).add(att);
            iter.remove();
            break;
        }
        request.setAttribute("sessionMap", map);
        return mapping.findForward("success");
    }

    private ActionForward removeUnsaved(ActionMapping mapping, AuthoringForm authForm, String type, HttpServletRequest request) {
        SessionMap<String, Object> map = this.getSessionMap(request, authForm);
        List<DimdimAttachment> unsavedFiles = StringUtils.equals((String)"OFFLINE", (String)type) ? this.getAttList("unsavedOfflineFiles", map) : this.getAttList("unsavedOnlineFiles", map);
        Iterator<DimdimAttachment> iter = unsavedFiles.iterator();
        while (iter.hasNext()) {
            DimdimAttachment att = iter.next();
            if (!att.getFileUuid().equals(authForm.getDeleteFileUuid())) continue;
            this.dimdimService.deleteFromRepository(att.getFileUuid(), att.getFileVersionId());
            iter.remove();
            break;
        }
        request.setAttribute("sessionMap", map);
        return mapping.findForward("success");
    }

    private void copyProperties(Dimdim dimdim, AuthoringForm authForm, ToolAccessMode mode) {
        dimdim.setTitle(authForm.getTitle());
        dimdim.setInstructions(authForm.getInstructions());
        if (mode.isAuthor()) {
            dimdim.setOfflineInstructions(authForm.getOfflineInstructions());
            dimdim.setOnlineInstructions(authForm.getOnlineInstructions());
            dimdim.setReflectOnActivity(authForm.isReflectOnActivity());
            dimdim.setReflectInstructions(authForm.getReflectInstructions());
            dimdim.setLockOnFinished(authForm.isLockOnFinished());
            dimdim.setMaxAttendeeMikes(authForm.getMaxAttendeeMikes());
        }
    }

    private void copyProperties(AuthoringForm authForm, Dimdim dimdim) throws ServletException {
        try {
            BeanUtils.copyProperties((Object)((Object)authForm), (Object)dimdim);
        }
        catch (IllegalAccessException e) {
            throw new ServletException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private SessionMap<String, Object> createSessionMap(Dimdim dimdim, ToolAccessMode mode, String contentFolderID, Long toolContentID) {
        SessionMap map = new SessionMap();
        map.put((Object)"mode", (Object)mode);
        map.put((Object)"contentFolderID", (Object)contentFolderID);
        map.put((Object)"toolContentID", (Object)toolContentID);
        map.put((Object)"onlineFiles", new LinkedList());
        map.put((Object)"offlineFiles", new LinkedList());
        map.put((Object)"unsavedOnlineFiles", new LinkedList());
        map.put((Object)"unsavedOfflineFiles", new LinkedList());
        map.put((Object)"deletedFiles", new LinkedList());
        for (DimdimAttachment attachment : dimdim.getDimdimAttachments()) {
            String type = attachment.getFileType();
            if (type.equals("OFFLINE")) {
                this.getAttList("offlineFiles", (SessionMap<String, Object>)map).add(attachment);
            }
            if (!type.equals("ONLINE")) continue;
            this.getAttList("onlineFiles", (SessionMap<String, Object>)map).add(attachment);
        }
        return map;
    }

    private ToolAccessMode getAccessMode(HttpServletRequest request) {
        String modeStr = request.getParameter("mode");
        ToolAccessMode mode = StringUtils.equalsIgnoreCase((String)modeStr, (String)ToolAccessMode.TEACHER.toString()) ? ToolAccessMode.TEACHER : ToolAccessMode.AUTHOR;
        return mode;
    }

    private List<DimdimAttachment> getAttList(String key, SessionMap<String, Object> map) {
        List list = (List)map.get((Object)key);
        return list;
    }

    private SessionMap<String, Object> getSessionMap(HttpServletRequest request, AuthoringForm authForm) {
        return (SessionMap)request.getSession().getAttribute(authForm.getSessionMapID());
    }
}

