/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.dimdim.web.actions;

import java.io.IOException;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.CoreNotebookConstants;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.ToolSessionManager;
import org.lamsfoundation.lams.tool.dimdim.dto.ContentDTO;
import org.lamsfoundation.lams.tool.dimdim.dto.NotebookEntryDTO;
import org.lamsfoundation.lams.tool.dimdim.dto.UserDTO;
import org.lamsfoundation.lams.tool.dimdim.model.Dimdim;
import org.lamsfoundation.lams.tool.dimdim.model.DimdimSession;
import org.lamsfoundation.lams.tool.dimdim.model.DimdimUser;
import org.lamsfoundation.lams.tool.dimdim.service.DimdimServiceProxy;
import org.lamsfoundation.lams.tool.dimdim.service.IDimdimService;
import org.lamsfoundation.lams.tool.dimdim.util.DimdimException;
import org.lamsfoundation.lams.tool.dimdim.util.DimdimUtil;
import org.lamsfoundation.lams.tool.dimdim.web.forms.LearningForm;
import org.lamsfoundation.lams.tool.exception.DataMissingException;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.session.SessionManager;

public class LearningAction
extends DispatchAction {
    private static final Logger logger = Logger.getLogger(LearningAction.class);
    private IDimdimService dimdimService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.dimdimService = DimdimServiceProxy.getDimdimService(this.getServlet().getServletContext());
        return super.execute(mapping, form, request, response);
    }

    public ActionForward finishActivity(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Long toolSessionID = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolSessionID");
        DimdimUser user = this.getCurrentUser(toolSessionID);
        if (user != null) {
            LearningForm learningForm = (LearningForm)form;
            if (user.getNotebookEntryUID() == null) {
                user.setNotebookEntryUID(this.dimdimService.createNotebookEntry(toolSessionID, CoreNotebookConstants.NOTEBOOK_TOOL, "laddim10", user.getUserId().intValue(), learningForm.getEntryText()));
            } else {
                this.dimdimService.updateNotebookEntry(user.getNotebookEntryUID(), learningForm.getEntryText());
            }
            user.setFinishedActivity(true);
            this.dimdimService.saveOrUpdateDimdimUser(user);
        } else {
            logger.error((Object)("finishActivity(): couldn't find/create DimdimUser in toolSessionID: " + toolSessionID));
        }
        ToolSessionManager sessionMgrService = DimdimServiceProxy.getDimdimSessionManager(this.getServlet().getServletContext());
        try {
            String nextActivityUrl = sessionMgrService.leaveToolSession(toolSessionID, user.getUserId());
            response.sendRedirect(nextActivityUrl);
        }
        catch (DataMissingException e) {
            throw new DimdimException(e);
        }
        catch (ToolException e) {
            throw new DimdimException(e);
        }
        catch (IOException e) {
            throw new DimdimException(e);
        }
        return null;
    }

    private DimdimUser getCurrentUser(Long toolSessionId) {
        org.lamsfoundation.lams.usermanagement.dto.UserDTO lamsUserDTO = (org.lamsfoundation.lams.usermanagement.dto.UserDTO)SessionManager.getSession().getAttribute("user");
        DimdimUser user = this.dimdimService.getUserByUserIdAndSessionId(new Long(lamsUserDTO.getUserID().intValue()), toolSessionId);
        if (user == null) {
            DimdimSession dimdimSession = this.dimdimService.getSessionBySessionId(toolSessionId);
            user = this.dimdimService.createDimdimUser(lamsUserDTO, dimdimSession);
        }
        return user;
    }

    public ActionForward openLearnerMeeting(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Long uid = WebUtil.readLongParam((HttpServletRequest)request, (String)"userUID");
        DimdimUser user = this.dimdimService.getUserByUID(uid);
        String meetingKey = DimdimUtil.getMeetingKey(user.getDimdimSession().getSessionId());
        org.lamsfoundation.lams.usermanagement.dto.UserDTO lamsUserDTO = (org.lamsfoundation.lams.usermanagement.dto.UserDTO)SessionManager.getSession().getAttribute("user");
        String meetingURL = this.dimdimService.getDimdimJoinConferenceURL(lamsUserDTO, meetingKey);
        if (meetingURL == null) {
            logger.error((Object)"startAction did not return a url to start the meeting");
            request.setAttribute("messageKey", (Object)"message.unableToStartLesson");
            return mapping.findForward("generalMessage");
        }
        response.sendRedirect(meetingURL);
        return null;
    }

    public ActionForward openNotebook(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LearningForm lrnForm = (LearningForm)form;
        DimdimUser user = this.getCurrentUser(lrnForm.getToolSessionID());
        ContentDTO contentDTO = new ContentDTO(user.getDimdimSession().getDimdim());
        request.setAttribute("contentDTO", (Object)contentDTO);
        NotebookEntry notebookEntry = this.dimdimService.getNotebookEntry(user.getNotebookEntryUID());
        if (notebookEntry != null) {
            lrnForm.setEntryText(notebookEntry.getEntry());
        }
        return mapping.findForward("notebook");
    }

    public ActionForward openPreviewMeeting(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer maxAttendeeMikes;
        String returnURL;
        String meetingKey;
        Long uid = WebUtil.readLongParam((HttpServletRequest)request, (String)"userUID");
        DimdimUser user = this.dimdimService.getUserByUID(uid);
        DimdimSession session = user.getDimdimSession();
        org.lamsfoundation.lams.usermanagement.dto.UserDTO lamsUserDTO = (org.lamsfoundation.lams.usermanagement.dto.UserDTO)SessionManager.getSession().getAttribute("user");
        String meetingURL = this.dimdimService.getDimdimStartConferenceURL(lamsUserDTO, meetingKey = DimdimUtil.getMeetingKey(session.getSessionId()), returnURL = DimdimUtil.getReturnURL(request), maxAttendeeMikes = session.getDimdim().getMaxAttendeeMikes());
        if (meetingURL == null) {
            logger.error((Object)"startAction did not return a url to start the meeting");
            throw new DimdimException("Unable to start meeting");
        }
        response.sendRedirect(meetingURL);
        return null;
    }

    public ActionForward submitReflection(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        LearningForm lrnForm = (LearningForm)form;
        DimdimUser user = this.getCurrentUser(lrnForm.getToolSessionID());
        Long toolSessionID = user.getDimdimSession().getSessionId();
        Integer userID = user.getUserId().intValue();
        NotebookEntry entry = this.dimdimService.getNotebookEntry(user.getNotebookEntryUID());
        if (entry == null) {
            Long entryUID = this.dimdimService.createNotebookEntry(toolSessionID, CoreNotebookConstants.NOTEBOOK_TOOL, "laddim10", userID, lrnForm.getEntryText());
            user.setNotebookEntryUID(entryUID);
            this.dimdimService.saveOrUpdateDimdimUser(user);
        } else {
            entry.setEntry(lrnForm.getEntryText());
            entry.setLastModified(new Date());
            this.dimdimService.updateNotebookEntry(entry);
        }
        return this.finishActivity(mapping, form, request, response);
    }

    public ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DimdimUser user;
        LearningForm learningForm = (LearningForm)form;
        ToolAccessMode mode = WebUtil.readToolAccessModeParam((HttpServletRequest)request, (String)"mode", (boolean)false);
        Long toolSessionID = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolSessionID");
        DimdimSession session = this.dimdimService.getSessionBySessionId(toolSessionID);
        if (session == null) {
            throw new DimdimException("Cannot retrieve session with toolSessionID" + toolSessionID);
        }
        Dimdim dimdim = session.getDimdim();
        if (dimdim.isDefineLater()) {
            return mapping.findForward("defineLater");
        }
        request.setAttribute("mode", (Object)mode.toString());
        learningForm.setToolSessionID(toolSessionID);
        ContentDTO contentDTO = new ContentDTO();
        contentDTO.setTitle(dimdim.getTitle());
        contentDTO.setInstructions(dimdim.getInstructions());
        contentDTO.setLockOnFinish(dimdim.isLockOnFinished());
        contentDTO.setReflectOnActivity(dimdim.isReflectOnActivity());
        contentDTO.setReflectInstructions(dimdim.getReflectInstructions());
        request.setAttribute("contentDTO", (Object)contentDTO);
        if (!dimdim.isContentInUse()) {
            dimdim.setContentInUse(true);
            this.dimdimService.saveOrUpdateDimdim(dimdim);
        }
        if (dimdim.isRunOffline()) {
            return mapping.findForward("runOffline");
        }
        if (mode.equals((Object)ToolAccessMode.TEACHER)) {
            Long userID = WebUtil.readLongParam((HttpServletRequest)request, (String)"userID", (boolean)false);
            user = this.dimdimService.getUserByUserIdAndSessionId(userID, toolSessionID);
        } else {
            user = this.getCurrentUser(toolSessionID);
        }
        NotebookEntry entry = this.dimdimService.getNotebookEntry(user.getNotebookEntryUID());
        UserDTO userDTO = new UserDTO(user);
        if (entry != null) {
            userDTO.setNotebookEntryDTO(new NotebookEntryDTO(entry));
        }
        request.setAttribute("userDTO", (Object)userDTO);
        String version = this.dimdimService.getConfigValue("version");
        if (version == null) {
            logger.error((Object)"Config value version returned null");
            throw new DimdimException("Server version not defined");
        }
        String dispatchValue = new String();
        boolean meetingOpen = false;
        if (mode.isAuthor()) {
            dispatchValue = "openPreviewMeeting";
            meetingOpen = true;
        } else if (session.isMeetingCreated()) {
            dispatchValue = "openLearnerMeeting";
            meetingOpen = true;
        }
        String meetingURL = Configuration.get((String)ConfigurationKeys.SERVER_URL) + "/tool/" + "laddim10" + "/learning.do?dispatch=" + dispatchValue + "&" + "userUID" + "=" + user.getUid();
        request.setAttribute("meetingOpen", (Object)meetingOpen);
        request.setAttribute("meetingURL", (Object)meetingURL);
        request.setAttribute("toolSessionID", (Object)session.getSessionId());
        return mapping.findForward("dimdim");
    }
}

