/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.dimdim.web.actions;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.tool.dimdim.dto.ContentDTO;
import org.lamsfoundation.lams.tool.dimdim.dto.NotebookEntryDTO;
import org.lamsfoundation.lams.tool.dimdim.dto.UserDTO;
import org.lamsfoundation.lams.tool.dimdim.model.Dimdim;
import org.lamsfoundation.lams.tool.dimdim.model.DimdimSession;
import org.lamsfoundation.lams.tool.dimdim.model.DimdimUser;
import org.lamsfoundation.lams.tool.dimdim.service.DimdimServiceProxy;
import org.lamsfoundation.lams.tool.dimdim.service.IDimdimService;
import org.lamsfoundation.lams.tool.dimdim.util.DimdimException;
import org.lamsfoundation.lams.tool.dimdim.util.DimdimUtil;
import org.lamsfoundation.lams.tool.dimdim.web.forms.MonitoringForm;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.session.SessionManager;

public class MonitoringAction
extends DispatchAction {
    private static final Logger logger = Logger.getLogger(MonitoringAction.class);
    private IDimdimService dimdimService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.dimdimService = DimdimServiceProxy.getDimdimService(this.getServlet().getServletContext());
        return super.execute(mapping, form, request, response);
    }

    public ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Long toolContentID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"toolContentID"));
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        Dimdim dimdim = this.dimdimService.getDimdimByContentId(toolContentID);
        if (dimdim == null) {
            logger.error((Object)("Unable to find tool content with id :" + toolContentID));
            throw new DimdimException("Invalid value for toolContentID");
        }
        ContentDTO contentDT0 = new ContentDTO(dimdim);
        MonitoringForm monitoringForm = (MonitoringForm)form;
        monitoringForm.setMaxAttendeeMikes(contentDT0.getMaxAttendeeMikes());
        Long currentTab = WebUtil.readLongParam((HttpServletRequest)request, (String)"currentTab", (boolean)true);
        contentDT0.setCurrentTab(currentTab);
        request.setAttribute("contentDTO", (Object)contentDT0);
        request.setAttribute("contentFolderID", (Object)contentFolderID);
        return mapping.findForward("success");
    }

    public ActionForward openNotebook(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Long uid = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"userUID"));
        DimdimUser user = this.dimdimService.getUserByUID(uid);
        NotebookEntry entry = this.dimdimService.getNotebookEntry(user.getNotebookEntryUID());
        UserDTO userDTO = new UserDTO(user);
        userDTO.setNotebookEntryDTO(new NotebookEntryDTO(entry));
        request.setAttribute("userDTO", (Object)userDTO);
        return mapping.findForward("dimdim_display");
    }

    public ActionForward startMeeting(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MonitoringForm monitoringForm = (MonitoringForm)form;
        DimdimSession session = this.dimdimService.getSessionBySessionId(monitoringForm.getToolSessionID());
        session.setMaxAttendeeMikes(monitoringForm.getMaxAttendeeMikes());
        org.lamsfoundation.lams.usermanagement.dto.UserDTO lamsUserDTO = (org.lamsfoundation.lams.usermanagement.dto.UserDTO)SessionManager.getSession().getAttribute("user");
        String meetingStartURL = this.dimdimService.getDimdimStartConferenceURL(lamsUserDTO, DimdimUtil.getMeetingKey(session.getSessionId()), DimdimUtil.getReturnURL(request), session.getMaxAttendeeMikes());
        if (meetingStartURL == null) {
            logger.error((Object)"startAction did not return a url to start the meeting");
            throw new DimdimException("Unable to start meeting");
        }
        session.setMeetingCreated(true);
        response.sendRedirect(meetingStartURL);
        this.dimdimService.saveOrUpdateDimdimSession(session);
        return null;
    }
}

