/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.dimdim.web.servlets;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.dimdim.model.Dimdim;
import org.lamsfoundation.lams.tool.dimdim.model.DimdimSession;
import org.lamsfoundation.lams.tool.dimdim.service.DimdimServiceProxy;
import org.lamsfoundation.lams.tool.dimdim.service.IDimdimService;
import org.lamsfoundation.lams.tool.dimdim.util.DimdimException;
import org.lamsfoundation.lams.web.servlet.AbstractExportPortfolioServlet;

public class ExportServlet
extends AbstractExportPortfolioServlet {
    private static final long serialVersionUID = -2829707715037631881L;
    private static final Logger logger = Logger.getLogger(ExportServlet.class);
    private final String FILENAME = "dimdim_main.html";
    private IDimdimService dimdimService;

    protected String doExport(HttpServletRequest request, HttpServletResponse response, String directoryName, Cookie[] cookies) {
        this.setupService();
        try {
            if (StringUtils.equals((String)this.mode, (String)ToolAccessMode.LEARNER.toString())) {
                request.getSession().setAttribute("mode", (Object)ToolAccessMode.LEARNER);
                this.doLearnerExport(request, response, directoryName, cookies);
            } else if (StringUtils.equals((String)this.mode, (String)ToolAccessMode.TEACHER.toString())) {
                request.getSession().setAttribute("mode", (Object)ToolAccessMode.TEACHER);
                this.doTeacherExport(request, response, directoryName, cookies);
            }
        }
        catch (DimdimException e) {
            logger.error((Object)"Cannot perform export for dimdim tool.");
        }
        String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
        this.writeResponseToFile(basePath + "/pages/export/exportPortfolio.jsp", directoryName, "dimdim_main.html", cookies);
        return "dimdim_main.html";
    }

    protected String doOfflineExport(HttpServletRequest request, HttpServletResponse response, String directoryName, Cookie[] cookies) {
        if (this.toolContentID == null && this.toolSessionID == null) {
            logger.error((Object)"Tool content Id or and session Id are null. Unable to activity title");
        } else {
            this.setupService();
            Dimdim content = null;
            if (this.toolContentID != null) {
                content = this.dimdimService.getDimdimByContentId(this.toolContentID);
            } else {
                DimdimSession session = this.dimdimService.getSessionBySessionId(this.toolSessionID);
                if (session != null) {
                    content = session.getDimdim();
                }
            }
            if (content != null) {
                this.activityTitle = content.getTitle();
            }
        }
        return super.doOfflineExport(request, response, directoryName, cookies);
    }

    private void doLearnerExport(HttpServletRequest request, HttpServletResponse response, String directoryName, Cookie[] cookies) throws DimdimException {
        logger.debug((Object)("doExportLearner: toolContentID:" + this.toolSessionID));
    }

    private void doTeacherExport(HttpServletRequest request, HttpServletResponse response, String directoryName, Cookie[] cookies) throws DimdimException {
        logger.debug((Object)("doExportTeacher: toolContentID:" + this.toolContentID));
    }

    private void setupService() {
        if (this.dimdimService == null) {
            this.dimdimService = DimdimServiceProxy.getDimdimService(this.getServletContext());
        }
    }
}

