/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.taskList.service;

import java.util.List;
import java.util.Set;
import org.apache.struts.upload.FormFile;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.tool.taskList.dto.GroupSummary;
import org.lamsfoundation.lams.tool.taskList.dto.Summary;
import org.lamsfoundation.lams.tool.taskList.model.TaskList;
import org.lamsfoundation.lams.tool.taskList.model.TaskListAttachment;
import org.lamsfoundation.lams.tool.taskList.model.TaskListItem;
import org.lamsfoundation.lams.tool.taskList.model.TaskListItemAttachment;
import org.lamsfoundation.lams.tool.taskList.model.TaskListSession;
import org.lamsfoundation.lams.tool.taskList.model.TaskListUser;
import org.lamsfoundation.lams.tool.taskList.service.TaskListException;
import org.lamsfoundation.lams.tool.taskList.service.UploadTaskListFileException;
import org.lamsfoundation.lams.util.MessageService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ITaskListService {
    public int getNumTasksCompletedByUser(Long var1, Long var2);

    public boolean checkCondition(String var1, Long var2, Long var3);

    public TaskList getTaskListByContentId(Long var1);

    public TaskList getDefaultContent(Long var1) throws TaskListException;

    public List getAuthoredItems(Long var1);

    public TaskListAttachment uploadInstructionFile(FormFile var1, String var2) throws UploadTaskListFileException;

    public TaskListItemAttachment uploadTaskListItemFile(FormFile var1, String var2, TaskListUser var3) throws UploadTaskListFileException;

    public MessageService getMessageService();

    public void createUser(TaskListUser var1);

    public TaskListUser getUserByIDAndContent(Long var1, Long var2);

    public TaskListUser getUserByIDAndSession(Long var1, Long var2);

    public List<TaskListUser> getUserListBySessionItem(Long var1, Long var2);

    public List<TaskListUser> getUserListBySessionId(Long var1);

    public TaskListUser getUser(Long var1);

    public void deleteFromRepository(Long var1, Long var2) throws TaskListException;

    public void saveOrUpdateTaskList(TaskList var1);

    public void deleteTaskListAttachment(Long var1);

    public void deleteTaskListItem(Long var1);

    public void deleteTaskListCondition(Long var1);

    public TaskList getTaskListBySessionId(Long var1);

    public TaskListItem getTaskListItemByUid(Long var1);

    public void saveOrUpdateTaskListItem(TaskListItem var1);

    public void retrieveComplete(Set<TaskListItem> var1, TaskListUser var2);

    public void setItemComplete(Long var1, Long var2, Long var3);

    public void setItemAccess(Long var1, Long var2, Long var3);

    public TaskListSession getTaskListSessionBySessionId(Long var1);

    public void saveOrUpdateTaskListSession(TaskListSession var1);

    public String finishToolSession(Long var1, Long var2) throws TaskListException;

    public Long createNotebookEntry(Long var1, Integer var2, String var3, Integer var4, String var5);

    public NotebookEntry getEntry(Long var1, Integer var2, String var3, Integer var4);

    public void updateEntry(NotebookEntry var1);

    public List<List<GroupSummary>> exportForLearner(Long var1, TaskListUser var2);

    public List<List<GroupSummary>> exportForTeacher(Long var1);

    public List<Summary> getSummary(Long var1);

    public List<GroupSummary> getItemSummary(Long var1, Long var2, boolean var3);
}

