/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.taskList.web.action;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.ActionRedirect;
import org.apache.struts.upload.FormFile;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.CoreNotebookConstants;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.taskList.dto.TasListItemDTO;
import org.lamsfoundation.lams.tool.taskList.model.TaskList;
import org.lamsfoundation.lams.tool.taskList.model.TaskListItem;
import org.lamsfoundation.lams.tool.taskList.model.TaskListItemAttachment;
import org.lamsfoundation.lams.tool.taskList.model.TaskListItemComment;
import org.lamsfoundation.lams.tool.taskList.model.TaskListSession;
import org.lamsfoundation.lams.tool.taskList.model.TaskListUser;
import org.lamsfoundation.lams.tool.taskList.service.ITaskListService;
import org.lamsfoundation.lams.tool.taskList.service.TaskListException;
import org.lamsfoundation.lams.tool.taskList.service.UploadTaskListFileException;
import org.lamsfoundation.lams.tool.taskList.util.TaskListItemAttachmentComparator;
import org.lamsfoundation.lams.tool.taskList.util.TaskListItemCommentComparator;
import org.lamsfoundation.lams.tool.taskList.util.TaskListItemComparator;
import org.lamsfoundation.lams.tool.taskList.web.form.ReflectionForm;
import org.lamsfoundation.lams.tool.taskList.web.form.TaskListItemForm;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.FileValidatorUtil;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.lamsfoundation.lams.web.util.SessionMap;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class LearningAction
extends Action {
    private static Logger log = Logger.getLogger(LearningAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, UploadTaskListFileException {
        String param = mapping.getParameter();
        if (param.equals("start")) {
            return this.start(mapping, form, request, response);
        }
        if (param.equals("complete")) {
            return this.complete(mapping, form, request, response);
        }
        if (param.equals("finish")) {
            return this.finish(mapping, form, request, response);
        }
        if (param.equals("addtask")) {
            return this.addTask(mapping, form, request, response);
        }
        if (param.equals("saveNewTask")) {
            return this.saveNewTask(mapping, form, request, response);
        }
        if (param.equals("addNewComment")) {
            return this.addNewComment(mapping, form, request, response);
        }
        if (param.equals("uploadFile")) {
            return this.uploadFile(mapping, form, request, response);
        }
        if (param.equals("newReflection")) {
            return this.newReflection(mapping, form, request, response);
        }
        if (param.equals("submitReflection")) {
            return this.submitReflection(mapping, form, request, response);
        }
        return mapping.findForward("error");
    }

    private ActionForward start(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        NotebookEntry notebookEntry;
        SessionMap sessionMap = new SessionMap();
        request.getSession().setAttribute(sessionMap.getSessionID(), (Object)sessionMap);
        ToolAccessMode mode = WebUtil.readToolAccessModeParam((HttpServletRequest)request, (String)"mode", (boolean)true);
        Long sessionId = new Long(request.getParameter("toolSessionID"));
        request.setAttribute("sessionMapID", (Object)sessionMap.getSessionID());
        request.setAttribute("mode", (Object)mode);
        request.setAttribute("toolSessionID", (Object)sessionId);
        ITaskListService service = this.getTaskListService();
        TaskListUser taskListUser = null;
        taskListUser = mode != null && mode.isTeacher() ? this.getSpecifiedUser(service, sessionId, WebUtil.readIntParam((HttpServletRequest)request, (String)"userID", (boolean)false)) : this.getCurrentUser(service, sessionId);
        TaskList taskList = service.getTaskListBySessionId(sessionId);
        TreeSet<TaskListItem> items = new TreeSet<TaskListItem>(new TaskListItemComparator());
        if (mode.isLearner()) {
            List<TaskListUser> grouppedUsers = service.getUserListBySessionId(sessionId);
            Set allTaskListItems = taskList.getTaskListItems();
            for (TaskListItem item : allTaskListItems) {
                for (TaskListUser grouppedUser : grouppedUsers) {
                    if (!item.isCreateByAuthor() && !grouppedUser.getUserId().equals(item.getCreateBy().getUserId())) continue;
                    items.add(item);
                }
            }
        } else {
            items.addAll(taskList.getTaskListItems());
        }
        boolean lock = taskList.getLockWhenFinished() && taskListUser != null && taskListUser.isSessionFinished();
        String entryText = new String();
        if (taskListUser != null && (notebookEntry = service.getEntry(sessionId, CoreNotebookConstants.NOTEBOOK_TOOL, "latask10", taskListUser.getUserId().intValue())) != null) {
            entryText = notebookEntry.getEntry();
        }
        if (taskListUser != null) {
            service.retrieveComplete(items, taskListUser);
        }
        TreeSet<TasListItemDTO> itemDTOs = new TreeSet<TasListItemDTO>(new Comparator<TasListItemDTO>(){

            @Override
            public int compare(TasListItemDTO o1, TasListItemDTO o2) {
                if (o1 != null && o2 != null) {
                    return o1.getTaskListItem().getSequenceId() - o2.getTaskListItem().getSequenceId();
                }
                if (o1 != null) {
                    return 1;
                }
                return -1;
            }
        });
        boolean isPreviousTaskCompleted = true;
        for (TaskListItem item : items) {
            TasListItemDTO itemDTO = new TasListItemDTO(item);
            boolean isCommentRequirementsMet = true;
            if (item.isCommentsRequired()) {
                isCommentRequirementsMet = false;
                Set comments = item.getComments();
                for (TaskListItemComment comment : comments) {
                    if (!taskListUser.getUserId().equals(comment.getCreateBy().getUserId())) continue;
                    isCommentRequirementsMet = true;
                }
            }
            itemDTO.setCommentRequirementsMet(isCommentRequirementsMet);
            boolean isAttachmentRequirementsMet = true;
            if (item.isFilesRequired()) {
                isAttachmentRequirementsMet = false;
                Set attachments = item.getAttachments();
                for (TaskListItemAttachment attachment : attachments) {
                    if (!taskListUser.getUserId().equals(attachment.getCreateBy().getUserId())) continue;
                    isAttachmentRequirementsMet = true;
                }
            }
            itemDTO.setAttachmentRequirementsMet(isAttachmentRequirementsMet);
            boolean isAllowedByParent = true;
            if (item.isChildTask()) {
                for (TaskListItem parentItem : items) {
                    if (!parentItem.getTitle().equals(item.getParentTaskName()) || parentItem.isComplete()) continue;
                    isAllowedByParent = false;
                }
            }
            itemDTO.setAllowedByParent(isAllowedByParent);
            boolean isDisplayedOpen = true;
            if (item.getDescription() != null && item.getDescription().length() > 1000) {
                isDisplayedOpen = false;
            }
            itemDTO.setDisplayedOpen(isDisplayedOpen);
            itemDTO.setPreviousTaskCompleted(isPreviousTaskCompleted);
            isPreviousTaskCompleted = item.isComplete();
            Set<TaskListItemComment> filteredComments = new TreeSet<TaskListItemComment>(new TaskListItemCommentComparator());
            Set<TaskListItemAttachment> filteredAttachments = new TreeSet<TaskListItemAttachment>(new TaskListItemAttachmentComparator());
            if (mode.isLearner()) {
                List<TaskListUser> grouppedUsers = service.getUserListBySessionId(sessionId);
                Set comments = item.getComments();
                Set attachments = item.getAttachments();
                for (TaskListItemComment comment : comments) {
                    for (TaskListUser grouppedUser : grouppedUsers) {
                        if (!grouppedUser.getUserId().equals(comment.getCreateBy().getUserId())) continue;
                        filteredComments.add(comment);
                    }
                }
                for (TaskListItemAttachment attachment : attachments) {
                    for (TaskListUser grouppedUser : grouppedUsers) {
                        if (!grouppedUser.getUserId().equals(attachment.getCreateBy().getUserId())) continue;
                        filteredAttachments.add(attachment);
                    }
                }
            } else {
                filteredComments = item.getComments();
                filteredAttachments = item.getAttachments();
            }
            itemDTO.setComments(filteredComments);
            itemDTO.setAttachments(filteredAttachments);
            itemDTOs.add(itemDTO);
        }
        Integer numberCompletedTasks = service.getNumTasksCompletedByUser(sessionId, taskListUser.getUserId());
        Integer minimumNumberTasks = taskList.getMinimumNumberTasks();
        if (minimumNumberTasks - numberCompletedTasks > 0) {
            String MinimumNumberTasksStr = service.getMessageService().getMessage("lable.learning.minimum.view.number", new Object[]{minimumNumberTasks, numberCompletedTasks});
            taskList.setMinimumNumberTasksErrorStr(MinimumNumberTasksStr);
        }
        if (taskList.isDefineLater()) {
            return mapping.findForward("defineLater");
        }
        taskList.setContentInUse(true);
        taskList.setDefineLater(false);
        service.saveOrUpdateTaskList(taskList);
        if (taskList.getRunOffline()) {
            sessionMap.put((Object)"runOffline", (Object)true);
            return mapping.findForward("runOffline");
        }
        sessionMap.put((Object)"runOffline", (Object)false);
        sessionMap.put((Object)"taskList", (Object)taskList);
        sessionMap.put((Object)"title", (Object)taskList.getTitle());
        sessionMap.put((Object)"finishedLock", (Object)lock);
        sessionMap.put((Object)"userFinished", (Object)(taskListUser != null && taskListUser.isSessionFinished() ? 1 : 0));
        sessionMap.put((Object)"userVerifiedByMonitor", (Object)taskListUser.isVerifiedByMonitor());
        sessionMap.put((Object)"toolSessionID", (Object)sessionId);
        sessionMap.put((Object)"mode", (Object)mode);
        sessionMap.put((Object)"itemDTOs", itemDTOs);
        sessionMap.put((Object)"reflectOn", (Object)taskList.isReflectOnActivity());
        sessionMap.put((Object)"reflectInstructions", (Object)taskList.getReflectInstructions());
        sessionMap.put((Object)"reflectEntry", (Object)entryText);
        return mapping.findForward("success");
    }

    private ActionForward complete(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String mode = request.getParameter("mode");
        String sessionMapID = request.getParameter("sessionMapID");
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        Long sessionId = (Long)sessionMap.get((Object)"toolSessionID");
        this.doComplete(request);
        ActionRedirect redirect = new ActionRedirect(mapping.findForwardConfig("success"));
        redirect.addParameter("mode", (Object)mode);
        redirect.addParameter("toolSessionID", (Object)sessionId);
        return redirect;
    }

    private ActionForward finish(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String sessionMapID = request.getParameter("sessionMapID");
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        Long sessionId = (Long)sessionMap.get((Object)"toolSessionID");
        String taskListItemUid = request.getParameter("itemUid");
        if (taskListItemUid != null) {
            this.doComplete(request);
            request.setAttribute("runAuto", (Object)true);
        } else {
            request.setAttribute("runAuto", (Object)false);
        }
        if (!this.validateBeforeFinish(request, sessionMapID)) {
            return mapping.getInputForward();
        }
        ITaskListService service = this.getTaskListService();
        String nextActivityUrl = null;
        try {
            HttpSession ss = SessionManager.getSession();
            UserDTO user = (UserDTO)ss.getAttribute("user");
            Long userID = new Long(user.getUserID().longValue());
            nextActivityUrl = service.finishToolSession(sessionId, userID);
            request.setAttribute("nextActivityUrl", (Object)nextActivityUrl);
        }
        catch (TaskListException e) {
            log.error((Object)("Failed get next activity url:" + e.getMessage()));
        }
        return mapping.findForward("success");
    }

    private ActionForward addTask(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        TaskListItemForm itemForm = (TaskListItemForm)form;
        itemForm.setMode(WebUtil.readStrParam((HttpServletRequest)request, (String)"mode"));
        itemForm.setSessionMapID(WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID"));
        return mapping.findForward("success");
    }

    private ActionForward saveNewTask(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String sessionMapID = request.getParameter("sessionMapID");
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        TaskListItemForm itemForm = (TaskListItemForm)form;
        ActionErrors errors = this.validateTaskListItem(itemForm);
        if (!errors.isEmpty()) {
            this.addErrors(request, (ActionMessages)errors);
            request.setAttribute("sessionMapID", (Object)sessionMapID);
            return mapping.findForward("task");
        }
        TaskListItem item = new TaskListItem();
        ITaskListService service = this.getTaskListService();
        Long sessionId = (Long)sessionMap.get((Object)"toolSessionID");
        TaskListUser taskListUser = this.getCurrentUser(service, sessionId);
        item.setTitle(itemForm.getTitle());
        item.setDescription(itemForm.getDescription());
        item.setCreateDate(new Timestamp(new Date().getTime()));
        item.setCreateByAuthor(false);
        item.setCreateBy(taskListUser);
        TaskList taskList = (TaskList)sessionMap.get((Object)"taskList");
        Set taskListItems = taskList.getTaskListItems();
        int maxSeq = 0;
        for (TaskListItem dbItem : taskListItems) {
            if (dbItem.getSequenceId() <= maxSeq) continue;
            maxSeq = dbItem.getSequenceId();
        }
        item.setSequenceId(++maxSeq);
        taskListItems.add(item);
        service.saveOrUpdateTaskList(taskList);
        String mode = request.getParameter("mode");
        request.setAttribute("mode", (Object)mode);
        request.setAttribute("toolSessionID", (Object)sessionId);
        return mapping.findForward("success");
    }

    private ActionForward addNewComment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        TaskListItemForm taskListItemForm = (TaskListItemForm)form;
        String mode = request.getParameter("mode");
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(taskListItemForm.getSessionMapID());
        request.setAttribute("sessionMapID", (Object)sessionMap.getSessionID());
        Long sessionId = (Long)sessionMap.get((Object)"toolSessionID");
        String commentMessage = taskListItemForm.getComment();
        if (commentMessage == null || StringUtils.isBlank((String)commentMessage)) {
            return mapping.findForward("refresh");
        }
        TaskListItemComment comment = new TaskListItemComment();
        comment.setComment(commentMessage);
        UserDTO user = (UserDTO)SessionManager.getSession().getAttribute("user");
        ITaskListService service = this.getTaskListService();
        TaskListUser taskListUser = service.getUserByIDAndSession(new Long(user.getUserID().intValue()), sessionId);
        comment.setCreateBy(taskListUser);
        comment.setCreateDate(new Timestamp(new Date().getTime()));
        Long itemUid = new Long(request.getParameter("itemUid"));
        TaskListItem dbItem = service.getTaskListItemByUid(itemUid);
        Set dbComments = dbItem.getComments();
        dbComments.add(comment);
        service.saveOrUpdateTaskListItem(dbItem);
        sessionMap.put((Object)"taskListItem", (Object)dbItem);
        ActionRedirect redirect = new ActionRedirect(mapping.findForwardConfig("success"));
        redirect.addParameter("mode", (Object)mode);
        redirect.addParameter("toolSessionID", (Object)sessionId);
        return redirect;
    }

    private ActionForward uploadFile(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws UploadTaskListFileException {
        TaskListItemForm taskListItemForm = (TaskListItemForm)form;
        String mode = request.getParameter("mode");
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(taskListItemForm.getSessionMapID());
        request.setAttribute("sessionMapID", (Object)sessionMap.getSessionID());
        Long sessionId = (Long)sessionMap.get((Object)"toolSessionID");
        FormFile file = taskListItemForm.getUploadedFile();
        if (file == null || StringUtils.isBlank((String)file.getFileName())) {
            return mapping.findForward("refresh");
        }
        ActionMessages errors = new ActionMessages();
        FileValidatorUtil.validateFileSize((FormFile)file, (boolean)true, (ActionMessages)errors);
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
            return mapping.findForward("refresh");
        }
        ITaskListService service = this.getTaskListService();
        UserDTO user = (UserDTO)SessionManager.getSession().getAttribute("user");
        TaskListUser taskListUser = service.getUserByIDAndSession(new Long(user.getUserID().intValue()), sessionId);
        TaskListItemAttachment att = service.uploadTaskListItemFile(file, "ONLINE", taskListUser);
        Long itemUid = new Long(request.getParameter("itemUid"));
        TaskListItem dbItem = service.getTaskListItemByUid(itemUid);
        Set dbAttachments = dbItem.getAttachments();
        dbAttachments.add(att);
        service.saveOrUpdateTaskListItem(dbItem);
        sessionMap.put((Object)"taskListItem", (Object)dbItem);
        ActionRedirect redirect = new ActionRedirect(mapping.findForwardConfig("success"));
        redirect.addParameter("mode", (Object)mode);
        redirect.addParameter("toolSessionID", (Object)sessionId);
        return redirect;
    }

    private ActionForward newReflection(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String sessionMapID = WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID");
        if (!this.validateBeforeFinish(request, sessionMapID)) {
            return mapping.getInputForward();
        }
        ReflectionForm refForm = (ReflectionForm)form;
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        refForm.setUserID(user.getUserID());
        refForm.setSessionMapID(sessionMapID);
        ITaskListService submitFilesService = this.getTaskListService();
        SessionMap map = (SessionMap)request.getSession().getAttribute(sessionMapID);
        Long toolSessionID = (Long)map.get((Object)"toolSessionID");
        NotebookEntry entry = submitFilesService.getEntry(toolSessionID, CoreNotebookConstants.NOTEBOOK_TOOL, "latask10", user.getUserID());
        if (entry != null) {
            refForm.setEntryText(entry.getEntry());
        }
        return mapping.findForward("success");
    }

    private ActionForward submitReflection(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ReflectionForm refForm = (ReflectionForm)form;
        Integer userId = refForm.getUserID();
        String sessionMapID = WebUtil.readStrParam((HttpServletRequest)request, (String)"sessionMapID");
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        Long sessionId = (Long)sessionMap.get((Object)"toolSessionID");
        ITaskListService service = this.getTaskListService();
        NotebookEntry entry = service.getEntry(sessionId, CoreNotebookConstants.NOTEBOOK_TOOL, "latask10", userId);
        if (entry == null) {
            service.createNotebookEntry(sessionId, CoreNotebookConstants.NOTEBOOK_TOOL, "latask10", userId, refForm.getEntryText());
        } else {
            entry.setEntry(refForm.getEntryText());
            entry.setLastModified(new Date());
            service.updateEntry(entry);
        }
        return this.finish(mapping, form, request, response);
    }

    private ITaskListService getTaskListService() {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
        return (ITaskListService)wac.getBean("lataskTaskListService");
    }

    private TaskListUser getCurrentUser(ITaskListService service, Long sessionId) {
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        TaskListUser taskListUser = service.getUserByIDAndSession(new Long(user.getUserID().intValue()), sessionId);
        if (taskListUser == null) {
            TaskListSession session = service.getTaskListSessionBySessionId(sessionId);
            taskListUser = new TaskListUser(user, session);
            service.createUser(taskListUser);
        }
        return taskListUser;
    }

    private TaskListUser getSpecifiedUser(ITaskListService service, Long sessionId, Integer userId) {
        TaskListUser taskListUser = service.getUserByIDAndSession(new Long(userId.intValue()), sessionId);
        if (taskListUser == null) {
            log.error((Object)("Unable to find specified user for taskList activity. Screens are likely to fail. SessionId=" + sessionId + " UserId=" + userId));
        }
        return taskListUser;
    }

    private ActionErrors validateTaskListItem(TaskListItemForm itemForm) {
        ActionErrors errors = new ActionErrors();
        if (StringUtils.isBlank((String)itemForm.getTitle())) {
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("error.resource.item.title.blank"));
        }
        return errors;
    }

    private boolean validateBeforeFinish(HttpServletRequest request, String sessionMapID) {
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        Long sessionId = (Long)sessionMap.get((Object)"toolSessionID");
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        Long userID = new Long(user.getUserID().longValue());
        ITaskListService service = this.getTaskListService();
        int numberCompletedTasks = service.getNumTasksCompletedByUser(sessionId, userID);
        int minimumNumberTasks = service.getTaskListBySessionId(sessionId).getMinimumNumberTasks();
        Boolean runOffline = (Boolean)sessionMap.get((Object)"runOffline");
        if (minimumNumberTasks - numberCompletedTasks > 0 && !runOffline.booleanValue()) {
            ActionErrors errors = new ActionErrors();
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("lable.learning.minimum.view.number", (Object)minimumNumberTasks, (Object)numberCompletedTasks));
            this.addErrors(request, (ActionMessages)errors);
            return false;
        }
        return true;
    }

    private void doComplete(HttpServletRequest request) {
        String sessionMapID = request.getParameter("sessionMapID");
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(sessionMapID);
        Long taskListItemUid = new Long(request.getParameter("itemUid"));
        ITaskListService service = this.getTaskListService();
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        Long sessionId = (Long)sessionMap.get((Object)"toolSessionID");
        service.setItemComplete(taskListItemUid, new Long(user.getUserID().intValue()), sessionId);
        sessionMapID = "4";
    }
}

