/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.taskList.web.action;

import java.io.IOException;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.CoreNotebookConstants;
import org.lamsfoundation.lams.tool.taskList.dto.GroupSummary;
import org.lamsfoundation.lams.tool.taskList.dto.ReflectDTO;
import org.lamsfoundation.lams.tool.taskList.dto.Summary;
import org.lamsfoundation.lams.tool.taskList.model.TaskList;
import org.lamsfoundation.lams.tool.taskList.model.TaskListSession;
import org.lamsfoundation.lams.tool.taskList.model.TaskListUser;
import org.lamsfoundation.lams.tool.taskList.service.ITaskListService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.util.SessionMap;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class MonitoringAction
extends Action {
    public static Logger log = Logger.getLogger(MonitoringAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String param = mapping.getParameter();
        if (param.equals("summary")) {
            return this.summary(mapping, form, request, response);
        }
        if (param.equals("itemSummary")) {
            return this.itemSummary(mapping, form, request, response);
        }
        if (param.equals("setVerifiedByMonitor")) {
            return this.setVerifiedByMonitor(mapping, form, request, response);
        }
        if (param.equals("listuser")) {
            return this.listuser(mapping, form, request, response);
        }
        if (param.equals("viewReflection")) {
            return this.viewReflection(mapping, form, request, response);
        }
        return mapping.findForward("error");
    }

    private ActionForward summary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        SessionMap sessionMap = new SessionMap();
        request.getSession().setAttribute(sessionMap.getSessionID(), (Object)sessionMap);
        request.setAttribute("sessionMapID", (Object)sessionMap.getSessionID());
        request.setAttribute("initialTabId", (Object)WebUtil.readLongParam((HttpServletRequest)request, (String)"currentTab", (boolean)true));
        Long contentId = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolContentID");
        request.setAttribute("toolContentID", (Object)contentId);
        ITaskListService service = this.getTaskListService();
        TaskList taskList = service.getTaskListByContentId(contentId);
        taskList.toDTO();
        List<Summary> summaryList = service.getSummary(contentId);
        sessionMap.put((Object)"summaryList", summaryList);
        sessionMap.put((Object)"isPageEditable", (Object)taskList.isContentInUse());
        sessionMap.put((Object)"taskList", (Object)taskList);
        sessionMap.put((Object)"toolContentID", (Object)contentId);
        sessionMap.put((Object)"contentFolderID", (Object)WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID"));
        return mapping.findForward("success");
    }

    private ActionForward itemSummary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ITaskListService service = this.getTaskListService();
        Long contentId = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolContentID");
        Long taskListItemId = WebUtil.readLongParam((HttpServletRequest)request, (String)"taskListItemUid");
        request.setAttribute("taskListItem", (Object)service.getTaskListItemByUid(taskListItemId));
        List<GroupSummary> groupSummaryList = service.getItemSummary(contentId, taskListItemId, false);
        request.setAttribute("groupSummaryList", groupSummaryList);
        return mapping.findForward("success");
    }

    private ActionForward setVerifiedByMonitor(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Long uid = WebUtil.readLongParam((HttpServletRequest)request, (String)"userUid");
        ITaskListService service = this.getTaskListService();
        TaskListUser user = service.getUser(uid);
        user.setVerifiedByMonitor(true);
        service.createUser(user);
        Long contentId = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolContentID");
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        ActionRedirect redirect = new ActionRedirect(mapping.findForwardConfig("success"));
        redirect.addParameter("toolContentID", (Object)contentId);
        redirect.addParameter("contentFolderID", (Object)contentFolderID);
        return redirect;
    }

    private ActionForward listuser(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Long sessionId = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolSessionID");
        Long itemUid = WebUtil.readLongParam((HttpServletRequest)request, (String)"itemUid");
        ITaskListService service = this.getTaskListService();
        List<TaskListUser> list = service.getUserListBySessionItem(sessionId, itemUid);
        request.setAttribute("userList", list);
        return mapping.findForward("success");
    }

    private ActionForward viewReflection(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Long uid = WebUtil.readLongParam((HttpServletRequest)request, (String)"userUid");
        ITaskListService service = this.getTaskListService();
        TaskListUser user = service.getUser(uid);
        Long sessionID = user.getSession().getSessionId();
        NotebookEntry notebookEntry = service.getEntry(sessionID, CoreNotebookConstants.NOTEBOOK_TOOL, "latask10", user.getUserId().intValue());
        TaskListSession session = service.getTaskListSessionBySessionId(sessionID);
        ReflectDTO refDTO = new ReflectDTO(user);
        if (notebookEntry == null) {
            refDTO.setFinishReflection(false);
            refDTO.setReflect(null);
        } else {
            refDTO.setFinishReflection(true);
            refDTO.setReflect(notebookEntry.getEntry());
        }
        refDTO.setReflectInstructions(session.getTaskList().getReflectInstructions());
        request.setAttribute("userDTO", (Object)refDTO);
        return mapping.findForward("success");
    }

    private ITaskListService getTaskListService() {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
        return (ITaskListService)wac.getBean("lataskTaskListService");
    }
}

