/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.taskList.web.servlet;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.taskList.dto.GroupSummary;
import org.lamsfoundation.lams.tool.taskList.dto.ItemSummary;
import org.lamsfoundation.lams.tool.taskList.model.TaskList;
import org.lamsfoundation.lams.tool.taskList.model.TaskListItemAttachment;
import org.lamsfoundation.lams.tool.taskList.model.TaskListSession;
import org.lamsfoundation.lams.tool.taskList.model.TaskListUser;
import org.lamsfoundation.lams.tool.taskList.service.ITaskListService;
import org.lamsfoundation.lams.tool.taskList.service.TaskListException;
import org.lamsfoundation.lams.tool.taskList.service.TaskListServiceProxy;
import org.lamsfoundation.lams.tool.taskList.util.TaskListToolContentHandler;
import org.lamsfoundation.lams.util.FileUtil;
import org.lamsfoundation.lams.web.servlet.AbstractExportPortfolioServlet;
import org.lamsfoundation.lams.web.util.SessionMap;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportServlet
extends AbstractExportPortfolioServlet {
    private static final long serialVersionUID = -4529093489007108143L;
    private static Logger logger = Logger.getLogger(ExportServlet.class);
    private final String FILENAME = "taskList_main.html";
    private TaskListToolContentHandler handler;

    public String doExport(HttpServletRequest request, HttpServletResponse response, String directoryName, Cookie[] cookies) {
        SessionMap sessionMap = new SessionMap();
        request.getSession().setAttribute(sessionMap.getSessionID(), (Object)sessionMap);
        try {
            if (StringUtils.equals((String)this.mode, (String)ToolAccessMode.LEARNER.toString())) {
                sessionMap.put((Object)"mode", (Object)ToolAccessMode.LEARNER);
                this.learner(request, response, directoryName, cookies, (HashMap)sessionMap);
            } else if (StringUtils.equals((String)this.mode, (String)ToolAccessMode.TEACHER.toString())) {
                sessionMap.put((Object)"mode", (Object)ToolAccessMode.TEACHER);
                this.teacher(request, response, directoryName, cookies, (HashMap)sessionMap);
            }
        }
        catch (TaskListException e) {
            logger.error((Object)"Cannot perform export for taskList tool.");
        }
        String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
        this.writeResponseToFile(basePath + "/pages/export/exportportfolio.jsp?sessionMapID=" + sessionMap.getSessionID(), directoryName, "taskList_main.html", cookies);
        return "taskList_main.html";
    }

    protected String doOfflineExport(HttpServletRequest request, HttpServletResponse response, String directoryName, Cookie[] cookies) {
        if (this.toolContentID == null && this.toolSessionID == null) {
            logger.error((Object)"Tool content Id or and session Id are null. Unable to activity title");
        } else {
            ITaskListService service = TaskListServiceProxy.getTaskListService(this.getServletContext());
            TaskList content = null;
            if (this.toolContentID != null) {
                content = service.getTaskListByContentId(this.toolContentID);
            } else {
                TaskListSession session = service.getTaskListSessionBySessionId(this.toolSessionID);
                if (session != null) {
                    content = session.getTaskList();
                }
            }
            if (content != null) {
                this.activityTitle = content.getTitle();
            }
        }
        return super.doOfflineExport(request, response, directoryName, cookies);
    }

    private void learner(HttpServletRequest request, HttpServletResponse response, String directoryName, Cookie[] cookies, HashMap sessionMap) throws TaskListException {
        ITaskListService service = TaskListServiceProxy.getTaskListService(this.getServletContext());
        if (this.userID == null || this.toolSessionID == null) {
            String error = "Tool session Id or user Id is null. Unable to continue";
            logger.error((Object)error);
            throw new TaskListException(error);
        }
        TaskListUser learner = service.getUserByIDAndSession(this.userID, this.toolSessionID);
        if (learner == null) {
            String error = "The user with user id " + this.userID + " does not exist.";
            logger.error((Object)error);
            throw new TaskListException(error);
        }
        TaskList content = service.getTaskListBySessionId(this.toolSessionID);
        if (content == null) {
            String error = "The content for this activity has not been defined yet.";
            logger.error((Object)error);
            throw new TaskListException(error);
        }
        List<List<GroupSummary>> itemSummaries = service.exportForLearner(this.toolSessionID, learner);
        this.saveFileToLocal(itemSummaries, directoryName);
        sessionMap.put("title", content.getTitle());
        sessionMap.put("itemSummaryList", itemSummaries);
        sessionMap.put("reflectOn", content.isReflectOnActivity());
    }

    private void teacher(HttpServletRequest request, HttpServletResponse response, String directoryName, Cookie[] cookies, HashMap sessionMap) throws TaskListException {
        ITaskListService service = TaskListServiceProxy.getTaskListService(this.getServletContext());
        if (this.toolContentID == null) {
            String error = "Tool Content Id is missing. Unable to continue";
            logger.error((Object)error);
            throw new TaskListException(error);
        }
        TaskList content = service.getTaskListByContentId(this.toolContentID);
        if (content == null) {
            String error = "Data is missing from the database. Unable to Continue";
            logger.error((Object)error);
            throw new TaskListException(error);
        }
        List<List<GroupSummary>> itemSummaries = service.exportForTeacher(this.toolContentID);
        this.saveFileToLocal(itemSummaries, directoryName);
        sessionMap.put("title", content.getTitle());
        sessionMap.put("itemSummaryList", itemSummaries);
        sessionMap.put("reflectOn", content.isReflectOnActivity());
    }

    private void saveFileToLocal(List<List<GroupSummary>> eachItemOverallSummaries, String directoryName) {
        this.handler = this.getToolContentHandler();
        for (List<GroupSummary> itemOverallSummary : eachItemOverallSummaries) {
            for (GroupSummary groupSummary : itemOverallSummary) {
                for (ItemSummary itemSummary : groupSummary.getItemSummaries()) {
                    for (TaskListItemAttachment attachment : itemSummary.getAttachments()) {
                        try {
                            File local;
                            int idx = 1;
                            String userName = attachment.getCreateBy().getLoginName();
                            while (true) {
                                String localDir;
                                if (!(local = new File(localDir = FileUtil.getFullPath((String)directoryName, (String)(userName + "/" + idx)))).exists()) break;
                                ++idx;
                            }
                            local.mkdirs();
                            attachment.setAttachmentLocalUrl(userName + "/" + idx + "/" + attachment.getFileUuid() + '.' + FileUtil.getFileExtension((String)attachment.getFileName()));
                            this.handler.saveFile(attachment.getFileUuid(), FileUtil.getFullPath((String)directoryName, (String)attachment.getAttachmentLocalUrl()));
                        }
                        catch (Exception e) {
                            logger.error((Object)("Export forum topic attachment failed: " + e.toString()));
                        }
                    }
                }
            }
        }
    }

    private TaskListToolContentHandler getToolContentHandler() {
        if (this.handler == null) {
            WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
            this.handler = (TaskListToolContentHandler)((Object)wac.getBean("lataskTaskListToolContentHandler"));
        }
        return this.handler;
    }
}

