/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.tests;

import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.cache.CacheException;
import org.jboss.cache.TreeCacheMBean;

public class Client {
    public static void main(String[] args) {
        try {
            new Client().start(args);
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        catch (CacheException e) {
            e.printStackTrace();
        }
    }

    private void start(String[] args) throws NamingException, CacheException {
        String jndi_name = args.length > 0 ? args[0] : "MyCache";
        Properties props = new Properties();
        props.setProperty("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
        props.setProperty("java.naming.provider.url", "jnp://localhost:1099");
        props.setProperty("java.naming.factory.url.pkgs", "org.jboss.naming");
        InitialContext ctx = new InitialContext(props);
        TreeCacheMBean cache = (TreeCacheMBean)ctx.lookup(jndi_name);
        cache.put("a/b/c", null);
        System.out.println("Cache: " + cache.printDetails());
        System.out.println("cache mode: " + cache.getCacheMode());
        int numLocks = cache.getNumberOfLocksHeld();
        int numNodes = cache.getNumberOfNodes();
        int numAttrs = cache.getNumberOfAttributes();
        System.out.println("Nodes: " + numNodes + ", locks: " + numLocks + ", attributes: " + numAttrs);
    }
}

