/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.builder;

import junit.framework.AssertionFailedError;
import org.jmock.builder.ArgumentsMatchBuilder;
import org.jmock.builder.BuilderIdentityTable;
import org.jmock.builder.IdentityBuilder;
import org.jmock.builder.MatchBuilder;
import org.jmock.builder.NameMatchBuilder;
import org.jmock.core.Constraint;
import org.jmock.core.InvocationMatcher;
import org.jmock.core.Stub;
import org.jmock.core.StubMatchersCollection;
import org.jmock.core.matcher.AnyArgumentsMatcher;
import org.jmock.core.matcher.ArgumentsMatcher;
import org.jmock.core.matcher.InvokedAfterMatcher;
import org.jmock.core.matcher.InvokedRecorder;
import org.jmock.core.matcher.MethodNameMatcher;
import org.jmock.core.matcher.NoArgumentsMatcher;
import org.jmock.core.stub.VoidStub;

public class InvocationMockerBuilder
implements NameMatchBuilder {
    private StubMatchersCollection mocker;
    private BuilderIdentityTable idTable;

    public ArgumentsMatchBuilder method(Constraint nameConstraint) {
        return this.addMatcher(new MethodNameMatcher(nameConstraint));
    }

    public ArgumentsMatchBuilder method(String name) {
        this.addMatcher(new MethodNameMatcher(name));
        this.idTable.registerMethodName(name, this);
        return this;
    }

    public MatchBuilder match(InvocationMatcher customMatcher) {
        return this.addMatcher(customMatcher);
    }

    public MatchBuilder with(Constraint arg1) {
        return this.with(new Constraint[]{arg1});
    }

    public MatchBuilder with(Constraint arg1, Constraint arg2) {
        return this.with(new Constraint[]{arg1, arg2});
    }

    public MatchBuilder with(Constraint arg1, Constraint arg2, Constraint arg3) {
        return this.with(new Constraint[]{arg1, arg2, arg3});
    }

    public MatchBuilder with(Constraint arg1, Constraint arg2, Constraint arg3, Constraint arg4) {
        return this.with(new Constraint[]{arg1, arg2, arg3, arg4});
    }

    public MatchBuilder with(Constraint[] constraints) {
        return this.addMatcher(new ArgumentsMatcher(constraints));
    }

    public MatchBuilder withNoArguments() {
        return this.addMatcher(NoArgumentsMatcher.INSTANCE);
    }

    public MatchBuilder withAnyArguments() {
        return this.addMatcher(AnyArgumentsMatcher.INSTANCE);
    }

    public IdentityBuilder will(Stub stubAction) {
        this.setStub(stubAction);
        return this;
    }

    public IdentityBuilder isVoid() {
        this.setStub(VoidStub.INSTANCE);
        return this;
    }

    private final void setStub(Stub stubAction) {
        this.mocker.setStub(stubAction);
    }

    public IdentityBuilder expect(InvocationMatcher expectation) {
        return this.addMatcher(expectation);
    }

    public void id(String invocationID) {
        this.mocker.setName(invocationID);
        this.idTable.registerUniqueID(invocationID, this);
    }

    public MatchBuilder after(String priorCallID) {
        this.setupOrderingMatchers(this.idTable, priorCallID, priorCallID);
        return this;
    }

    public MatchBuilder after(BuilderIdentityTable otherMock, String priorCallID) {
        this.setupOrderingMatchers(otherMock, priorCallID, priorCallID + " on " + otherMock);
        return this;
    }

    private final void setupOrderingMatchers(BuilderIdentityTable idTable, String priorCallID, String priorCallDescription) {
        MatchBuilder priorCallBuilder = idTable.lookupID(priorCallID);
        if (priorCallBuilder == this) {
            throw new AssertionFailedError("confusing identifier of prior invocation \"" + priorCallID + "\"; give it an explicit call identifier");
        }
        InvokedRecorder priorCallRecorder = new InvokedRecorder();
        priorCallBuilder.match(priorCallRecorder);
        this.mocker.addMatcher(new InvokedAfterMatcher(priorCallRecorder, priorCallDescription));
    }

    private final InvocationMockerBuilder addMatcher(InvocationMatcher matcher) {
        this.mocker.addMatcher(matcher);
        return this;
    }

    public InvocationMockerBuilder(StubMatchersCollection mocker, BuilderIdentityTable idTable) {
        this.mocker = mocker;
        this.idTable = idTable;
    }
}

