/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.builder;

import java.util.Iterator;
import java.util.List;
import org.jmock.core.InvocationMatcher;
import org.jmock.core.InvocationMocker;
import org.jmock.core.Stub;
import org.jmock.core.matcher.MethodNameMatcher;

public class InvocationMockerDescriber
implements InvocationMocker.Describer {
    private static final String SEP = ", ";

    public boolean hasDescription() {
        return true;
    }

    public void describeTo(StringBuffer buffer, List matchers, Stub stub, String name) {
        Iterator i = matchers.iterator();
        boolean needSeparator = false;
        boolean lastWasMethodName = false;
        while (i.hasNext()) {
            InvocationMatcher matcher = (InvocationMatcher)i.next();
            if (!matcher.hasDescription()) continue;
            if (matcher instanceof MethodNameMatcher) {
                if (!needSeparator) {
                    buffer.append("stub");
                }
                buffer.append(": ");
                lastWasMethodName = true;
            } else {
                if (needSeparator && !lastWasMethodName) {
                    buffer.append(SEP);
                }
                lastWasMethodName = false;
            }
            matcher.describeTo(buffer);
            needSeparator = true;
        }
        if (needSeparator) {
            buffer.append(SEP);
        }
        stub.describeTo(buffer);
        if (name != null) {
            buffer.append(" [").append(name).append("]");
        }
    }
}

