/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.builder;

import java.util.HashMap;
import junit.framework.AssertionFailedError;
import org.jmock.Verifiable;
import org.jmock.builder.BuilderIdentityTable;
import org.jmock.builder.ExpectationBuilder;
import org.jmock.builder.InvocationMockerBuilder;
import org.jmock.builder.MatchBuilder;
import org.jmock.dynamic.CoreMock;
import org.jmock.dynamic.DynamicMock;
import org.jmock.dynamic.InvocationMocker;
import org.jmock.dynamic.LIFOInvocationDispatcher;
import org.jmock.dynamic.Stub;
import org.jmock.dynamic.StubMatchersCollection;
import org.jmock.dynamic.matcher.MethodNameMatcher;

public class Mock
implements BuilderIdentityTable,
Verifiable {
    DynamicMock coreMock;
    HashMap idTable = new HashMap();

    public Mock(Class mockedType) {
        this(mockedType, CoreMock.mockNameFromClass(mockedType));
    }

    public Mock(Class mockedType, String name) {
        this(new CoreMock(mockedType, name, new LIFOInvocationDispatcher()));
    }

    public Mock(DynamicMock coreMock) {
        this.coreMock = coreMock;
    }

    public Class getMockedType() {
        return this.coreMock.getMockedType();
    }

    public Object proxy() {
        return this.coreMock.proxy();
    }

    public String toString() {
        return this.coreMock.toString();
    }

    public void verify() {
        this.coreMock.verify();
    }

    public MatchBuilder method(String methodName) {
        InvocationMocker mocker = new InvocationMocker();
        mocker.addMatcher(new MethodNameMatcher(methodName));
        this.coreMock.add(mocker);
        InvocationMockerBuilder builder = new InvocationMockerBuilder((StubMatchersCollection)mocker, (BuilderIdentityTable)this);
        this.idTable.put(methodName, builder);
        return builder;
    }

    public void setDefaultStub(Stub newDefaultStub) {
        this.coreMock.setDefaultStub(newDefaultStub);
    }

    public ExpectationBuilder lookupID(String id) {
        if (!this.idTable.containsKey(id)) {
            throw new AssertionFailedError("no expected invocation named '" + id + "'");
        }
        return (ExpectationBuilder)this.idTable.get(id);
    }

    public void registerID(String id, ExpectationBuilder builder) {
        if (this.idTable.containsKey(id)) {
            throw new AssertionFailedError("duplicate invocation named '" + id + "'");
        }
        this.idTable.put(id, builder);
    }
}

