/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.core;

import junit.framework.AssertionFailedError;
import org.jmock.core.AbstractDynamicMock;
import org.jmock.core.Constraint;
import org.jmock.core.DynamicMock;
import org.jmock.core.DynamicMockError;
import org.jmock.core.DynamicUtil;
import org.jmock.core.Invocation;
import org.jmock.core.InvocationDispatcher;
import org.jmock.core.InvocationMatcher;
import org.jmock.core.InvocationMocker;
import org.jmock.core.Invokable;
import org.jmock.core.LIFOInvocationDispatcher;
import org.jmock.core.Stub;
import org.jmock.core.constraint.IsAnything;
import org.jmock.core.matcher.ArgumentsMatcher;
import org.jmock.core.matcher.MethodNameMatcher;
import org.jmock.core.matcher.NoArgumentsMatcher;
import org.jmock.core.stub.CustomStub;
import org.jmock.core.stub.ReturnStub;

public abstract class AbstractDynamicMock
implements DynamicMock {
    private static final InvocationMocker.Describer NO_DESCRIPTION = new 1();
    private InvocationDispatcher invocationDispatcher;
    private Class mockedType;
    private String name;

    public Class getMockedType() {
        return this.mockedType;
    }

    protected Object mockInvocation(Invocation invocation) throws Throwable {
        try {
            return this.invocationDispatcher.dispatch(invocation);
        }
        catch (AssertionFailedError failure) {
            DynamicMockError mockFailure = new DynamicMockError(this, invocation, this.invocationDispatcher, failure.getMessage());
            mockFailure.fillInStackTrace();
            throw mockFailure;
        }
    }

    public void verify() {
        try {
            this.invocationDispatcher.verify();
        }
        catch (AssertionFailedError ex) {
            throw new AssertionFailedError(this.name + ": " + ex.getMessage());
        }
    }

    public String toString() {
        return this.name;
    }

    public String getMockName() {
        return this.name;
    }

    public void setDefaultStub(Stub newDefaultStub) {
        this.invocationDispatcher.setDefaultStub(newDefaultStub);
    }

    public void addInvokable(Invokable invokable) {
        this.invocationDispatcher.add(invokable);
    }

    public void reset() {
        this.invocationDispatcher.clear();
        this.setupDefaultBehaviour();
    }

    public static String mockNameFromClass(Class c) {
        return "mock" + DynamicUtil.classShortName(c);
    }

    private final void setupDefaultBehaviour() {
        this.addInvokable(this.hiddenInvocationMocker("toString", NoArgumentsMatcher.INSTANCE, new ReturnStub(this.name)));
        this.addInvokable(this.hiddenInvocationMocker("equals", new ArgumentsMatcher(new Constraint[]{new IsAnything()}), new IsSameAsProxyStub()));
        this.addInvokable(this.hiddenInvocationMocker("hashCode", NoArgumentsMatcher.INSTANCE, new HashCodeStub()));
    }

    private final InvocationMocker hiddenInvocationMocker(String methodName, InvocationMatcher arguments, Stub stub) {
        InvocationMocker invocationMocker = new InvocationMocker(NO_DESCRIPTION);
        invocationMocker.addMatcher(new MethodNameMatcher(methodName));
        invocationMocker.addMatcher(arguments);
        invocationMocker.setStub(stub);
        return invocationMocker;
    }

    public AbstractDynamicMock(Class mockedType, String name) {
        this(mockedType, name, new LIFOInvocationDispatcher());
    }

    public AbstractDynamicMock(Class mockedType, String name, InvocationDispatcher invocationDispatcher) {
        this.mockedType = mockedType;
        this.name = name;
        this.invocationDispatcher = invocationDispatcher;
        this.setupDefaultBehaviour();
    }

    private class IsSameAsProxyStub
    extends CustomStub {
        public Object invoke(Invocation invocation) throws Throwable {
            boolean bl = false;
            if (invocation.getParameterValues().get(0) == AbstractDynamicMock.this.proxy()) {
                bl = true;
            }
            return new Boolean(bl);
        }

        private IsSameAsProxyStub() {
            super("returns whether equal to proxy");
        }
    }

    private class HashCodeStub
    extends CustomStub {
        public Object invoke(Invocation invocation) throws Throwable {
            return new Integer(AbstractDynamicMock.this.hashCode());
        }

        private HashCodeStub() {
            super("returns hashCode for proxy");
        }
    }
}

