/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.core;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.jmock.core.DynamicMock;

public class DynamicUtil {
    public static String toReadableString(Object element) {
        if (element == null) {
            return "null";
        }
        if (Proxy.isProxyClass(element.getClass())) {
            return DynamicUtil.unpackProxy(element).toString();
        }
        if (element.getClass().isArray()) {
            return DynamicUtil.join(element, new StringBuffer()).toString();
        }
        return element.toString();
    }

    private static final Object unpackProxy(Object element) {
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(element);
        return invocationHandler instanceof DynamicMock ? invocationHandler : element;
    }

    public static StringBuffer join(Object array, StringBuffer buf) {
        return DynamicUtil.join(array, buf, "[", "]");
    }

    public static StringBuffer join(Object array, StringBuffer buf, String prefix, String postfix) {
        buf.append(prefix);
        int i = 0;
        while (i < Array.getLength(array)) {
            Object element;
            if (i > 0) {
                buf.append(", ");
            }
            if ((element = Array.get(array, i)) == null) {
                buf.append("<null>");
            } else if (element.getClass().isArray()) {
                DynamicUtil.join(element, buf);
            } else {
                buf.append("<");
                buf.append(DynamicUtil.toReadableString(element));
                buf.append(">");
            }
            ++i;
        }
        buf.append(postfix);
        return buf;
    }

    public static String classShortName(Class c) {
        return c.getName().substring(c.getName().lastIndexOf(".") + 1);
    }
}

