/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.core;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jmock.core.DynamicUtil;

public class Invocation {
    private Object invoked;
    private Class declaringClass;
    private String methodName;
    private Class[] parameterTypes;
    private Class returnType;
    private Object[] parameterValues;

    public Object getInvokedObject() {
        return this.invoked;
    }

    public Class getDeclaringClass() {
        return this.declaringClass;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public List getParameterTypes() {
        return Collections.unmodifiableList(Arrays.asList(this.parameterTypes));
    }

    public List getParameterValues() {
        return Collections.unmodifiableList(Arrays.asList(this.parameterValues));
    }

    public Class getReturnType() {
        return this.returnType;
    }

    public String toString() {
        return this.writeTo(new StringBuffer()).toString();
    }

    public boolean equals(Object other) {
        boolean bl = false;
        if (other instanceof Invocation && this.equals((Invocation)other)) {
            bl = true;
        }
        return bl;
    }

    public boolean equals(Invocation other) {
        boolean bl = false;
        if (other != null && this.invoked == other.invoked && this.methodName.equals(other.methodName) && Arrays.equals(this.parameterTypes, other.parameterTypes) && this.returnType.equals(other.returnType) && Arrays.equals(this.parameterValues, other.parameterValues)) {
            bl = true;
        }
        return bl;
    }

    public int hashCode() {
        return this.methodName.hashCode() ^ this.arrayHashCode(this.parameterTypes) ^ this.returnType.hashCode() ^ this.arrayHashCode(this.parameterValues);
    }

    private final int arrayHashCode(Object[] array) {
        int hashCode = 0;
        int i = 0;
        while (i < array.length) {
            hashCode ^= array[i].hashCode();
            ++i;
        }
        return hashCode;
    }

    public StringBuffer writeTo(StringBuffer buffer) {
        buffer.append(this.methodName);
        DynamicUtil.join(this.parameterValues, buffer, "(", ")");
        return buffer.append("\n");
    }

    public Invocation(Object invoked, Class declaringClass, String name, Class[] parameterTypes, Class returnType, Object[] parameterValues) {
        this.invoked = invoked;
        this.declaringClass = declaringClass;
        this.methodName = name;
        this.parameterTypes = parameterTypes;
        this.returnType = returnType;
        this.parameterValues = parameterValues == null ? new Object[]{} : parameterValues;
    }

    public Invocation(Object invoked, Method method, Object[] parameterValues) {
        this(invoked, method.getDeclaringClass(), method.getName(), method.getParameterTypes(), method.getReturnType(), parameterValues);
    }
}

