/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.core;

import org.jmock.core.Constraint;
import org.jmock.core.VerifyingTestCase;
import org.jmock.core.constraint.And;
import org.jmock.core.constraint.IsAnything;
import org.jmock.core.constraint.IsCloseTo;
import org.jmock.core.constraint.IsEqual;
import org.jmock.core.constraint.IsInstanceOf;
import org.jmock.core.constraint.IsNot;
import org.jmock.core.constraint.IsNull;
import org.jmock.core.constraint.IsSame;
import org.jmock.core.constraint.Or;
import org.jmock.core.constraint.StringContains;
import org.jmock.util.Dummy;

public class MockObjectSupportTestCase
extends VerifyingTestCase {
    public static final Constraint ANYTHING = new IsAnything();
    public static final Constraint NULL = new IsNull();

    public IsEqual eq(Object operand) {
        return new IsEqual(operand);
    }

    public IsEqual eq(boolean operand) {
        return this.eq(new Boolean(operand));
    }

    public IsEqual eq(byte operand) {
        return this.eq(new Byte(operand));
    }

    public IsEqual eq(short operand) {
        return this.eq(new Short(operand));
    }

    public IsEqual eq(char operand) {
        return this.eq(new Character(operand));
    }

    public IsEqual eq(int operand) {
        return this.eq(new Integer(operand));
    }

    public IsEqual eq(long operand) {
        return this.eq(new Long(operand));
    }

    public IsEqual eq(float operand) {
        return this.eq(new Float(operand));
    }

    public IsEqual eq(double operand) {
        return this.eq(new Double(operand));
    }

    public IsCloseTo eq(double operand, double error) {
        return new IsCloseTo(operand, error);
    }

    public IsSame same(Object operand) {
        return new IsSame(operand);
    }

    public IsInstanceOf isA(Class operandClass) {
        return new IsInstanceOf(operandClass);
    }

    public StringContains stringContains(String substring) {
        return new StringContains(substring);
    }

    public IsNot not(Constraint c) {
        return new IsNot(c);
    }

    public And and(Constraint left, Constraint right) {
        return new And(left, right);
    }

    public Or or(Constraint left, Constraint right) {
        return new Or(left, right);
    }

    public Object newDummy(Class dummyType) {
        return Dummy.newDummy(dummyType);
    }

    public Object newDummy(Class dummyType, String name) {
        return Dummy.newDummy(dummyType, name);
    }

    public Object newDummy(String name) {
        return Dummy.newDummy(name);
    }
}

