/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.core.stub;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import junit.framework.AssertionFailedError;
import org.jmock.core.CoreMock;
import org.jmock.core.DynamicUtil;
import org.jmock.core.Invocation;
import org.jmock.core.Stub;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DefaultResultStub
implements Stub {
    private Map resultValuesByType;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;

    public StringBuffer describeTo(StringBuffer buf) {
        return buf.append("returns a default value");
    }

    public void addResult(Class resultType, Object resultValue) {
        this.resultValuesByType.put(resultType, resultValue);
    }

    public Object invoke(Invocation invocation) throws Throwable {
        Class returnType = invocation.getReturnType();
        if (this.resultValuesByType.containsKey(returnType)) {
            return this.resultValuesByType.get(returnType);
        }
        if (returnType.isArray()) {
            return Array.newInstance(returnType.getComponentType(), 0);
        }
        if (returnType.isInterface()) {
            CoreMock nullMock = new CoreMock(returnType, "null" + DynamicUtil.classShortName(returnType));
            nullMock.setDefaultStub(this);
            return nullMock.proxy();
        }
        throw new AssertionFailedError(this.createErrorMessage(invocation));
    }

    public String createErrorMessage(Invocation call) {
        StringBuffer buf = new StringBuffer();
        buf.append("unexpected result type: ");
        buf.append(call.getReturnType().toString());
        buf.append("\n");
        if (this.resultValuesByType.isEmpty()) {
            buf.append("no result types are registered!");
        } else {
            buf.append("expected one of: ");
            Iterator i = this.resultValuesByType.keySet().iterator();
            boolean separatorRequired = false;
            while (i.hasNext()) {
                if (separatorRequired) {
                    buf.append(", ");
                }
                buf.append(((Class)i.next()).getName());
                separatorRequired = true;
            }
        }
        return buf.toString();
    }

    protected void createDefaultResults() {
        this.addResult(Boolean.TYPE, Boolean.FALSE);
        this.addResult(Void.TYPE, null);
        this.addResult(Byte.TYPE, new Byte(0));
        this.addResult(Short.TYPE, new Short(0));
        this.addResult(Integer.TYPE, new Integer(0));
        this.addResult(Long.TYPE, new Long(0L));
        this.addResult(Character.TYPE, new Character('\u0000'));
        this.addResult(Float.TYPE, new Float(0.0f));
        this.addResult(Double.TYPE, new Double(0.0));
        Class clazz = class$java$lang$Boolean;
        if (clazz == null) {
            clazz = class$java$lang$Boolean = DefaultResultStub.class$("[Ljava.lang.Boolean;", false);
        }
        this.addResult(clazz, Boolean.FALSE);
        Class clazz2 = class$java$lang$Byte;
        if (clazz2 == null) {
            clazz2 = class$java$lang$Byte = DefaultResultStub.class$("[Ljava.lang.Byte;", false);
        }
        this.addResult(clazz2, new Byte(0));
        Class clazz3 = class$java$lang$Short;
        if (clazz3 == null) {
            clazz3 = class$java$lang$Short = DefaultResultStub.class$("[Ljava.lang.Short;", false);
        }
        this.addResult(clazz3, new Short(0));
        Class clazz4 = class$java$lang$Integer;
        if (clazz4 == null) {
            clazz4 = class$java$lang$Integer = DefaultResultStub.class$("[Ljava.lang.Integer;", false);
        }
        this.addResult(clazz4, new Integer(0));
        Class clazz5 = class$java$lang$Long;
        if (clazz5 == null) {
            clazz5 = class$java$lang$Long = DefaultResultStub.class$("[Ljava.lang.Long;", false);
        }
        this.addResult(clazz5, new Long(0L));
        Class clazz6 = class$java$lang$Character;
        if (clazz6 == null) {
            clazz6 = class$java$lang$Character = DefaultResultStub.class$("[Ljava.lang.Character;", false);
        }
        this.addResult(clazz6, new Character('\u0000'));
        Class clazz7 = class$java$lang$Float;
        if (clazz7 == null) {
            clazz7 = class$java$lang$Float = DefaultResultStub.class$("[Ljava.lang.Float;", false);
        }
        this.addResult(clazz7, new Float(0.0f));
        Class clazz8 = class$java$lang$Double;
        if (clazz8 == null) {
            clazz8 = class$java$lang$Double = DefaultResultStub.class$("[Ljava.lang.Double;", false);
        }
        this.addResult(clazz8, new Double(0.0));
        Class clazz9 = class$java$lang$String;
        if (clazz9 == null) {
            clazz9 = class$java$lang$String = DefaultResultStub.class$("[Ljava.lang.String;", false);
        }
        this.addResult(clazz9, "<default string result>");
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.resultValuesByType = new HashMap();
    }

    public DefaultResultStub() {
        this.this();
        this.createDefaultResults();
    }
}

