/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.examples.calculator;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Stack;
import org.jmock.examples.calculator.ParseException;
import org.jmock.examples.calculator.Token;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Lexer {
    private static final int END_OF_STREAM = -1;
    private static final char DECIMAL_PLACE = '.';
    private PushbackReader input;
    private StringBuffer tokenValue;
    private Stack pushBack;

    public void pushBack(Token token) {
        this.pushBack.push(token);
    }

    public Token nextToken() throws IOException, ParseException {
        if (this.pushBack.isEmpty()) {
            return this.readToken();
        }
        return (Token)this.pushBack.pop();
    }

    private final Token readToken() throws IOException, ParseException {
        this.tokenValue.setLength(0);
        this.skipWhitespace();
        int ch = this.peekChar();
        if (ch == -1) {
            return new Token(0, null);
        }
        if (this.isDigit(ch)) {
            return this.readNumber();
        }
        if (this.isIdentifierStart(ch)) {
            return this.readIdentifier();
        }
        return this.readOperator();
    }

    public void skipWhitespace() throws IOException {
        int ch;
        while ((ch = this.readChar()) != -1 && Character.isWhitespace((char)ch)) {
        }
        this.unreadChar(ch);
    }

    private final boolean isDigit(int ch) {
        boolean bl = false;
        if (ch != -1 && Character.isDigit((char)ch)) {
            bl = true;
        }
        return bl;
    }

    private final Token readNumber() throws IOException {
        this.collectDigits();
        if (this.peekChar() == 46) {
            this.tokenValue.append((char)this.readChar());
            this.collectDigits();
        }
        return this.createToken(1);
    }

    private final void collectDigits() throws IOException {
        int ch;
        while (this.isDigit(ch = this.readChar())) {
            this.tokenValue.append((char)ch);
        }
        this.unreadChar(ch);
    }

    private final boolean isIdentifierStart(int ch) {
        return Character.isUnicodeIdentifierStart((char)ch);
    }

    private final boolean isIdentifierPart(int ch) {
        boolean bl = false;
        if (ch != -1 && Character.isUnicodeIdentifierPart((char)ch)) {
            bl = true;
        }
        return bl;
    }

    private final Token readIdentifier() throws IOException {
        int ch;
        this.tokenValue.append((char)this.readChar());
        while (this.isIdentifierPart(ch = this.readChar())) {
            this.tokenValue.append((char)ch);
        }
        this.unreadChar(ch);
        return this.createToken(2);
    }

    private final Token readOperator() throws IOException, ParseException {
        int ch = this.readChar();
        this.tokenValue.append((char)ch);
        switch (ch) {
            case 43: {
                return this.createToken(3);
            }
            case 45: {
                return this.createToken(4);
            }
            case 42: {
                return this.createToken(5);
            }
            case 47: {
                return this.createToken(6);
            }
            case 94: {
                return this.createToken(7);
            }
            case 40: {
                return this.createToken(8);
            }
            case 41: {
                return this.createToken(9);
            }
        }
        throw new ParseException("unrecognised character '" + (char)ch + '\'');
    }

    private final Token createToken(int tokenType) {
        return new Token(tokenType, this.tokenValue.toString());
    }

    private final int peekChar() throws IOException {
        int ch = this.readChar();
        this.unreadChar(ch);
        return ch;
    }

    private final int readChar() throws IOException {
        return this.input.read();
    }

    private final void unreadChar(int ch) throws IOException {
        if (ch != -1) {
            this.input.unread(ch);
        }
    }

    private final /* synthetic */ void this() {
        this.tokenValue = new StringBuffer();
        this.pushBack = new Stack();
    }

    public Lexer(Reader input) {
        this.this();
        this.input = new PushbackReader(input);
    }

    public Lexer(String inputString) {
        this(new StringReader(inputString));
    }
}

