/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.examples.timedcache;

import java.util.HashMap;
import org.jmock.examples.timedcache.Clock;
import org.jmock.examples.timedcache.ObjectLoader;
import org.jmock.examples.timedcache.ReloadPolicy;
import org.jmock.examples.timedcache.Timestamp;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TimedCache {
    private ObjectLoader loader;
    private Clock clock;
    private ReloadPolicy reloadPolicy;
    private HashMap cachedValues;

    public Object lookup(Object theKey) {
        TimestampedValue found = (TimestampedValue)this.cachedValues.get(theKey);
        if (found == null || this.reloadPolicy.shouldReload(found.loadTime, this.clock.getCurrentTime())) {
            found = this.loadObject(theKey);
        }
        return found.value;
    }

    private final TimestampedValue loadObject(Object key) {
        Object value = this.loader.load(key);
        TimestampedValue timestampedValue = new TimestampedValue(value, this.clock.getCurrentTime());
        this.cachedValues.put(key, timestampedValue);
        return timestampedValue;
    }

    public void putValue(Object key, Object value, Timestamp loadTime) {
        this.cachedValues.put(key, new TimestampedValue(value, loadTime));
    }

    private final /* synthetic */ void this() {
        this.cachedValues = new HashMap();
    }

    public TimedCache(ObjectLoader loader, Clock clock, ReloadPolicy reloadPolicy) {
        this.this();
        this.loader = loader;
        this.clock = clock;
        this.reloadPolicy = reloadPolicy;
    }

    private class TimestampedValue {
        public final Object value;
        public final Timestamp loadTime;

        public TimestampedValue(Object value, Timestamp timestamp) {
            this.value = value;
            this.loadTime = timestamp;
        }
    }
}

