/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.expectation;

import org.jmock.expectation.AbstractExpectation;
import org.jmock.expectation.AssertMo;

public class ExpectationSegment
extends AbstractExpectation {
    private String myExpectedSegment;
    private String myActualString;

    public void clearActual() {
        this.myActualString = null;
    }

    public void setActual(String aString) {
        this.myActualString = aString;
        if (this.shouldCheckImmediately()) {
            this.verify();
        }
    }

    public void setExpected(String segment) {
        this.myExpectedSegment = segment;
        this.setHasExpectations();
    }

    public void setExpectNothing() {
        this.myActualString = null;
        this.setExpected(null);
    }

    public void verify() {
        if (this.hasExpectations()) {
            if (this.myExpectedSegment == null) {
                AssertMo.assertNull((String)"Expecting nothing", (Object)this.myActualString);
            } else {
                AssertMo.assertIncludes("Should include string segment", this.myExpectedSegment, this.myActualString);
            }
        }
    }

    public ExpectationSegment(String name) {
        super(name);
        this.clearActual();
    }
}

