/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.expectation;

import java.util.Enumeration;
import java.util.Hashtable;
import org.jmock.core.Verifiable;
import org.jmock.expectation.AssertMo;
import org.jmock.expectation.MockObject;
import org.jmock.expectation.Null;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ReturnObjectMap
extends MockObject {
    private final Hashtable returnValues;
    private final String name;

    public Object getValue(Object key) {
        if (key == null) {
            key = Null.NULL;
        }
        AssertMo.assertTrue((String)(this.name + " does not contain " + key.toString()), (boolean)this.returnValues.containsKey(key));
        return ((CallCounter)this.returnValues.get(key)).getValue();
    }

    public Object getValue(short key) {
        return this.getValue(new Short(key));
    }

    public void putReturnValue(Object key, Object value) {
        this.returnValues.put(key != null ? key : Null.NULL, new CallCounter(key, value));
    }

    public void putReturnValue(Object key, int value) {
        this.putReturnValue(key, (Object)new Integer(value));
    }

    public void putReturnValue(short key, Object value) {
        this.putReturnValue((Object)new Short(key), value);
    }

    public void putReturnValue(Object key, boolean value) {
        this.putReturnValue(key, (Object)new Boolean(value));
    }

    public int getIntValue(Object key) {
        return (Integer)this.getValue(key);
    }

    public boolean getBooleanValue(String key) {
        return (Boolean)this.getValue(key);
    }

    public void verify() {
        super.verify();
        Enumeration enumeration = this.returnValues.elements();
        while (enumeration.hasMoreElements()) {
            ((Verifiable)enumeration.nextElement()).verify();
        }
    }

    private final /* synthetic */ void this() {
        this.returnValues = new Hashtable();
    }

    public ReturnObjectMap(String name) {
        this.this();
        this.name = name;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class CallCounter
    implements Verifiable {
        private int count;
        private final Object value;
        private final Object key;

        public Object getValue() {
            ++this.count;
            return this.value;
        }

        public void verify() {
            String string = "Object never called for key: " + this.key;
            boolean bl = false;
            if (this.count > 0) {
                bl = true;
            }
            AssertMo.assertTrue((String)string, (boolean)bl);
        }

        private final /* synthetic */ void this() {
            this.count = 0;
        }

        public CallCounter(Object key, Object value) {
            this.this();
            this.key = key;
            this.value = value;
        }
    }
}

