/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.util;

import java.lang.reflect.Field;
import java.util.Vector;
import junit.framework.Assert;
import org.jmock.core.Verifiable;

public class Verifier {
    private static Vector myProcessingObjects = new Vector();
    static /* synthetic */ Class class$java$lang$Object;

    public static synchronized void verifyObject(Object anObject) {
        Verifier.verifyFieldsForClass(anObject, anObject.getClass(), myProcessingObjects);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void verifyFieldsForClass(Object anObject, Class aClass, Vector alreadyProcessed) {
        if (alreadyProcessed.contains(anObject)) return;
        if (Verifier.isBaseObjectClass(aClass)) {
            return;
        }
        Verifier.verifyFieldsForClass(anObject, aClass.getSuperclass(), alreadyProcessed);
        try {
            alreadyProcessed.addElement(anObject);
            Field[] fields = aClass.getDeclaredFields();
            int i = 0;
            while (i < fields.length) {
                Verifier.verifyField(fields[i], anObject, alreadyProcessed);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            alreadyProcessed.removeElement(anObject);
            throw throwable;
        }
        {
            Object var4_7 = null;
            alreadyProcessed.removeElement(anObject);
        }
    }

    private static final void verifyField(Field aField, Object anObject, Vector alreadyProcessed) {
        try {
            aField.setAccessible(true);
            Object fieldObject = aField.get(anObject);
            if (Verifier.isVerifiable(fieldObject) && !alreadyProcessed.contains(fieldObject)) {
                ((Verifiable)fieldObject).verify();
            }
        }
        catch (IllegalAccessException e) {
            Assert.fail((String)("Could not access field " + aField.getName()));
        }
    }

    private static final boolean isVerifiable(Object anObject) {
        return anObject instanceof Verifiable;
    }

    private static final boolean isBaseObjectClass(Class aClass) {
        Class clazz = class$java$lang$Object;
        if (clazz == null) {
            clazz = class$java$lang$Object = Verifier.class$("[Ljava.lang.Object;", false);
        }
        return aClass.equals(clazz);
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

