/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.chrono.AssembledChronology;
import org.joda.time.chrono.GJDayOfMonthDateTimeField;
import org.joda.time.chrono.GJDayOfWeekDateTimeField;
import org.joda.time.chrono.GJDayOfYearDateTimeField;
import org.joda.time.chrono.GJEraDateTimeField;
import org.joda.time.chrono.GJLocaleSymbols;
import org.joda.time.chrono.GJMonthOfYearDateTimeField;
import org.joda.time.chrono.GJWeekOfWeekyearDateTimeField;
import org.joda.time.chrono.GJWeekyearDateTimeField;
import org.joda.time.chrono.GJYearDateTimeField;
import org.joda.time.chrono.GJYearOfEraDateTimeField;
import org.joda.time.field.DecoratedDateTimeField;
import org.joda.time.field.DividedDateTimeField;
import org.joda.time.field.FieldUtils;
import org.joda.time.field.MillisDurationField;
import org.joda.time.field.NonZeroDateTimeField;
import org.joda.time.field.OffsetDateTimeField;
import org.joda.time.field.PreciseDateTimeField;
import org.joda.time.field.PreciseDurationField;
import org.joda.time.field.RemainderDateTimeField;

public abstract class BaseGJChronology
extends AssembledChronology {
    private static final long serialVersionUID = 8283225332206808863L;
    static final long MILLIS_1970_TO_2000 = 946684800000L;
    private static final int[] MIN_DAYS_PER_MONTH_ARRAY = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] MAX_DAYS_PER_MONTH_ARRAY = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final long[] MIN_TOTAL_MILLIS_BY_MONTH_ARRAY = new long[12];
    private static final long[] MAX_TOTAL_MILLIS_BY_MONTH_ARRAY = new long[12];
    private static final DurationField cMillisField;
    private static final DurationField cSecondsField;
    private static final DurationField cMinutesField;
    private static final DurationField cHoursField;
    private static final DurationField cHalfdaysField;
    private static final DurationField cDaysField;
    private static final DurationField cWeeksField;
    private static final DateTimeField cMillisOfSecondField;
    private static final DateTimeField cMillisOfDayField;
    private static final DateTimeField cSecondOfMinuteField;
    private static final DateTimeField cSecondOfDayField;
    private static final DateTimeField cMinuteOfHourField;
    private static final DateTimeField cMinuteOfDayField;
    private static final DateTimeField cHourOfDayField;
    private static final DateTimeField cHourOfHalfdayField;
    private static final DateTimeField cClockhourOfDayField;
    private static final DateTimeField cClockhourOfHalfdayField;
    private static final DateTimeField cHalfdayOfDayField;
    private transient YearInfo[] iYearInfoCache;
    private transient int iYearInfoCacheMask;
    private final int iMinDaysInFirstWeek;

    BaseGJChronology(Chronology base, Object param, int minDaysInFirstWeek) {
        super(base, param);
        int cacheSize;
        Integer i;
        if (minDaysInFirstWeek < 1 || minDaysInFirstWeek > 7) {
            throw new IllegalArgumentException("Invalid min days in first week: " + minDaysInFirstWeek);
        }
        this.iMinDaysInFirstWeek = minDaysInFirstWeek;
        try {
            i = Integer.getInteger(this.getClass().getName().concat(".yearInfoCacheSize"));
        }
        catch (SecurityException e) {
            i = null;
        }
        if (i == null) {
            cacheSize = 1024;
        } else {
            cacheSize = i;
            --cacheSize;
            int shift = 0;
            while (cacheSize > 0) {
                ++shift;
                cacheSize >>= 1;
            }
            cacheSize = 1 << shift;
        }
        this.iYearInfoCache = new YearInfo[cacheSize];
        this.iYearInfoCacheMask = cacheSize - 1;
    }

    public DateTimeZone getZone() {
        Chronology base = this.getBase();
        if (base != null) {
            return base.getZone();
        }
        return DateTimeZone.UTC;
    }

    public final long getDateTimeMillis(int year, int monthOfYear, int dayOfMonth, int millisOfDay) throws IllegalArgumentException {
        Chronology base = this.getBase();
        if (base != null) {
            return base.getDateTimeMillis(year, monthOfYear, dayOfMonth, millisOfDay);
        }
        FieldUtils.verifyValueBounds("millisOfDay", millisOfDay, 0, 86400000);
        return this.getDateMidnightMillis(year, monthOfYear, dayOfMonth) + (long)millisOfDay;
    }

    public final long getDateTimeMillis(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond) throws IllegalArgumentException {
        Chronology base = this.getBase();
        if (base != null) {
            return base.getDateTimeMillis(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond);
        }
        FieldUtils.verifyValueBounds("hourOfDay", hourOfDay, 0, 23);
        FieldUtils.verifyValueBounds("minuteOfHour", minuteOfHour, 0, 59);
        FieldUtils.verifyValueBounds("secondOfMinute", secondOfMinute, 0, 59);
        FieldUtils.verifyValueBounds("millisOfSecond", millisOfSecond, 0, 999);
        return this.getDateMidnightMillis(year, monthOfYear, dayOfMonth) + (long)(hourOfDay * 3600000) + (long)(minuteOfHour * 60000) + (long)(secondOfMinute * 1000) + (long)millisOfSecond;
    }

    public final int getMinimumDaysInFirstWeek() {
        return this.iMinDaysInFirstWeek;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(60);
        String name = this.getClass().getName();
        int index = name.lastIndexOf(46);
        if (index >= 0) {
            name = name.substring(index + 1);
        }
        sb.append(name);
        sb.append('[');
        DateTimeZone zone = this.getZone();
        if (zone != null) {
            sb.append(zone.getID());
        }
        if (this.getMinimumDaysInFirstWeek() != 4) {
            sb.append(",mdfw=");
            sb.append(this.getMinimumDaysInFirstWeek());
        }
        sb.append(']');
        return sb.toString();
    }

    protected void assemble(AssembledChronology.Fields fields) {
        fields.millis = cMillisField;
        fields.seconds = cSecondsField;
        fields.minutes = cMinutesField;
        fields.hours = cHoursField;
        fields.halfdays = cHalfdaysField;
        fields.days = cDaysField;
        fields.weeks = cWeeksField;
        fields.millisOfSecond = cMillisOfSecondField;
        fields.millisOfDay = cMillisOfDayField;
        fields.secondOfMinute = cSecondOfMinuteField;
        fields.secondOfDay = cSecondOfDayField;
        fields.minuteOfHour = cMinuteOfHourField;
        fields.minuteOfDay = cMinuteOfDayField;
        fields.hourOfDay = cHourOfDayField;
        fields.hourOfHalfday = cHourOfHalfdayField;
        fields.clockhourOfDay = cClockhourOfDayField;
        fields.clockhourOfHalfday = cClockhourOfHalfdayField;
        fields.halfdayOfDay = cHalfdayOfDayField;
        fields.year = new GJYearDateTimeField(this);
        fields.yearOfEra = new GJYearOfEraDateTimeField(fields.year, this);
        DecoratedDateTimeField field = new OffsetDateTimeField(fields.yearOfEra, 99);
        fields.centuryOfEra = new DividedDateTimeField(field, DateTimeFieldType.centuryOfEra(), 100);
        field = new RemainderDateTimeField((DividedDateTimeField)fields.centuryOfEra);
        fields.yearOfCentury = new OffsetDateTimeField(field, DateTimeFieldType.yearOfCentury(), 1);
        fields.era = new GJEraDateTimeField(this);
        fields.dayOfWeek = new GJDayOfWeekDateTimeField(this, fields.days);
        fields.dayOfMonth = new GJDayOfMonthDateTimeField(this, fields.days);
        fields.dayOfYear = new GJDayOfYearDateTimeField(this, fields.days);
        fields.monthOfYear = new GJMonthOfYearDateTimeField(this);
        fields.weekyear = new GJWeekyearDateTimeField(this);
        fields.weekOfWeekyear = new GJWeekOfWeekyearDateTimeField(this, fields.weeks);
        field = new RemainderDateTimeField(fields.weekyear, DateTimeFieldType.weekyearOfCentury(), 100);
        fields.weekyearOfCentury = new OffsetDateTimeField(field, DateTimeFieldType.weekyearOfCentury(), 1);
        fields.years = fields.year.getDurationField();
        fields.centuries = fields.centuryOfEra.getDurationField();
        fields.months = fields.monthOfYear.getDurationField();
        fields.weekyears = fields.weekyear.getDurationField();
    }

    final int getDaysInYear(int year) {
        return this.isLeapYear(year) ? 366 : 365;
    }

    final int getDaysInYearMonth(int year, int month) {
        if (this.isLeapYear(year)) {
            return MAX_DAYS_PER_MONTH_ARRAY[month - 1];
        }
        return MIN_DAYS_PER_MONTH_ARRAY[month - 1];
    }

    final int getDaysInMonthMax(int month) {
        return MAX_DAYS_PER_MONTH_ARRAY[month - 1];
    }

    final long getTotalMillisByYearMonth(int year, int month) {
        if (this.isLeapYear(year)) {
            return MAX_TOTAL_MILLIS_BY_MONTH_ARRAY[month - 1];
        }
        return MIN_TOTAL_MILLIS_BY_MONTH_ARRAY[month - 1];
    }

    final int getWeeksInYear(int year) {
        long firstWeekMillis1 = this.getFirstWeekOfYearMillis(year);
        long firstWeekMillis2 = this.getFirstWeekOfYearMillis(year + 1);
        return (int)((firstWeekMillis2 - firstWeekMillis1) / 604800000L);
    }

    final long getFirstWeekOfYearMillis(int year) {
        long jan1millis = this.getYearMillis(year);
        int jan1dayOfWeek = this.getDayOfWeek(jan1millis);
        if (jan1dayOfWeek > 8 - this.iMinDaysInFirstWeek) {
            return jan1millis + (long)(8 - jan1dayOfWeek) * 86400000L;
        }
        return jan1millis - (long)(jan1dayOfWeek - 1) * 86400000L;
    }

    final long getYearMillis(int year) {
        return this.getYearInfo((int)year).iFirstDayMillis;
    }

    final long getYearMonthMillis(int year, int month) {
        long millis = this.getYearMillis(year);
        if (month > 1) {
            millis += this.getTotalMillisByYearMonth(year, month - 1);
        }
        return millis;
    }

    final long getYearMonthDayMillis(int year, int month, int dayOfMonth) {
        long millis = this.getYearMillis(year);
        if (month > 1) {
            millis += this.getTotalMillisByYearMonth(year, month - 1);
        }
        return millis + (long)(dayOfMonth - 1) * 86400000L;
    }

    final int getYear(long instant) {
        int year;
        long yearStart;
        long diff;
        long unitMillis = this.getAverageMillisPerYear();
        long i2 = instant + this.getApproxMillisAtEpoch();
        if (i2 < 0L) {
            i2 = i2 - unitMillis + 1L;
        }
        if ((diff = instant - (yearStart = this.getYearMillis(year = (int)(i2 / unitMillis)))) < 0L) {
            if (diff < -172800000L) {
                return this.getYearOverflow(instant);
            }
            --year;
        } else if (diff >= 31536000000L) {
            if (diff >= 31708800000L) {
                return this.getYearOverflow(instant);
            }
            long oneYear = this.isLeapYear(year) ? 31622400000L : 31536000000L;
            if (((yearStart += oneYear) ^ instant) < 0L && (yearStart < 0L && yearStart - oneYear >= 0L || yearStart >= 0L && yearStart - oneYear < 0L)) {
                return this.getYearOverflow(instant);
            }
            if (yearStart <= instant) {
                ++year;
            }
        }
        return year;
    }

    private final int getYearOverflow(long instant) {
        if (instant > 0L) {
            int year = this.getMaxYear();
            long yearStartMillis = this.getYearMillis(year);
            yearStartMillis = this.isLeapYear(year) ? (yearStartMillis += 31622400000L) : (yearStartMillis += 31536000000L);
            long yearEndMillis = yearStartMillis - 1L;
            if (instant <= yearEndMillis) {
                return year;
            }
            throw new IllegalArgumentException("Instant too large: " + instant + " > " + yearEndMillis);
        }
        int year = this.getMinYear();
        long yearStartMillis = this.getYearMillis(year);
        if (instant >= yearStartMillis) {
            return year;
        }
        throw new IllegalArgumentException("Instant too small: " + instant + " < " + yearStartMillis);
    }

    final long setYear(long instant, int year) {
        int thisYear = this.getYear(instant);
        int dayOfYear = this.getDayOfYear(instant, thisYear);
        int millisOfDay = this.getMillisOfDay(instant);
        if (dayOfYear > 59) {
            if (this.isLeapYear(thisYear)) {
                if (!this.isLeapYear(year)) {
                    --dayOfYear;
                }
            } else if (this.isLeapYear(year)) {
                ++dayOfYear;
            }
        }
        instant = this.getYearMonthDayMillis(year, 1, dayOfYear);
        return instant += (long)millisOfDay;
    }

    final int getMonthOfYear(long millis) {
        return this.getMonthOfYear(millis, this.getYear(millis));
    }

    final int getMonthOfYear(long millis, int year) {
        int i = (int)(millis - this.getYearMillis(year) >> 10);
        return this.isLeapYear(year) ? (i < 15356250 ? (i < 7678125 ? (i < 2615625 ? 1 : (i < 5062500 ? 2 : 3)) : (i < 10209375 ? 4 : (i < 12825000 ? 5 : 6))) : (i < 23118750 ? (i < 17971875 ? 7 : (i < 20587500 ? 8 : 9)) : (i < 25734375 ? 10 : (i < 28265625 ? 11 : 12)))) : (i < 15271875 ? (i < 7593750 ? (i < 2615625 ? 1 : (i < 4978125 ? 2 : 3)) : (i < 10125000 ? 4 : (i < 12740625 ? 5 : 6))) : (i < 23034375 ? (i < 17887500 ? 7 : (i < 20503125 ? 8 : 9)) : (i < 25650000 ? 10 : (i < 28181250 ? 11 : 12))));
    }

    final int getDayOfMonth(long millis) {
        int year = this.getYear(millis);
        int month = this.getMonthOfYear(millis, year);
        return this.getDayOfMonth(millis, year, month);
    }

    final int getDayOfMonth(long millis, int year) {
        int month = this.getMonthOfYear(millis, year);
        return this.getDayOfMonth(millis, year, month);
    }

    final int getDayOfMonth(long millis, int year, int month) {
        long dateMillis = this.getYearMillis(year);
        if (month > 1) {
            dateMillis += this.getTotalMillisByYearMonth(year, month - 1);
        }
        return (int)((millis - dateMillis) / 86400000L) + 1;
    }

    final int getDayOfYear(long instant) {
        return this.getDayOfYear(instant, this.getYear(instant));
    }

    final int getDayOfYear(long instant, int year) {
        long yearStart = this.getYearMillis(year);
        return (int)((instant - yearStart) / 86400000L) + 1;
    }

    final int getWeekyear(long instant) {
        int year = this.getYear(instant);
        int week = this.getWeekOfWeekyear(instant, year);
        if (week == 1) {
            return this.getYear(instant + 604800000L);
        }
        if (week > 51) {
            return this.getYear(instant - 1209600000L);
        }
        return year;
    }

    final int getWeekOfWeekyear(long instant) {
        return this.getWeekOfWeekyear(instant, this.getYear(instant));
    }

    final int getWeekOfWeekyear(long instant, int year) {
        long firstWeekMillis1 = this.getFirstWeekOfYearMillis(year);
        if (instant < firstWeekMillis1) {
            return this.getWeeksInYear(year - 1);
        }
        long firstWeekMillis2 = this.getFirstWeekOfYearMillis(year + 1);
        if (instant >= firstWeekMillis2) {
            return 1;
        }
        return (int)((instant - firstWeekMillis1) / 604800000L) + 1;
    }

    final int getDayOfWeek(long instant) {
        long daysSince19700101;
        if (instant >= 0L) {
            daysSince19700101 = instant / 86400000L;
        } else {
            daysSince19700101 = (instant - 86399999L) / 86400000L;
            if (daysSince19700101 < -3L) {
                return 7 + (int)((daysSince19700101 + 4L) % 7L);
            }
        }
        return 1 + (int)((daysSince19700101 + 3L) % 7L);
    }

    final int getMillisOfDay(long instant) {
        if (instant >= 0L) {
            return (int)(instant % 86400000L);
        }
        return 86399999 + (int)((instant + 1L) % 86400000L);
    }

    long getDateMidnightMillis(int year, int monthOfYear, int dayOfMonth) throws IllegalArgumentException {
        FieldUtils.verifyValueBounds("year", year, this.getMinYear(), this.getMaxYear());
        FieldUtils.verifyValueBounds("monthOfYear", monthOfYear, 1, 12);
        boolean isLeap = this.isLeapYear(year);
        FieldUtils.verifyValueBounds("dayOfMonth", dayOfMonth, 1, (isLeap ? MAX_DAYS_PER_MONTH_ARRAY : MIN_DAYS_PER_MONTH_ARRAY)[monthOfYear - 1]);
        long instant = this.getYearMillis(year);
        if (monthOfYear > 1) {
            instant += (isLeap ? MAX_TOTAL_MILLIS_BY_MONTH_ARRAY : MIN_TOTAL_MILLIS_BY_MONTH_ARRAY)[monthOfYear - 2];
        }
        if (dayOfMonth != 1) {
            instant += (long)(dayOfMonth - 1) * 86400000L;
        }
        return instant;
    }

    abstract boolean isLeapYear(int var1);

    abstract long calculateFirstDayOfYearMillis(int var1);

    abstract int getMinYear();

    abstract int getMaxYear();

    abstract long getAverageMillisPerYear();

    abstract long getAverageMillisPerMonth();

    abstract long getApproxMillisAtEpoch();

    private YearInfo getYearInfo(int year) {
        YearInfo[] cache = this.iYearInfoCache;
        int index = year & this.iYearInfoCacheMask;
        YearInfo info = cache[index];
        if (info == null || info.iYear != year) {
            cache[index] = info = new YearInfo(year, this.calculateFirstDayOfYearMillis(year));
        }
        return info;
    }

    static {
        long minSum = 0L;
        long maxSum = 0L;
        int i = 0;
        while (i < 12) {
            long millis = (long)MIN_DAYS_PER_MONTH_ARRAY[i] * 86400000L;
            BaseGJChronology.MIN_TOTAL_MILLIS_BY_MONTH_ARRAY[i] = minSum += millis;
            millis = (long)MAX_DAYS_PER_MONTH_ARRAY[i] * 86400000L;
            BaseGJChronology.MAX_TOTAL_MILLIS_BY_MONTH_ARRAY[i] = maxSum += millis;
            ++i;
        }
        cMillisField = MillisDurationField.INSTANCE;
        cSecondsField = new PreciseDurationField(DurationFieldType.seconds(), 1000L);
        cMinutesField = new PreciseDurationField(DurationFieldType.minutes(), 60000L);
        cHoursField = new PreciseDurationField(DurationFieldType.hours(), 3600000L);
        cHalfdaysField = new PreciseDurationField(DurationFieldType.halfdays(), 43200000L);
        cDaysField = new PreciseDurationField(DurationFieldType.days(), 86400000L);
        cWeeksField = new PreciseDurationField(DurationFieldType.weeks(), 604800000L);
        cMillisOfSecondField = new PreciseDateTimeField(DateTimeFieldType.millisOfSecond(), cMillisField, cSecondsField);
        cMillisOfDayField = new PreciseDateTimeField(DateTimeFieldType.millisOfDay(), cMillisField, cDaysField);
        cSecondOfMinuteField = new PreciseDateTimeField(DateTimeFieldType.secondOfMinute(), cSecondsField, cMinutesField);
        cSecondOfDayField = new PreciseDateTimeField(DateTimeFieldType.secondOfDay(), cSecondsField, cDaysField);
        cMinuteOfHourField = new PreciseDateTimeField(DateTimeFieldType.minuteOfHour(), cMinutesField, cHoursField);
        cMinuteOfDayField = new PreciseDateTimeField(DateTimeFieldType.minuteOfDay(), cMinutesField, cDaysField);
        cHourOfDayField = new PreciseDateTimeField(DateTimeFieldType.hourOfDay(), cHoursField, cDaysField);
        cHourOfHalfdayField = new PreciseDateTimeField(DateTimeFieldType.hourOfHalfday(), cHoursField, cHalfdaysField);
        cClockhourOfDayField = new NonZeroDateTimeField(cHourOfDayField, DateTimeFieldType.clockhourOfDay());
        cClockhourOfHalfdayField = new NonZeroDateTimeField(cHourOfHalfdayField, DateTimeFieldType.clockhourOfHalfday());
        cHalfdayOfDayField = new HalfdayField();
    }

    private static class YearInfo {
        public final int iYear;
        public final long iFirstDayMillis;

        YearInfo(int year, long firstDayMillis) {
            this.iYear = year;
            this.iFirstDayMillis = firstDayMillis;
        }
    }

    private static class HalfdayField
    extends PreciseDateTimeField {
        private static final long serialVersionUID = 581601443656929254L;

        HalfdayField() {
            super(DateTimeFieldType.halfdayOfDay(), cHalfdaysField, cDaysField);
        }

        protected String getAsText(int fieldValue, Locale locale) {
            return GJLocaleSymbols.forLocale(locale).halfdayValueToText(fieldValue);
        }

        public long set(long millis, String text, Locale locale) {
            return this.set(millis, GJLocaleSymbols.forLocale(locale).halfdayTextToValue(text));
        }

        public int getMaximumTextLength(Locale locale) {
            return GJLocaleSymbols.forLocale(locale).getHalfdayMaxTextLength();
        }
    }
}

