/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.util.HashMap;
import java.util.Map;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.chrono.AssembledChronology;
import org.joda.time.chrono.BaseGJChronology;
import org.joda.time.chrono.CopticDayOfMonthDateTimeField;
import org.joda.time.chrono.CopticEraDateTimeField;
import org.joda.time.chrono.CopticMonthOfYearDateTimeField;
import org.joda.time.chrono.CopticYearDateTimeField;
import org.joda.time.chrono.JulianChronology;
import org.joda.time.chrono.LimitChronology;
import org.joda.time.chrono.ZonedChronology;
import org.joda.time.field.FieldUtils;
import org.joda.time.field.PreciseDurationField;

public final class CopticChronology
extends BaseGJChronology {
    private static final long serialVersionUID = -5972804258688333942L;
    public static final int AM = 1;
    private static final long MILLIS_PER_YEAR = 31557600000L;
    private static final long MILLIS_PER_MONTH = 2629800000L;
    private static final DurationField cMonthsField;
    private static final CopticChronology INSTANCE_UTC;
    private static final Map cCache;

    public static CopticChronology getInstanceUTC() {
        return INSTANCE_UTC;
    }

    public static CopticChronology getInstance() {
        return CopticChronology.getInstance(DateTimeZone.getDefault(), 4);
    }

    public static CopticChronology getInstance(DateTimeZone zone) {
        return CopticChronology.getInstance(zone, 4);
    }

    public static CopticChronology getInstance(DateTimeZone zone, int minDaysInFirstWeek) {
        CopticChronology chrono;
        if (zone == null) {
            zone = DateTimeZone.getDefault();
        }
        Map map = cCache;
        synchronized (map) {
            CopticChronology[] chronos = (CopticChronology[])cCache.get(zone);
            if (chronos == null) {
                chronos = new CopticChronology[7];
                cCache.put(zone, chronos);
            }
            try {
                chrono = chronos[minDaysInFirstWeek - 1];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Invalid min days in first week: " + minDaysInFirstWeek);
            }
            if (chrono == null) {
                if (zone == DateTimeZone.UTC) {
                    chrono = new CopticChronology(null, null, minDaysInFirstWeek);
                    DateTime lowerLimit = new DateTime(1, 1, 1, 0, 0, 0, 0, chrono);
                    chrono = new CopticChronology(LimitChronology.getInstance(chrono, lowerLimit, null), null, minDaysInFirstWeek);
                } else {
                    chrono = CopticChronology.getInstance(DateTimeZone.UTC, minDaysInFirstWeek);
                    chrono = new CopticChronology(ZonedChronology.getInstance(chrono, zone), null, minDaysInFirstWeek);
                }
                chronos[minDaysInFirstWeek - 1] = chrono;
            }
        }
        return chrono;
    }

    CopticChronology(Chronology base, Object param, int minDaysInFirstWeek) {
        super(base, param, minDaysInFirstWeek);
    }

    private Object readResolve() {
        Chronology base = this.getBase();
        return base == null ? CopticChronology.getInstanceUTC() : CopticChronology.getInstance(base.getZone());
    }

    public Chronology withUTC() {
        return INSTANCE_UTC;
    }

    public Chronology withZone(DateTimeZone zone) {
        if (zone == null) {
            zone = DateTimeZone.getDefault();
        }
        if (zone == this.getZone()) {
            return this;
        }
        return CopticChronology.getInstance(zone);
    }

    long getDateMidnightMillis(int year, int monthOfYear, int dayOfMonth) throws IllegalArgumentException {
        FieldUtils.verifyValueBounds("year", year, this.getMinYear(), this.getMaxYear());
        FieldUtils.verifyValueBounds("monthOfYear", monthOfYear, 1, 13);
        int dayLimit = monthOfYear != 13 ? 30 : (this.isLeapYear(year) ? 6 : 5);
        FieldUtils.verifyValueBounds("dayOfMonth", dayOfMonth, 1, dayLimit);
        long instant = this.getYearMillis(year);
        if (monthOfYear > 1) {
            instant += (long)(monthOfYear - 1) * 30L * 86400000L;
        }
        if (dayOfMonth != 1) {
            instant += (long)(dayOfMonth - 1) * 86400000L;
        }
        return instant;
    }

    boolean isLeapYear(int year) {
        return (year & 3) == 3;
    }

    long calculateFirstDayOfYearMillis(int year) {
        int leapYears;
        int relativeYear = year - 1687;
        if (relativeYear <= 0) {
            leapYears = relativeYear + 3 >> 2;
        } else {
            leapYears = relativeYear >> 2;
            if (!this.isLeapYear(year)) {
                ++leapYears;
            }
        }
        long millis = ((long)relativeYear * 365L + (long)leapYears) * 86400000L;
        return millis + 21859200000L;
    }

    int getMinYear() {
        return -292269337;
    }

    int getMaxYear() {
        return 292271022;
    }

    long getAverageMillisPerYear() {
        return 31557600000L;
    }

    long getAverageMillisPerMonth() {
        return 2629800000L;
    }

    long getApproxMillisAtEpoch() {
        return 53215790400000L;
    }

    protected void assemble(AssembledChronology.Fields fields) {
        if (this.getBase() == null) {
            super.assemble(fields);
            fields.year = new CopticYearDateTimeField(this);
            fields.years = fields.year.getDurationField();
            fields.year = new JulianChronology.NoYearZeroField(this, fields.year);
            fields.weekyear = new JulianChronology.NoWeekyearZeroField(this, fields.weekyear);
            fields.era = CopticEraDateTimeField.INSTANCE;
            fields.months = cMonthsField;
            fields.monthOfYear = new CopticMonthOfYearDateTimeField(this, cMonthsField);
            fields.dayOfMonth = new CopticDayOfMonthDateTimeField(this, fields.days);
        }
    }

    static {
        cCache = new HashMap();
        cMonthsField = new PreciseDurationField(DurationFieldType.months(), 2592000000L);
        INSTANCE_UTC = CopticChronology.getInstance(DateTimeZone.UTC);
    }
}

