/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.BaseGJChronology;
import org.joda.time.field.PreciseDurationDateTimeField;

final class GJDayOfYearDateTimeField
extends PreciseDurationDateTimeField {
    private static final long serialVersionUID = -6821236822336841037L;
    private final BaseGJChronology iChronology;

    GJDayOfYearDateTimeField(BaseGJChronology chronology, DurationField days) {
        super(DateTimeFieldType.dayOfYear(), days);
        this.iChronology = chronology;
    }

    public int get(long instant) {
        return this.iChronology.getDayOfYear(instant);
    }

    public DurationField getRangeDurationField() {
        return this.iChronology.years();
    }

    public int getMinimumValue() {
        return 1;
    }

    public int getMaximumValue() {
        return 366;
    }

    public int getMaximumValue(long instant) {
        int year = this.iChronology.getYear(instant);
        return this.iChronology.getDaysInYear(year);
    }

    public int getMaximumValue(ReadablePartial partial) {
        if (partial.isSupported(DateTimeFieldType.year())) {
            int year = partial.get(DateTimeFieldType.year());
            return this.iChronology.getDaysInYear(year);
        }
        return 366;
    }

    public int getMaximumValue(ReadablePartial partial, int[] values) {
        int size = partial.size();
        int i = 0;
        while (i < size) {
            if (partial.getFieldType(i) == DateTimeFieldType.year()) {
                int year = values[i];
                return this.iChronology.getDaysInYear(year);
            }
            ++i;
        }
        return 366;
    }

    protected int getMaximumValueForSet(long instant, int value) {
        return value > 365 ? this.getMaximumValue(instant) : 365;
    }

    private Object readResolve() {
        return this.iChronology.dayOfYear();
    }
}

