/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import java.io.Serializable;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DurationField;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;

public abstract class AbstractReadableInstantFieldProperty
implements Serializable {
    private static final long serialVersionUID = 1971226328211649661L;

    public abstract DateTimeField getField();

    public DateTimeFieldType getFieldType() {
        return this.getField().getType();
    }

    public String getName() {
        return this.getField().getName();
    }

    public abstract ReadableInstant getReadableInstant();

    public int get() {
        return this.getField().get(this.getReadableInstant().getMillis());
    }

    public String getAsText(Locale locale) {
        return this.getField().getAsText(this.getReadableInstant().getMillis(), locale);
    }

    public final String getAsText() {
        return this.getAsText(null);
    }

    public String getAsShortText(Locale locale) {
        return this.getField().getAsShortText(this.getReadableInstant().getMillis(), locale);
    }

    public final String getAsShortText() {
        return this.getAsShortText(null);
    }

    public int getDifference(ReadableInstant instant) {
        if (instant == null) {
            return this.getField().getDifference(this.getReadableInstant().getMillis(), DateTimeUtils.currentTimeMillis());
        }
        return this.getField().getDifference(this.getReadableInstant().getMillis(), instant.getMillis());
    }

    public long getDifferenceAsLong(ReadableInstant instant) {
        if (instant == null) {
            return this.getField().getDifferenceAsLong(this.getReadableInstant().getMillis(), DateTimeUtils.currentTimeMillis());
        }
        return this.getField().getDifferenceAsLong(this.getReadableInstant().getMillis(), instant.getMillis());
    }

    public DurationField getDurationField() {
        return this.getField().getDurationField();
    }

    public DurationField getRangeDurationField() {
        return this.getField().getRangeDurationField();
    }

    public boolean isLeap() {
        return this.getField().isLeap(this.getReadableInstant().getMillis());
    }

    public int getLeapAmount() {
        return this.getField().getLeapAmount(this.getReadableInstant().getMillis());
    }

    public DurationField getLeapDurationField() {
        return this.getField().getLeapDurationField();
    }

    public int getMinimumValueOverall() {
        return this.getField().getMinimumValue();
    }

    public int getMinimumValue() {
        return this.getField().getMinimumValue(this.getReadableInstant().getMillis());
    }

    public int getMaximumValueOverall() {
        return this.getField().getMaximumValue();
    }

    public int getMaximumValue() {
        return this.getField().getMaximumValue(this.getReadableInstant().getMillis());
    }

    public int getMaximumTextLength(Locale locale) {
        return this.getField().getMaximumTextLength(locale);
    }

    public int getMaximumShortTextLength(Locale locale) {
        return this.getField().getMaximumShortTextLength(locale);
    }

    public long remainder() {
        return this.getField().remainder(this.getReadableInstant().getMillis());
    }

    public int compareTo(ReadableInstant instant) {
        if (instant == null) {
            throw new IllegalArgumentException("The instant must not be null");
        }
        int thisValue = this.get();
        Chronology chrono = DateTimeUtils.getChronology(instant.getChronology());
        int otherValue = this.getFieldType().getField(chrono).get(instant.getMillis());
        if (thisValue < otherValue) {
            return -1;
        }
        if (thisValue > otherValue) {
            return 1;
        }
        return 0;
    }

    public int compareTo(ReadablePartial partial) {
        int otherValue;
        if (partial == null) {
            throw new IllegalArgumentException("The instant must not be null");
        }
        int thisValue = this.get();
        if (thisValue < (otherValue = partial.get(this.getFieldType()))) {
            return -1;
        }
        if (thisValue > otherValue) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof AbstractReadableInstantFieldProperty) {
            AbstractReadableInstantFieldProperty other = (AbstractReadableInstantFieldProperty)object;
            if (this.get() == other.get() && this.getFieldType() == other.getFieldType() && this.getReadableInstant().getChronology() == other.getReadableInstant().getChronology()) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "Property[" + this.getName() + "]";
    }
}

